/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
freier Text.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 15
 */
public class AtlRdsText implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "")
			private String
			 _text
			= new String
			()
			;
			@Defaultwert(wert = "deutsch (Standard)")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsNachrichtenSprache
			 _textSprache
			;
	
		/**
		freier Text.
		<p>
		TIC Info XML Element: FreeTextText'
		</p>
		
		@return der Wert von Text.
		*/
			public String
			 getText() {
			return _text;
		}
	
		/**
		freier Text.
		<p>
		TIC Info XML Element: FreeTextText'
		</p>
		
		@param _text der neue Wert von Text.
		*/
		public void setText(String
		 _text) {
			if (_text.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._text = _text;
		}
	
		/**
		Sprachkennung der Nachrichtentexte.
		<p>
		TIC Info XML Element: FreeTextLangID,  spezifiziert die Sprache des Textes entsprechend TIC Info Specification: Anhang 'Language Identifier'
		</p>
		
		@return der Wert von TextSprache.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsNachrichtenSprache
			 getTextSprache() {
			return _textSprache;
		}
	
		/**
		Sprachkennung der Nachrichtentexte.
		<p>
		TIC Info XML Element: FreeTextLangID,  spezifiziert die Sprache des Textes entsprechend TIC Info Specification: Anhang 'Language Identifier'
		</p>
		
		@param _textSprache der neue Wert von TextSprache.
		*/
		public void setTextSprache(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsNachrichtenSprache
		 _textSprache) {
			this._textSprache = _textSprache;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getText() != null) {
					datum.getTextValue("Text").setText(getText());
				}
				// GanzzahlAttributTyp
				if (getTextSprache() != null) {
	                if (getTextSprache().isZustand()) {
	                    datum.getUnscaledValue("TextSprache").setText(getTextSprache().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("TextSprache").set(getTextSprache().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setText(daten.getTextValue("Text").getText());
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("TextSprache").isState()) {
							setTextSprache(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsNachrichtenSprache
							.getZustand(daten.getScaledValue("TextSprache").getText()));
						} else {
						setTextSprache(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsNachrichtenSprache
						(daten.
							getUnscaledValue
						("TextSprache").
								shortValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlRdsText clone() {
		AtlRdsText klon = new AtlRdsText();
		
						klon.setText(getText());
						klon.setTextSprache(getTextSprache());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
