/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Verkehrsinformationen der Version.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 15
 */
public class AtlRdsVerkehr implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "0")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttZahl0Bis65535
			 _rDSFormat
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsNachrichten
			 _nachrichten
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsNachrichten
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsText
			 _freierText
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsText
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsLocationTabelleInfo
			 _locationTabelleInfo
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsLocationTabelleInfo
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsLocationDaten
			 _locationDaten
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsLocationDaten
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsEreignis
			 _ereignis
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsEreignis
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsAttribute
			 _zusatzAttribute
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsAttribute
			()
			;
			@Defaultwert(wert = "")
			private String
			 _alertCCode
			= new String
			()
			;
	
		/**
		Format der Verkehrsinformationen (für zukünftige Erweiterungen).
		<p>
		TIC Info XML Element: Format, kennzeichnet das Format der Verkehrsinformationen (reserviert für zukünftige Erweiterungen).
		</p>
		
		@return der Wert von RDSFormat.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttZahl0Bis65535
			 getRDSFormat() {
			return _rDSFormat;
		}
	
		/**
		Format der Verkehrsinformationen (für zukünftige Erweiterungen).
		<p>
		TIC Info XML Element: Format, kennzeichnet das Format der Verkehrsinformationen (reserviert für zukünftige Erweiterungen).
		</p>
		
		@param _rDSFormat der neue Wert von RDSFormat.
		*/
		public void setRDSFormat(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttZahl0Bis65535
		 _rDSFormat) {
			this._rDSFormat = _rDSFormat;
		}
	
		/**
		Die Nachrichtentexte.
		<p>
		TIC Info XML Element: Message, enthält alle textuellen Nachrichten zur Meldung.
		</p>
		
		@return der Wert von Nachrichten.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsNachrichten
			 getNachrichten() {
			return _nachrichten;
		}
	
		/**
		Die Nachrichtentexte.
		<p>
		TIC Info XML Element: Message, enthält alle textuellen Nachrichten zur Meldung.
		</p>
		
		@param _nachrichten der neue Wert von Nachrichten.
		*/
		public void setNachrichten(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsNachrichten
		 _nachrichten) {
			this._nachrichten = _nachrichten;
		}
	
		/**
		freier Text.
		<p>
		TIC Info XML Element: FreeText.
		</p>
		
		@return der Wert von FreierText.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsText
			 getFreierText() {
			return _freierText;
		}
	
		/**
		freier Text.
		<p>
		TIC Info XML Element: FreeText.
		</p>
		
		@param _freierText der neue Wert von FreierText.
		*/
		public void setFreierText(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsText
		 _freierText) {
			this._freierText = _freierText;
		}
	
		/**
		Informationen zur Location-Tabelle.
		<p>
		TIC Info XML Element: LocationTable, enhält alle Informationen zur benutzten Location-Tabelle.
		</p>
		
		@return der Wert von LocationTabelleInfo.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsLocationTabelleInfo
			 getLocationTabelleInfo() {
			return _locationTabelleInfo;
		}
	
		/**
		Informationen zur Location-Tabelle.
		<p>
		TIC Info XML Element: LocationTable, enhält alle Informationen zur benutzten Location-Tabelle.
		</p>
		
		@param _locationTabelleInfo der neue Wert von LocationTabelleInfo.
		*/
		public void setLocationTabelleInfo(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsLocationTabelleInfo
		 _locationTabelleInfo) {
			this._locationTabelleInfo = _locationTabelleInfo;
		}
	
		/**
		Location Informationen.
		<p>
		TIC Info XML Element: Location, enthält alle Informationen zur den Locationen.
		</p>
		
		@return der Wert von LocationDaten.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsLocationDaten
			 getLocationDaten() {
			return _locationDaten;
		}
	
		/**
		Location Informationen.
		<p>
		TIC Info XML Element: Location, enthält alle Informationen zur den Locationen.
		</p>
		
		@param _locationDaten der neue Wert von LocationDaten.
		*/
		public void setLocationDaten(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsLocationDaten
		 _locationDaten) {
			this._locationDaten = _locationDaten;
		}
	
		/**
		Ereignisdaten.
		<p>
		TIC Info XML Element: Event, enthält alle Daten zu den Ereignissen.
		</p>
		
		@return der Wert von Ereignis.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsEreignis
			 getEreignis() {
			return _ereignis;
		}
	
		/**
		Ereignisdaten.
		<p>
		TIC Info XML Element: Event, enthält alle Daten zu den Ereignissen.
		</p>
		
		@param _ereignis der neue Wert von Ereignis.
		*/
		public void setEreignis(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsEreignis
		 _ereignis) {
			this._ereignis = _ereignis;
		}
	
		/**
		zusätzliche Merkmale.
		<p>
		TIC Info XML Element: Attribute, zusätzliche Merkmale der Meldung.
		</p>
		
		@return der Wert von ZusatzAttribute.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsAttribute
			 getZusatzAttribute() {
			return _zusatzAttribute;
		}
	
		/**
		zusätzliche Merkmale.
		<p>
		TIC Info XML Element: Attribute, zusätzliche Merkmale der Meldung.
		</p>
		
		@param _zusatzAttribute der neue Wert von ZusatzAttribute.
		*/
		public void setZusatzAttribute(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsAttribute
		 _zusatzAttribute) {
			this._zusatzAttribute = _zusatzAttribute;
		}
	
		/**
		ALERT-C Kodierung.
		<p>
		TIC Info XML Element: Code, enthält die zugehörige ALERT-C Kodierung der Meldung.
		</p>
		
		@return der Wert von AlertCCode.
		*/
			public String
			 getAlertCCode() {
			return _alertCCode;
		}
	
		/**
		ALERT-C Kodierung.
		<p>
		TIC Info XML Element: Code, enthält die zugehörige ALERT-C Kodierung der Meldung.
		</p>
		
		@param _alertCCode der neue Wert von AlertCCode.
		*/
		public void setAlertCCode(String
		 _alertCCode) {
			if (_alertCCode.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._alertCCode = _alertCCode;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getRDSFormat() != null) {
	                if (getRDSFormat().isZustand()) {
	                    datum.getUnscaledValue("RDSFormat").setText(getRDSFormat().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("RDSFormat").set(getRDSFormat().getValue());
	                }
				}
				// AttributListenDefinition
					getNachrichten().bean2Atl(datum.getItem("Nachrichten"), factory);
				// AttributListenDefinition
					getFreierText().bean2Atl(datum.getItem("FreierText"), factory);
				// AttributListenDefinition
					getLocationTabelleInfo().bean2Atl(datum.getItem("LocationTabelleInfo"), factory);
				// AttributListenDefinition
					getLocationDaten().bean2Atl(datum.getItem("LocationDaten"), factory);
				// AttributListenDefinition
					getEreignis().bean2Atl(datum.getItem("Ereignis"), factory);
				// AttributListenDefinition
					getZusatzAttribute().bean2Atl(datum.getItem("ZusatzAttribute"), factory);
				// ZeichenkettenAttributTyp
				if (getAlertCCode() != null) {
					datum.getTextValue("AlertCCode").setText(getAlertCCode());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setRDSFormat(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttZahl0Bis65535
						(daten.
							getUnscaledValue
						("RDSFormat").
								intValue
						()));
				// AttributListenDefinition
					getNachrichten().atl2Bean(daten.getItem("Nachrichten"), factory);
				// AttributListenDefinition
					getFreierText().atl2Bean(daten.getItem("FreierText"), factory);
				// AttributListenDefinition
					getLocationTabelleInfo().atl2Bean(daten.getItem("LocationTabelleInfo"), factory);
				// AttributListenDefinition
					getLocationDaten().atl2Bean(daten.getItem("LocationDaten"), factory);
				// AttributListenDefinition
					getEreignis().atl2Bean(daten.getItem("Ereignis"), factory);
				// AttributListenDefinition
					getZusatzAttribute().atl2Bean(daten.getItem("ZusatzAttribute"), factory);
				// ZeichenkettenAttributTyp
					setAlertCCode(daten.getTextValue("AlertCCode").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlRdsVerkehr clone() {
		AtlRdsVerkehr klon = new AtlRdsVerkehr();
		
						klon.setRDSFormat(getRDSFormat());
						klon._nachrichten = getNachrichten().clone();
						klon._freierText = getFreierText().clone();
						klon._locationTabelleInfo = getLocationTabelleInfo().clone();
						klon._locationDaten = getLocationDaten().clone();
						klon._ereignis = getEreignis().clone();
						klon._zusatzAttribute = getZusatzAttribute().clone();
						klon.setAlertCCode(getAlertCCode());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
