/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Verwaltungsinformationen der Version.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 15
 */
public class AtlRdsVerwaltung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "")
			private String
			 _authorisierendeOrganisationsEinheit
			= new String
			()
			;
			@Defaultwert(wert = "")
			private String
			 _authorisierenderNutzer
			= new String
			()
			;
			@Defaultwert(wert = "01.01.1971 00:00:00,000 Uhr")
			private 	Zeitstempel
			 _authorisierungsZeit
			;
			@Defaultwert(wert = "")
			private String
			 _authorisierungsKommentar
			= new String
			()
			;
			@Defaultwert(wert = "(Noch) nicht authorisiert")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsAuthorisierungsErgebnis
			 _authorisierungsErgebnis
			;
			@Defaultwert(wert = "0")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttZahl0Bis65535
			 _versionsNummer
			;
			@Defaultwert(wert = "01.01.1971 00:00:00,000 Uhr")
			private 	Zeitstempel
			 _aktualisierungsZeit
			;
			@Defaultwert(wert = "01.01.1971 00:00:00,000 Uhr")
			private 	Zeitstempel
			 _aktivierungsZeit
			;
			@Defaultwert(wert = "01.01.1971 00:00:00,000 Uhr")
			private 	Zeitstempel
			 _ablaufZeit
			;
			@Defaultwert(wert = "01.01.1971 00:00:00,000 Uhr")
			private 	Zeitstempel
			 _erinnerungsZeit
			;
			@Defaultwert(wert = "0 Sekunden")
			private 	RelativerZeitstempel
			 _erinnerungsZeitOffset
			;
			@Defaultwert(wert = "ErinnerungsZeitOffset enthält den Offset seit AktivierungsZeit. ErinnerungsZeit = AktivierungsZeit + ErinnerungsZeitOffset.")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsErinnerungsTyp
			 _erinnerungsTyp
			;
			@Defaultwert(wert = "01.01.1971 00:00:00,000 Uhr")
			private 	Zeitstempel
			 _erzeugungsZeit
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsAenderungsInfo
			 _aenderungsInformationen
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsAenderungsInfo
			()
			;
			@Defaultwert(wert = "Unbekannt")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsStatus
			 _status
			;
			@Defaultwert(wert = "0")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsWichtung
			 _wichtung
			;
			@Defaultwert(wert = "Normal")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsPrioritaet
			 _prioritaet
			;
			@Defaultwert(wert = "rdsLandesKennung.DE")
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.objekte.RdsLandesKennung
			 _landesKennung
			;
			@Defaultwert(wert = "nicht quittiert")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsZustand
			 _zustand
			;
			@Defaultwert(wert = "manuell")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsQuelle
			 _quelle
			;
	
		/**
		Organisationseinheit der authorisierenden Institution.
		<p>
		TIC Info XML Element: AuthorizerOrganisationUnit, Organisationseinheit der authorisierenden Institution.
		</p>
		
		@return der Wert von AuthorisierendeOrganisationsEinheit.
		*/
			public String
			 getAuthorisierendeOrganisationsEinheit() {
			return _authorisierendeOrganisationsEinheit;
		}
	
		/**
		Organisationseinheit der authorisierenden Institution.
		<p>
		TIC Info XML Element: AuthorizerOrganisationUnit, Organisationseinheit der authorisierenden Institution.
		</p>
		
		@param _authorisierendeOrganisationsEinheit der neue Wert von AuthorisierendeOrganisationsEinheit.
		*/
		public void setAuthorisierendeOrganisationsEinheit(String
		 _authorisierendeOrganisationsEinheit) {
			if (_authorisierendeOrganisationsEinheit.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._authorisierendeOrganisationsEinheit = _authorisierendeOrganisationsEinheit;
		}
	
		/**
		Authorisierender Nutzer.
		<p>
		TIC Info XML Element: AuthorizerUserName, Name des Nutzers der authorisierenden Institution.
		</p>
		
		@return der Wert von AuthorisierenderNutzer.
		*/
			public String
			 getAuthorisierenderNutzer() {
			return _authorisierenderNutzer;
		}
	
		/**
		Authorisierender Nutzer.
		<p>
		TIC Info XML Element: AuthorizerUserName, Name des Nutzers der authorisierenden Institution.
		</p>
		
		@param _authorisierenderNutzer der neue Wert von AuthorisierenderNutzer.
		*/
		public void setAuthorisierenderNutzer(String
		 _authorisierenderNutzer) {
			if (_authorisierenderNutzer.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._authorisierenderNutzer = _authorisierenderNutzer;
		}
	
		/**
		Zeitpunkt der Authorisierung.
		<p>
		TIC Info XML Element: AuthorizerTime, Exakter Zeitpunkt der Authorisierung dieser Version.
		</p>
		
		@return der Wert von AuthorisierungsZeit.
		*/
			public 	Zeitstempel
			 getAuthorisierungsZeit() {
			return _authorisierungsZeit;
		}
	
		/**
		Zeitpunkt der Authorisierung.
		<p>
		TIC Info XML Element: AuthorizerTime, Exakter Zeitpunkt der Authorisierung dieser Version.
		</p>
		
		@param _authorisierungsZeit der neue Wert von AuthorisierungsZeit.
		*/
		public void setAuthorisierungsZeit(	Zeitstempel
		 _authorisierungsZeit) {
			this._authorisierungsZeit = _authorisierungsZeit;
		}
	
		/**
		Kommentar zur Authorisierung.
		<p>
		TIC Info XML Element: AuthorizerUserName, enhält den Grund der Zurückweisung oder einen Kommentar zur Authorisierung.
		</p>
		
		@return der Wert von AuthorisierungsKommentar.
		*/
			public String
			 getAuthorisierungsKommentar() {
			return _authorisierungsKommentar;
		}
	
		/**
		Kommentar zur Authorisierung.
		<p>
		TIC Info XML Element: AuthorizerUserName, enhält den Grund der Zurückweisung oder einen Kommentar zur Authorisierung.
		</p>
		
		@param _authorisierungsKommentar der neue Wert von AuthorisierungsKommentar.
		*/
		public void setAuthorisierungsKommentar(String
		 _authorisierungsKommentar) {
			if (_authorisierungsKommentar.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._authorisierungsKommentar = _authorisierungsKommentar;
		}
	
		/**
		Ergebnis der Authorisierung.
		<p>
		TIC Info XML Element: AuthorizerResult, Ergebniscode der Authorisierung.
		</p>
		
		@return der Wert von AuthorisierungsErgebnis.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsAuthorisierungsErgebnis
			 getAuthorisierungsErgebnis() {
			return _authorisierungsErgebnis;
		}
	
		/**
		Ergebnis der Authorisierung.
		<p>
		TIC Info XML Element: AuthorizerResult, Ergebniscode der Authorisierung.
		</p>
		
		@param _authorisierungsErgebnis der neue Wert von AuthorisierungsErgebnis.
		*/
		public void setAuthorisierungsErgebnis(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsAuthorisierungsErgebnis
		 _authorisierungsErgebnis) {
			this._authorisierungsErgebnis = _authorisierungsErgebnis;
		}
	
		/**
		Versionsnummer.
		<p>
		TIC Info XML Element: Versionnummer der Version.
		</p>
		
		@return der Wert von VersionsNummer.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttZahl0Bis65535
			 getVersionsNummer() {
			return _versionsNummer;
		}
	
		/**
		Versionsnummer.
		<p>
		TIC Info XML Element: Versionnummer der Version.
		</p>
		
		@param _versionsNummer der neue Wert von VersionsNummer.
		*/
		public void setVersionsNummer(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttZahl0Bis65535
		 _versionsNummer) {
			this._versionsNummer = _versionsNummer;
		}
	
		/**
		Zeitpunkt der Aktualisierung der Version.
		<p>
		TIC Info XML Element: UpdateTime, Exakter Zeitpunkt der Aktualisierung der Version.
		</p>
		
		@return der Wert von AktualisierungsZeit.
		*/
			public 	Zeitstempel
			 getAktualisierungsZeit() {
			return _aktualisierungsZeit;
		}
	
		/**
		Zeitpunkt der Aktualisierung der Version.
		<p>
		TIC Info XML Element: UpdateTime, Exakter Zeitpunkt der Aktualisierung der Version.
		</p>
		
		@param _aktualisierungsZeit der neue Wert von AktualisierungsZeit.
		*/
		public void setAktualisierungsZeit(	Zeitstempel
		 _aktualisierungsZeit) {
			this._aktualisierungsZeit = _aktualisierungsZeit;
		}
	
		/**
		Zeitpunkt des Beginns der Gültigkeit der Version.
		<p>
		TIC Info XML Element: ActivateTime, Exakter Zeitpunkt zu dem die Version gültig wurde.
		</p>
		
		@return der Wert von AktivierungsZeit.
		*/
			public 	Zeitstempel
			 getAktivierungsZeit() {
			return _aktivierungsZeit;
		}
	
		/**
		Zeitpunkt des Beginns der Gültigkeit der Version.
		<p>
		TIC Info XML Element: ActivateTime, Exakter Zeitpunkt zu dem die Version gültig wurde.
		</p>
		
		@param _aktivierungsZeit der neue Wert von AktivierungsZeit.
		*/
		public void setAktivierungsZeit(	Zeitstempel
		 _aktivierungsZeit) {
			this._aktivierungsZeit = _aktivierungsZeit;
		}
	
		/**
		Zeitpunkt des Endes der Gültigkeit der Version.
		<p>
		TIC Info XML Element: ExpiryTime, Exakter Zeitpunkt zu dem die Gültigkeit der Version endet.
		</p>
		
		@return der Wert von AblaufZeit.
		*/
			public 	Zeitstempel
			 getAblaufZeit() {
			return _ablaufZeit;
		}
	
		/**
		Zeitpunkt des Endes der Gültigkeit der Version.
		<p>
		TIC Info XML Element: ExpiryTime, Exakter Zeitpunkt zu dem die Gültigkeit der Version endet.
		</p>
		
		@param _ablaufZeit der neue Wert von AblaufZeit.
		*/
		public void setAblaufZeit(	Zeitstempel
		 _ablaufZeit) {
			this._ablaufZeit = _ablaufZeit;
		}
	
		/**
		Zeitpunkt zum Erinnern des Benutzers.
		<p>
		TIC Info XML Element: ReminderTime.
		</p>
		
		@return der Wert von ErinnerungsZeit.
		*/
			public 	Zeitstempel
			 getErinnerungsZeit() {
			return _erinnerungsZeit;
		}
	
		/**
		Zeitpunkt zum Erinnern des Benutzers.
		<p>
		TIC Info XML Element: ReminderTime.
		</p>
		
		@param _erinnerungsZeit der neue Wert von ErinnerungsZeit.
		*/
		public void setErinnerungsZeit(	Zeitstempel
		 _erinnerungsZeit) {
			this._erinnerungsZeit = _erinnerungsZeit;
		}
	
		/**
		Zeitbereich zur Berechnung der Erinnerungszeit.
		<p>
		TIC Info XML Element: ReminderTimeOffset.
		</p>
		
		@return der Wert von ErinnerungsZeitOffset.
		*/
			public 	RelativerZeitstempel
			 getErinnerungsZeitOffset() {
			return _erinnerungsZeitOffset;
		}
	
		/**
		Zeitbereich zur Berechnung der Erinnerungszeit.
		<p>
		TIC Info XML Element: ReminderTimeOffset.
		</p>
		
		@param _erinnerungsZeitOffset der neue Wert von ErinnerungsZeitOffset.
		*/
		public void setErinnerungsZeitOffset(	RelativerZeitstempel
		 _erinnerungsZeitOffset) {
			this._erinnerungsZeitOffset = _erinnerungsZeitOffset;
		}
	
		/**
		Definition der Benutzung von 'ErinnerungsZeit' und 'ErinnerungsZeitOffset'.
		<p>
		TIC Info XML Element: ReminderTimeType, definiert die Bildung der 'ErinnerungsZeit' aus 'ErinnerungsZeit' und 'ErinnerungsZeitOffset'.
		</p>
		
		@return der Wert von ErinnerungsTyp.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsErinnerungsTyp
			 getErinnerungsTyp() {
			return _erinnerungsTyp;
		}
	
		/**
		Definition der Benutzung von 'ErinnerungsZeit' und 'ErinnerungsZeitOffset'.
		<p>
		TIC Info XML Element: ReminderTimeType, definiert die Bildung der 'ErinnerungsZeit' aus 'ErinnerungsZeit' und 'ErinnerungsZeitOffset'.
		</p>
		
		@param _erinnerungsTyp der neue Wert von ErinnerungsTyp.
		*/
		public void setErinnerungsTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsErinnerungsTyp
		 _erinnerungsTyp) {
			this._erinnerungsTyp = _erinnerungsTyp;
		}
	
		/**
		Zeitpunkt, an dem die erste Version gültig wurde.
		<p>
		TIC Info XML Element: CreateTime, Exakter Zeitpunkt, an dem die erste Version dieser Meldung gültig wurde.
		</p>
		
		@return der Wert von ErzeugungsZeit.
		*/
			public 	Zeitstempel
			 getErzeugungsZeit() {
			return _erzeugungsZeit;
		}
	
		/**
		Zeitpunkt, an dem die erste Version gültig wurde.
		<p>
		TIC Info XML Element: CreateTime, Exakter Zeitpunkt, an dem die erste Version dieser Meldung gültig wurde.
		</p>
		
		@param _erzeugungsZeit der neue Wert von ErzeugungsZeit.
		*/
		public void setErzeugungsZeit(	Zeitstempel
		 _erzeugungsZeit) {
			this._erzeugungsZeit = _erzeugungsZeit;
		}
	
		/**
		Informationen zu Änderungen.
		<p>
		TIC Info XML Element: Modifier, alle Informationen zu Änderungen an Meldungen.
		</p>
		
		@return der Wert von AenderungsInformationen.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsAenderungsInfo
			 getAenderungsInformationen() {
			return _aenderungsInformationen;
		}
	
		/**
		Informationen zu Änderungen.
		<p>
		TIC Info XML Element: Modifier, alle Informationen zu Änderungen an Meldungen.
		</p>
		
		@param _aenderungsInformationen der neue Wert von AenderungsInformationen.
		*/
		public void setAenderungsInformationen(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AtlRdsAenderungsInfo
		 _aenderungsInformationen) {
			this._aenderungsInformationen = _aenderungsInformationen;
		}
	
		/**
		Status der Version.
		<p>
		TIC Info XML Element: Status.
		</p>
		
		@return der Wert von Status.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsStatus
			 getStatus() {
			return _status;
		}
	
		/**
		Status der Version.
		<p>
		TIC Info XML Element: Status.
		</p>
		
		@param _status der neue Wert von Status.
		*/
		public void setStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsStatus
		 _status) {
			this._status = _status;
		}
	
		/**
		Wichtung.
		<p>
		TIC Info XML Element: Importance, interne Wichtung der Meldung in der LMS.  0: niedrigster Wert, 100: höchster Wert
		</p>
		
		@return der Wert von Wichtung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsWichtung
			 getWichtung() {
			return _wichtung;
		}
	
		/**
		Wichtung.
		<p>
		TIC Info XML Element: Importance, interne Wichtung der Meldung in der LMS.  0: niedrigster Wert, 100: höchster Wert
		</p>
		
		@param _wichtung der neue Wert von Wichtung.
		*/
		public void setWichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsWichtung
		 _wichtung) {
			this._wichtung = _wichtung;
		}
	
		/**
		Priorität der Version.
		<p>
		TIC Info XML Element: Priority, kennzeichnet die Priorität der Version.
		</p>
		
		@return der Wert von Prioritaet.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsPrioritaet
			 getPrioritaet() {
			return _prioritaet;
		}
	
		/**
		Priorität der Version.
		<p>
		TIC Info XML Element: Priority, kennzeichnet die Priorität der Version.
		</p>
		
		@param _prioritaet der neue Wert von Prioritaet.
		*/
		public void setPrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsPrioritaet
		 _prioritaet) {
			this._prioritaet = _prioritaet;
		}
	
		/**
		Landeskennung der Meldung.
		<p>
		
		</p>
		
		@return der Wert von LandesKennung.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.objekte.RdsLandesKennung
			 getLandesKennung() {
			return _landesKennung;
		}
	
		/**
		Landeskennung der Meldung.
		<p>
		
		</p>
		
		@param _landesKennung der neue Wert von LandesKennung.
		*/
		public void setLandesKennung(	de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.objekte.RdsLandesKennung
		 _landesKennung) {
			this._landesKennung = _landesKennung;
		}
	
		/**
		(Bearbeitungs-) Zustand der Version.
		<p>
		
		</p>
		
		@return der Wert von Zustand.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsZustand
			 getZustand() {
			return _zustand;
		}
	
		/**
		(Bearbeitungs-) Zustand der Version.
		<p>
		
		</p>
		
		@param _zustand der neue Wert von Zustand.
		*/
		public void setZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsZustand
		 _zustand) {
			this._zustand = _zustand;
		}
	
		/**
		Quelle, die diese Meldung erzeugt hat.
		<p>
		
		</p>
		
		@return der Wert von Quelle.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsQuelle
			 getQuelle() {
			return _quelle;
		}
	
		/**
		Quelle, die diese Meldung erzeugt hat.
		<p>
		
		</p>
		
		@param _quelle der neue Wert von Quelle.
		*/
		public void setQuelle(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsQuelle
		 _quelle) {
			this._quelle = _quelle;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getAuthorisierendeOrganisationsEinheit() != null) {
					datum.getTextValue("AuthorisierendeOrganisationsEinheit").setText(getAuthorisierendeOrganisationsEinheit());
				}
				// ZeichenkettenAttributTyp
				if (getAuthorisierenderNutzer() != null) {
					datum.getTextValue("AuthorisierenderNutzer").setText(getAuthorisierenderNutzer());
				}
				// ZeitstempelAttributTyp
					datum.getTimeValue("AuthorisierungsZeit").setMillis(getAuthorisierungsZeit().getTime());
				// ZeichenkettenAttributTyp
				if (getAuthorisierungsKommentar() != null) {
					datum.getTextValue("AuthorisierungsKommentar").setText(getAuthorisierungsKommentar());
				}
				// GanzzahlAttributTyp
				if (getAuthorisierungsErgebnis() != null) {
	                if (getAuthorisierungsErgebnis().isZustand()) {
	                    datum.getUnscaledValue("AuthorisierungsErgebnis").setText(getAuthorisierungsErgebnis().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("AuthorisierungsErgebnis").set(getAuthorisierungsErgebnis().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getVersionsNummer() != null) {
	                if (getVersionsNummer().isZustand()) {
	                    datum.getUnscaledValue("VersionsNummer").setText(getVersionsNummer().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("VersionsNummer").set(getVersionsNummer().getValue());
	                }
				}
				// ZeitstempelAttributTyp
					datum.getTimeValue("AktualisierungsZeit").setMillis(getAktualisierungsZeit().getTime());
				// ZeitstempelAttributTyp
					datum.getTimeValue("AktivierungsZeit").setMillis(getAktivierungsZeit().getTime());
				// ZeitstempelAttributTyp
					datum.getTimeValue("AblaufZeit").setMillis(getAblaufZeit().getTime());
				// ZeitstempelAttributTyp
					datum.getTimeValue("ErinnerungsZeit").setMillis(getErinnerungsZeit().getTime());
				// ZeitstempelAttributTyp
					datum.getTimeValue("ErinnerungsZeitOffset").setMillis(getErinnerungsZeitOffset().getTime());
				// GanzzahlAttributTyp
				if (getErinnerungsTyp() != null) {
	                if (getErinnerungsTyp().isZustand()) {
	                    datum.getUnscaledValue("ErinnerungsTyp").setText(getErinnerungsTyp().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("ErinnerungsTyp").set(getErinnerungsTyp().getValue());
	                }
				}
				// ZeitstempelAttributTyp
					datum.getTimeValue("ErzeugungsZeit").setMillis(getErzeugungsZeit().getTime());
				// AttributListenDefinition
					getAenderungsInformationen().bean2Atl(datum.getItem("ÄnderungsInformationen"), factory);
				// GanzzahlAttributTyp
				if (getStatus() != null) {
	                if (getStatus().isZustand()) {
	                    datum.getUnscaledValue("Status").setText(getStatus().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Status").set(getStatus().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getWichtung() != null) {
	                if (getWichtung().isZustand()) {
	                    datum.getUnscaledValue("Wichtung").setText(getWichtung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Wichtung").set(getWichtung().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getPrioritaet() != null) {
	                if (getPrioritaet().isZustand()) {
	                    datum.getUnscaledValue("Priorität").setText(getPrioritaet().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Priorität").set(getPrioritaet().getValue());
	                }
				}
				// ObjektReferenzAttributTyp
					final Object soLandesKennung = getLandesKennung();
					final SystemObject tmpLandesKennung;
						if (soLandesKennung instanceof SystemObject) {
							tmpLandesKennung = (SystemObject)soLandesKennung;
						} else if(soLandesKennung instanceof SystemObjekt){
							tmpLandesKennung = ((SystemObjekt)soLandesKennung).getSystemObject();
						} else{
							tmpLandesKennung = null;
						}
					datum.getReferenceValue("LandesKennung").setSystemObject(tmpLandesKennung);
				// GanzzahlAttributTyp
				if (getZustand() != null) {
	                if (getZustand().isZustand()) {
	                    datum.getUnscaledValue("Zustand").setText(getZustand().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Zustand").set(getZustand().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getQuelle() != null) {
	                if (getQuelle().isZustand()) {
	                    datum.getUnscaledValue("Quelle").setText(getQuelle().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Quelle").set(getQuelle().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setAuthorisierendeOrganisationsEinheit(daten.getTextValue("AuthorisierendeOrganisationsEinheit").getText());
				// ZeichenkettenAttributTyp
					setAuthorisierenderNutzer(daten.getTextValue("AuthorisierenderNutzer").getText());
				// ZeitstempelAttributTyp
					setAuthorisierungsZeit(new
						Zeitstempel
						(daten.getTimeValue("AuthorisierungsZeit").getMillis()));
				// ZeichenkettenAttributTyp
					setAuthorisierungsKommentar(daten.getTextValue("AuthorisierungsKommentar").getText());
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("AuthorisierungsErgebnis").isState()) {
							setAuthorisierungsErgebnis(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsAuthorisierungsErgebnis
							.getZustand(daten.getScaledValue("AuthorisierungsErgebnis").getText()));
						} else {
						setAuthorisierungsErgebnis(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsAuthorisierungsErgebnis
						(daten.
							getUnscaledValue
						("AuthorisierungsErgebnis").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						setVersionsNummer(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttZahl0Bis65535
						(daten.
							getUnscaledValue
						("VersionsNummer").
								intValue
						()));
				// ZeitstempelAttributTyp
					setAktualisierungsZeit(new
						Zeitstempel
						(daten.getTimeValue("AktualisierungsZeit").getMillis()));
				// ZeitstempelAttributTyp
					setAktivierungsZeit(new
						Zeitstempel
						(daten.getTimeValue("AktivierungsZeit").getMillis()));
				// ZeitstempelAttributTyp
					setAblaufZeit(new
						Zeitstempel
						(daten.getTimeValue("AblaufZeit").getMillis()));
				// ZeitstempelAttributTyp
					setErinnerungsZeit(new
						Zeitstempel
						(daten.getTimeValue("ErinnerungsZeit").getMillis()));
				// ZeitstempelAttributTyp
					setErinnerungsZeitOffset(new
						RelativerZeitstempel
						(daten.getTimeValue("ErinnerungsZeitOffset").getMillis()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("ErinnerungsTyp").isState()) {
							setErinnerungsTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsErinnerungsTyp
							.getZustand(daten.getScaledValue("ErinnerungsTyp").getText()));
						} else {
						setErinnerungsTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsErinnerungsTyp
						(daten.
							getUnscaledValue
						("ErinnerungsTyp").
								byteValue
						()));
						}
				// ZeitstempelAttributTyp
					setErzeugungsZeit(new
						Zeitstempel
						(daten.getTimeValue("ErzeugungsZeit").getMillis()));
				// AttributListenDefinition
					getAenderungsInformationen().atl2Bean(daten.getItem("ÄnderungsInformationen"), factory);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Status").isState()) {
							setStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsStatus
							.getZustand(daten.getScaledValue("Status").getText()));
						} else {
						setStatus(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsStatus
						(daten.
							getUnscaledValue
						("Status").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						setWichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsWichtung
						(daten.
							getUnscaledValue
						("Wichtung").
								byteValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Priorität").isState()) {
							setPrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsPrioritaet
							.getZustand(daten.getScaledValue("Priorität").getText()));
						} else {
						setPrioritaet(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsPrioritaet
						(daten.
							getUnscaledValue
						("Priorität").
								byteValue
						()));
						}
				// ObjektReferenzAttributTyp
					final long idLandesKennung = daten.getReferenceValue("LandesKennung").getId();
					final SystemObjekt tmpLandesKennung;
					if (idLandesKennung == 0) {
						tmpLandesKennung = null;
					} else {
						final SystemObject soLandesKennung = factory.getDav().getDataModel().getObject(idLandesKennung);
						if (soLandesKennung == null) {
								tmpLandesKennung = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.objekte.impl.RdsLandesKennungUngueltig(idLandesKennung);
						} else {
							tmpLandesKennung = factory.getModellobjekt(soLandesKennung);
						}
					}
					setLandesKennung((	de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.objekte.RdsLandesKennung
					) tmpLandesKennung);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Zustand").isState()) {
							setZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsZustand
							.getZustand(daten.getScaledValue("Zustand").getText()));
						} else {
						setZustand(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsZustand
						(daten.
							getUnscaledValue
						("Zustand").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Quelle").isState()) {
							setQuelle(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsQuelle
							.getZustand(daten.getScaledValue("Quelle").getText()));
						} else {
						setQuelle(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute.AttRdsQuelle
						(daten.
							getUnscaledValue
						("Quelle").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlRdsVerwaltung clone() {
		AtlRdsVerwaltung klon = new AtlRdsVerwaltung();
		
						klon.setAuthorisierendeOrganisationsEinheit(getAuthorisierendeOrganisationsEinheit());
						klon.setAuthorisierenderNutzer(getAuthorisierenderNutzer());
						klon.setAuthorisierungsZeit(getAuthorisierungsZeit());
						klon.setAuthorisierungsKommentar(getAuthorisierungsKommentar());
						klon.setAuthorisierungsErgebnis(getAuthorisierungsErgebnis());
						klon.setVersionsNummer(getVersionsNummer());
						klon.setAktualisierungsZeit(getAktualisierungsZeit());
						klon.setAktivierungsZeit(getAktivierungsZeit());
						klon.setAblaufZeit(getAblaufZeit());
						klon.setErinnerungsZeit(getErinnerungsZeit());
						klon.setErinnerungsZeitOffset(getErinnerungsZeitOffset());
						klon.setErinnerungsTyp(getErinnerungsTyp());
						klon.setErzeugungsZeit(getErzeugungsZeit());
						klon._aenderungsInformationen = getAenderungsInformationen().clone();
						klon.setStatus(getStatus());
						klon.setWichtung(getWichtung());
						klon.setPrioritaet(getPrioritaet());
						klon.setLandesKennung(getLandesKennung());
						klon.setZustand(getZustand());
						klon.setQuelle(getQuelle());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
