/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Verzögerungswert für den Übergang von einer Verkehrssituation auf eine andere Verkehrssituation.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 8
 */
public class AtlRdsVerzoegerungsmatrix implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
			 _situationVon
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
			 _situationNach
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerSekunden
			 _verzoegerungswert
			;
	
		/**
		Ausgangs-Störfallsituation.
		<p>
		
		</p>
		
		@return der Wert von SituationVon.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
			 getSituationVon() {
			return _situationVon;
		}
	
		/**
		Ausgangs-Störfallsituation.
		<p>
		
		</p>
		
		@param _situationVon der neue Wert von SituationVon.
		*/
		public void setSituationVon(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
		 _situationVon) {
			this._situationVon = _situationVon;
		}
	
		/**
		Neue Störfallsituation.
		<p>
		
		</p>
		
		@return der Wert von SituationNach.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
			 getSituationNach() {
			return _situationNach;
		}
	
		/**
		Neue Störfallsituation.
		<p>
		
		</p>
		
		@param _situationNach der neue Wert von SituationNach.
		*/
		public void setSituationNach(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
		 _situationNach) {
			this._situationNach = _situationNach;
		}
	
		/**
		Verzögerungswert in Sekunden.
		<p>
		
		</p>
		
		@return der Wert von Verzoegerungswert.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerSekunden
			 getVerzoegerungswert() {
			return _verzoegerungswert;
		}
	
		/**
		Verzögerungswert in Sekunden.
		<p>
		
		</p>
		
		@param _verzoegerungswert der neue Wert von Verzoegerungswert.
		*/
		public void setVerzoegerungswert(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerSekunden
		 _verzoegerungswert) {
			this._verzoegerungswert = _verzoegerungswert;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getSituationVon() != null) {
	                if (getSituationVon().isZustand()) {
	                    datum.getUnscaledValue("SituationVon").setText(getSituationVon().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("SituationVon").set(getSituationVon().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getSituationNach() != null) {
	                if (getSituationNach().isZustand()) {
	                    datum.getUnscaledValue("SituationNach").setText(getSituationNach().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("SituationNach").set(getSituationNach().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getVerzoegerungswert() != null) {
	                if (getVerzoegerungswert().isZustand()) {
	                    datum.getUnscaledValue("Verzögerungswert").setText(getVerzoegerungswert().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Verzögerungswert").set(getVerzoegerungswert().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("SituationVon").isState()) {
							setSituationVon(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
							.getZustand(daten.getScaledValue("SituationVon").getText()));
						} else {
						setSituationVon(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
						(daten.
							getUnscaledValue
						("SituationVon").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("SituationNach").isState()) {
							setSituationNach(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
							.getZustand(daten.getScaledValue("SituationNach").getText()));
						} else {
						setSituationNach(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttStoerfallSituation
						(daten.
							getUnscaledValue
						("SituationNach").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Verzögerungswert").isState()) {
							setVerzoegerungswert(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerSekunden
							.getZustand(daten.getScaledValue("Verzögerungswert").getText()));
						} else {
						setVerzoegerungswert(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerSekunden
						(daten.
							getUnscaledValue
						("Verzögerungswert").
								longValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlRdsVerzoegerungsmatrix clone() {
		AtlRdsVerzoegerungsmatrix klon = new AtlRdsVerzoegerungsmatrix();
		
						klon.setSituationVon(getSituationVon());
						klon.setSituationNach(getSituationNach());
						klon.setVerzoegerungswert(getVerzoegerungswert());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
