/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ergebnis der Authorisierung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttRdsAuthorisierungsErgebnis extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsAuthorisierungsErgebnis ZUSTAND_0__NOCH_NICHT_AUTHORISIERT = new AttRdsAuthorisierungsErgebnis("(Noch) nicht authorisiert", 		Byte
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsAuthorisierungsErgebnis ZUSTAND_1_AUTHORISIERT = new AttRdsAuthorisierungsErgebnis("authorisiert", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsAuthorisierungsErgebnis ZUSTAND_2_ZURUECKGEWIESEN = new AttRdsAuthorisierungsErgebnis("zurückgewiesen", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsAuthorisierungsErgebnis ZUSTAND_3_ZURUECKGEWIESEN_UND_ZURUECKWEISUNG_FOLGENDER = new AttRdsAuthorisierungsErgebnis("zurückgewiesen und Zurückweisung folgender", 		Byte
	.valueOf("3"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttRdsAuthorisierungsErgebnis getZustand(final 		Byte
	 value) {
		for (AttRdsAuthorisierungsErgebnis e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttRdsAuthorisierungsErgebnis getZustand(final String value) {
		for (AttRdsAuthorisierungsErgebnis e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttRdsAuthorisierungsErgebnis> getZustaende() {
		List<AttRdsAuthorisierungsErgebnis> list = new ArrayList<AttRdsAuthorisierungsErgebnis>();
		list.add(ZUSTAND_0__NOCH_NICHT_AUTHORISIERT);
		list.add(ZUSTAND_1_AUTHORISIERT);
		list.add(ZUSTAND_2_ZURUECKGEWIESEN);
		list.add(ZUSTAND_3_ZURUECKGEWIESEN_UND_ZURUECKWEISUNG_FOLGENDER);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut .
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttRdsAuthorisierungsErgebnis(final 		Byte
	 value) {
		super(value);
	}
	
	private AttRdsAuthorisierungsErgebnis(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
