/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
bezeichnet die Kodierungsmethode der Location.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttRdsLocationMethode extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationMethode ZUSTAND_0_ERSTE_FELDPOSITION_IST_PRIMAERE_LOCATION_UND_LETZTE_FELDPOSITION_IST_SEKUNDAERE_LOCATION = new AttRdsLocationMethode("erste Feldposition ist primäre Location und letzte Feldposition ist sekundäre Location", 		Byte
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationMethode ZUSTAND_1_PRIMAERE_LOCATION_UND_EXTENT_SIND_GUELTIG = new AttRdsLocationMethode("Primäre Location und Extent sind gültig", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationMethode ZUSTAND_2_PRIMAERE_LOCATION_UND_SEKUNDAERE_LOCATION_SIND_GUELTIG = new AttRdsLocationMethode("Primäre Location und Sekundäre Location sind gültig", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationMethode ZUSTAND_3_PRIMAERE_LOCATION_EXTENT_UND_PRIMAERE_ENTFERNUNG_SIND_GUELTIG = new AttRdsLocationMethode("Primäre Location, Extent und primäre Entfernung sind gültig", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationMethode ZUSTAND_4_PRIMAERE_LOCATION_SEKUNDAERE_LOCATION_PRIMAERE_ENTFERNUNG_UND_SEKUNDAERE_ENTFERNUNG_SIND_GUELTIG_ = new AttRdsLocationMethode("Primäre Location, sekundäre Location, primäre Entfernung und sekundäre Entfernung sind gültig.", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationMethode ZUSTAND_5_STRASSENNUMMER_AUSFAHRTNUMMER_UND_NACHRICHTENTEXT_FUER_NACHRICHTENKLASSE_40_DER_PRIMAEREN_UND_SEKUNDAEREN_LOCATION_SIND_GUELTIG_ = new AttRdsLocationMethode("Strassennummer, Ausfahrtnummer und Nachrichtentext für Nachrichtenklasse = 40 der primären und sekundären Location sind gültig.", 		Byte
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsLocationMethode ZUSTAND_6_STRASSENNUMMER_LOCATIONKILOMETRIERUNG_DER_PRIMAEREN_UND_SEKUNDAEREN_LOCATION_SIND_GUELTIG_ = new AttRdsLocationMethode("Strassennummer, LocationKilometrierung der primären und sekundären Location sind gültig.", 		Byte
	.valueOf("6"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttRdsLocationMethode getZustand(final 		Byte
	 value) {
		for (AttRdsLocationMethode e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttRdsLocationMethode getZustand(final String value) {
		for (AttRdsLocationMethode e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttRdsLocationMethode> getZustaende() {
		List<AttRdsLocationMethode> list = new ArrayList<AttRdsLocationMethode>();
		list.add(ZUSTAND_0_ERSTE_FELDPOSITION_IST_PRIMAERE_LOCATION_UND_LETZTE_FELDPOSITION_IST_SEKUNDAERE_LOCATION);
		list.add(ZUSTAND_1_PRIMAERE_LOCATION_UND_EXTENT_SIND_GUELTIG);
		list.add(ZUSTAND_2_PRIMAERE_LOCATION_UND_SEKUNDAERE_LOCATION_SIND_GUELTIG);
		list.add(ZUSTAND_3_PRIMAERE_LOCATION_EXTENT_UND_PRIMAERE_ENTFERNUNG_SIND_GUELTIG);
		list.add(ZUSTAND_4_PRIMAERE_LOCATION_SEKUNDAERE_LOCATION_PRIMAERE_ENTFERNUNG_UND_SEKUNDAERE_ENTFERNUNG_SIND_GUELTIG_);
		list.add(ZUSTAND_5_STRASSENNUMMER_AUSFAHRTNUMMER_UND_NACHRICHTENTEXT_FUER_NACHRICHTENKLASSE_40_DER_PRIMAEREN_UND_SEKUNDAEREN_LOCATION_SIND_GUELTIG_);
		list.add(ZUSTAND_6_STRASSENNUMMER_LOCATIONKILOMETRIERUNG_DER_PRIMAEREN_UND_SEKUNDAEREN_LOCATION_SIND_GUELTIG_);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut .
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttRdsLocationMethode(final 		Byte
	 value) {
		super(value);
	}
	
	private AttRdsLocationMethode(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
