/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Sprachkennung der Nachrichtentexte entsprechend TIC Info Specification: Anhang 'Language Identifier'.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 15
 */
@Defaultwert(wert = "deutsch (Standard)")
public class AttRdsNachrichtenSprache extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_0_UNDEFINIERT = new AttRdsNachrichtenSprache("undefiniert", 		Short
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_1069_BASKISCH = new AttRdsNachrichtenSprache("baskisch", 		Short
	.valueOf("1069"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_1059_BELORUSSISCH = new AttRdsNachrichtenSprache("belorussisch", 		Short
	.valueOf("1059"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_1026_BULGARISCH = new AttRdsNachrichtenSprache("bulgarisch", 		Short
	.valueOf("1026"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_1027_KATALANISCH = new AttRdsNachrichtenSprache("katalanisch", 		Short
	.valueOf("1027"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_1050_KROATISCH = new AttRdsNachrichtenSprache("kroatisch", 		Short
	.valueOf("1050"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_1029_TSCHECHISCH = new AttRdsNachrichtenSprache("tschechisch", 		Short
	.valueOf("1029"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_1030_DAENISCH = new AttRdsNachrichtenSprache("dänisch", 		Short
	.valueOf("1030"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_1043_NIEDERLAENDISCH_NIEDERLANDE_ = new AttRdsNachrichtenSprache("niederländisch (Niederlande)", 		Short
	.valueOf("1043"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_2067_NIEDERLAENDISCH_BELGIEN_ = new AttRdsNachrichtenSprache("niederländisch (Belgien)", 		Short
	.valueOf("2067"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_1033_ENGLISCH_UNITED_STATES_ = new AttRdsNachrichtenSprache("englisch (United States)", 		Short
	.valueOf("1033"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_2057_ENGLISCH_UNITED_KINGDOM_ = new AttRdsNachrichtenSprache("englisch (United Kingdom)", 		Short
	.valueOf("2057"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_6153_ENGLISCH_IRLAND_ = new AttRdsNachrichtenSprache("englisch (Irland)", 		Short
	.valueOf("6153"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_9225_ENGLISCH_EUROPA_ = new AttRdsNachrichtenSprache("englisch (Europa)", 		Short
	.valueOf("9225"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_1061_ESTNISCH = new AttRdsNachrichtenSprache("estnisch", 		Short
	.valueOf("1061"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_1035_FINNISCH = new AttRdsNachrichtenSprache("finnisch", 		Short
	.valueOf("1035"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_1036_FRANZOESISCH_STANDARD_ = new AttRdsNachrichtenSprache("französisch (Standard)", 		Short
	.valueOf("1036"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_2060_FRANZOESISCH_BELGIEN_ = new AttRdsNachrichtenSprache("französisch (Belgien)", 		Short
	.valueOf("2060"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_4108_FRANZOESISCH_SCHWEIZ_ = new AttRdsNachrichtenSprache("französisch (Schweiz)", 		Short
	.valueOf("4108"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_5132_FRANZOESISCH_LUXEMBURG_ = new AttRdsNachrichtenSprache("französisch (Luxemburg)", 		Short
	.valueOf("5132"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_6156_FRANZOESISCH_MONACO_ = new AttRdsNachrichtenSprache("französisch (Monaco)", 		Short
	.valueOf("6156"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_1031_DEUTSCH_STANDARD_ = new AttRdsNachrichtenSprache("deutsch (Standard)", 		Short
	.valueOf("1031"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_2055_DEUTSCH_SCHWEIZ_ = new AttRdsNachrichtenSprache("deutsch (Schweiz)", 		Short
	.valueOf("2055"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_3079_DEUTSCH_OESTERREICH_ = new AttRdsNachrichtenSprache("deutsch (Österreich)", 		Short
	.valueOf("3079"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_4103_DEUTSCH_LUXEMBURG_ = new AttRdsNachrichtenSprache("deutsch (Luxemburg)", 		Short
	.valueOf("4103"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_5127_DEUTSCH_LIECHTENSTEIN_ = new AttRdsNachrichtenSprache("deutsch (Liechtenstein)", 		Short
	.valueOf("5127"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_1032_GRIECHISCH = new AttRdsNachrichtenSprache("griechisch", 		Short
	.valueOf("1032"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_1038_UNGARISCH = new AttRdsNachrichtenSprache("ungarisch", 		Short
	.valueOf("1038"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_1040_ITALIENISCH_STANDARD_ = new AttRdsNachrichtenSprache("italienisch (Standard)", 		Short
	.valueOf("1040"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_2064_ITALIENISCH_SCHWEIZ_ = new AttRdsNachrichtenSprache("italienisch (Schweiz)", 		Short
	.valueOf("2064"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_1044_NORWEGISCH_BOKMAL_ = new AttRdsNachrichtenSprache("norwegisch (Bokmal)", 		Short
	.valueOf("1044"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_2068_NORWEGISCH_NYNORSK_ = new AttRdsNachrichtenSprache("norwegisch (Nynorsk)", 		Short
	.valueOf("2068"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_1045_POLNISCH = new AttRdsNachrichtenSprache("polnisch", 		Short
	.valueOf("1045"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_1046_PORTUGISISCH_BRASILIEN_ = new AttRdsNachrichtenSprache("portugisisch (Brasilien)", 		Short
	.valueOf("1046"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_2070_PORTUGISISCH_STANDARD_ = new AttRdsNachrichtenSprache("portugisisch (Standard)", 		Short
	.valueOf("2070"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_1048_RUMAENISCH = new AttRdsNachrichtenSprache("rumänisch", 		Short
	.valueOf("1048"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_1049_RUSSISCH = new AttRdsNachrichtenSprache("russisch", 		Short
	.valueOf("1049"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_3098_SERBISCH_RUSSISCH_ = new AttRdsNachrichtenSprache("serbisch (russisch)", 		Short
	.valueOf("3098"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_2074_SERBISCH_LATEIN_ = new AttRdsNachrichtenSprache("serbisch (latein)", 		Short
	.valueOf("2074"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_1051_SLOWAKISCH = new AttRdsNachrichtenSprache("slowakisch", 		Short
	.valueOf("1051"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_1060_SLOWENISCH = new AttRdsNachrichtenSprache("slowenisch", 		Short
	.valueOf("1060"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_1034_SPANISCH_TRADITIONELL_ = new AttRdsNachrichtenSprache("spanisch (traditionell)", 		Short
	.valueOf("1034"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_3082_SPANISCH_MODERN_ = new AttRdsNachrichtenSprache("spanisch (modern)", 		Short
	.valueOf("3082"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_1053_SCHWEDISCH = new AttRdsNachrichtenSprache("schwedisch", 		Short
	.valueOf("1053"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_2077_SCHWEDISCH_FINNLAND_ = new AttRdsNachrichtenSprache("schwedisch (Finnland)", 		Short
	.valueOf("2077"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_1055_TUERKISCH = new AttRdsNachrichtenSprache("türkisch", 		Short
	.valueOf("1055"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttRdsNachrichtenSprache ZUSTAND_1058_UKRAINISCH = new AttRdsNachrichtenSprache("ukrainisch", 		Short
	.valueOf("1058"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttRdsNachrichtenSprache getZustand(final 		Short
	 value) {
		for (AttRdsNachrichtenSprache e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttRdsNachrichtenSprache getZustand(final String value) {
		for (AttRdsNachrichtenSprache e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttRdsNachrichtenSprache> getZustaende() {
		List<AttRdsNachrichtenSprache> list = new ArrayList<AttRdsNachrichtenSprache>();
		list.add(ZUSTAND_0_UNDEFINIERT);
		list.add(ZUSTAND_1069_BASKISCH);
		list.add(ZUSTAND_1059_BELORUSSISCH);
		list.add(ZUSTAND_1026_BULGARISCH);
		list.add(ZUSTAND_1027_KATALANISCH);
		list.add(ZUSTAND_1050_KROATISCH);
		list.add(ZUSTAND_1029_TSCHECHISCH);
		list.add(ZUSTAND_1030_DAENISCH);
		list.add(ZUSTAND_1043_NIEDERLAENDISCH_NIEDERLANDE_);
		list.add(ZUSTAND_2067_NIEDERLAENDISCH_BELGIEN_);
		list.add(ZUSTAND_1033_ENGLISCH_UNITED_STATES_);
		list.add(ZUSTAND_2057_ENGLISCH_UNITED_KINGDOM_);
		list.add(ZUSTAND_6153_ENGLISCH_IRLAND_);
		list.add(ZUSTAND_9225_ENGLISCH_EUROPA_);
		list.add(ZUSTAND_1061_ESTNISCH);
		list.add(ZUSTAND_1035_FINNISCH);
		list.add(ZUSTAND_1036_FRANZOESISCH_STANDARD_);
		list.add(ZUSTAND_2060_FRANZOESISCH_BELGIEN_);
		list.add(ZUSTAND_4108_FRANZOESISCH_SCHWEIZ_);
		list.add(ZUSTAND_5132_FRANZOESISCH_LUXEMBURG_);
		list.add(ZUSTAND_6156_FRANZOESISCH_MONACO_);
		list.add(ZUSTAND_1031_DEUTSCH_STANDARD_);
		list.add(ZUSTAND_2055_DEUTSCH_SCHWEIZ_);
		list.add(ZUSTAND_3079_DEUTSCH_OESTERREICH_);
		list.add(ZUSTAND_4103_DEUTSCH_LUXEMBURG_);
		list.add(ZUSTAND_5127_DEUTSCH_LIECHTENSTEIN_);
		list.add(ZUSTAND_1032_GRIECHISCH);
		list.add(ZUSTAND_1038_UNGARISCH);
		list.add(ZUSTAND_1040_ITALIENISCH_STANDARD_);
		list.add(ZUSTAND_2064_ITALIENISCH_SCHWEIZ_);
		list.add(ZUSTAND_1044_NORWEGISCH_BOKMAL_);
		list.add(ZUSTAND_2068_NORWEGISCH_NYNORSK_);
		list.add(ZUSTAND_1045_POLNISCH);
		list.add(ZUSTAND_1046_PORTUGISISCH_BRASILIEN_);
		list.add(ZUSTAND_2070_PORTUGISISCH_STANDARD_);
		list.add(ZUSTAND_1048_RUMAENISCH);
		list.add(ZUSTAND_1049_RUSSISCH);
		list.add(ZUSTAND_3098_SERBISCH_RUSSISCH_);
		list.add(ZUSTAND_2074_SERBISCH_LATEIN_);
		list.add(ZUSTAND_1051_SLOWAKISCH);
		list.add(ZUSTAND_1060_SLOWENISCH);
		list.add(ZUSTAND_1034_SPANISCH_TRADITIONELL_);
		list.add(ZUSTAND_3082_SPANISCH_MODERN_);
		list.add(ZUSTAND_1053_SCHWEDISCH);
		list.add(ZUSTAND_2077_SCHWEDISCH_FINNLAND_);
		list.add(ZUSTAND_1055_TUERKISCH);
		list.add(ZUSTAND_1058_UKRAINISCH);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut .
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttRdsNachrichtenSprache(final 		Short
	 value) {
		super(value);
	}
	
	private AttRdsNachrichtenSprache(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
