/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
TIC3 AreaCategoryNameType.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTic3AreaCategoryNameType implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _tIC3GebietName
			= new String
			()
			;
			private String
			 _tIC3GebietKategorie
			= new String
			()
			;
			private String
			 _tIC3GebietUnterkategorie
			= new String
			()
			;
			private String
			 _tIC3Bekanntheit
			= new String
			()
			;
	
		/**
		Name des Gebietes.
		<p>
		TIC3 Info XML Element: Name (NAM), The name of the object, in one or more languages configured on the system.
		</p>
		
		@return der Wert von TIC3GebietName.
		*/
			public String
			 getTIC3GebietName() {
			return _tIC3GebietName;
		}
	
		/**
		Name des Gebietes.
		<p>
		TIC3 Info XML Element: Name (NAM), The name of the object, in one or more languages configured on the system.
		</p>
		
		@param _tIC3GebietName der neue Wert von TIC3GebietName.
		*/
		public void setTIC3GebietName(String
		 _tIC3GebietName) {
			if (_tIC3GebietName.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._tIC3GebietName = _tIC3GebietName;
		}
	
		/**
		Kategorie des Gebietes.
		<p>
		TIC3 Info XML Element: Category (CAT), The area category such as "Nature", "Administrative area", and "Built-up area".
		</p>
		
		@return der Wert von TIC3GebietKategorie.
		*/
			public String
			 getTIC3GebietKategorie() {
			return _tIC3GebietKategorie;
		}
	
		/**
		Kategorie des Gebietes.
		<p>
		TIC3 Info XML Element: Category (CAT), The area category such as "Nature", "Administrative area", and "Built-up area".
		</p>
		
		@param _tIC3GebietKategorie der neue Wert von TIC3GebietKategorie.
		*/
		public void setTIC3GebietKategorie(String
		 _tIC3GebietKategorie) {
			if (_tIC3GebietKategorie.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._tIC3GebietKategorie = _tIC3GebietKategorie;
		}
	
		/**
		Unterkategorie des Gebietes.
		<p>
		TIC3 Info XML Element: SubCategory (SCA), The area subcategory such as "Country", "Sea", or "Forest".
		</p>
		
		@return der Wert von TIC3GebietUnterkategorie.
		*/
			public String
			 getTIC3GebietUnterkategorie() {
			return _tIC3GebietUnterkategorie;
		}
	
		/**
		Unterkategorie des Gebietes.
		<p>
		TIC3 Info XML Element: SubCategory (SCA), The area subcategory such as "Country", "Sea", or "Forest".
		</p>
		
		@param _tIC3GebietUnterkategorie der neue Wert von TIC3GebietUnterkategorie.
		*/
		public void setTIC3GebietUnterkategorie(String
		 _tIC3GebietUnterkategorie) {
			if (_tIC3GebietUnterkategorie.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._tIC3GebietUnterkategorie = _tIC3GebietUnterkategorie;
		}
	
		/**
		Bekanntheit.
		<p>
		TIC3 Info XML Element: Popularity (POP), The grade of popularity of the area in the range from 1 to 10, where 10 is the highest popularity grade.
		</p>
		
		@return der Wert von TIC3Bekanntheit.
		*/
			public String
			 getTIC3Bekanntheit() {
			return _tIC3Bekanntheit;
		}
	
		/**
		Bekanntheit.
		<p>
		TIC3 Info XML Element: Popularity (POP), The grade of popularity of the area in the range from 1 to 10, where 10 is the highest popularity grade.
		</p>
		
		@param _tIC3Bekanntheit der neue Wert von TIC3Bekanntheit.
		*/
		public void setTIC3Bekanntheit(String
		 _tIC3Bekanntheit) {
			if (_tIC3Bekanntheit.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._tIC3Bekanntheit = _tIC3Bekanntheit;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getTIC3GebietName() != null) {
					datum.getTextValue("TIC3GebietName").setText(getTIC3GebietName());
				}
				// ZeichenkettenAttributTyp
				if (getTIC3GebietKategorie() != null) {
					datum.getTextValue("TIC3GebietKategorie").setText(getTIC3GebietKategorie());
				}
				// ZeichenkettenAttributTyp
				if (getTIC3GebietUnterkategorie() != null) {
					datum.getTextValue("TIC3GebietUnterkategorie").setText(getTIC3GebietUnterkategorie());
				}
				// ZeichenkettenAttributTyp
				if (getTIC3Bekanntheit() != null) {
					datum.getTextValue("TIC3Bekanntheit").setText(getTIC3Bekanntheit());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setTIC3GebietName(daten.getTextValue("TIC3GebietName").getText());
				// ZeichenkettenAttributTyp
					setTIC3GebietKategorie(daten.getTextValue("TIC3GebietKategorie").getText());
				// ZeichenkettenAttributTyp
					setTIC3GebietUnterkategorie(daten.getTextValue("TIC3GebietUnterkategorie").getText());
				// ZeichenkettenAttributTyp
					setTIC3Bekanntheit(daten.getTextValue("TIC3Bekanntheit").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTic3AreaCategoryNameType clone() {
		AtlTic3AreaCategoryNameType klon = new AtlTic3AreaCategoryNameType();
		
						klon.setTIC3GebietName(getTIC3GebietName());
						klon.setTIC3GebietKategorie(getTIC3GebietKategorie());
						klon.setTIC3GebietUnterkategorie(getTIC3GebietUnterkategorie());
						klon.setTIC3Bekanntheit(getTIC3Bekanntheit());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
