/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
TIC3 CreateResultType.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTic3ErgebnisErzeugung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "Nein")
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _automatischAktualisieren
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3ErgebnisErzeugungRegel
			> _ergebnisErzeugungRegeln = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3ErgebnisErzeugungRegel
			>(0, true);
	
		/**
		Automatisch aktualisieren.
		<p>
		TIC3 Info XML Element: UpdateAutomatically (UAT), Specifies whether or not the source data is used to automatically update the data contained in this object.
		</p>
		
		@return der Wert von AutomatischAktualisieren.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getAutomatischAktualisieren() {
			return _automatischAktualisieren;
		}
	
		/**
		Automatisch aktualisieren.
		<p>
		TIC3 Info XML Element: UpdateAutomatically (UAT), Specifies whether or not the source data is used to automatically update the data contained in this object.
		</p>
		
		@param _automatischAktualisieren der neue Wert von AutomatischAktualisieren.
		*/
		public void setAutomatischAktualisieren(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _automatischAktualisieren) {
			this._automatischAktualisieren = _automatischAktualisieren;
		}
	
		/**
		Regeln.
		<p>
		TIC3 Info XML Element: Rule (RUL), A list of rules to be used when this source data is used to create the data contained in this object.
		</p>
		
		@return der Wert von ErgebnisErzeugungRegeln.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3ErgebnisErzeugungRegel
			> getErgebnisErzeugungRegeln() {
			return _ergebnisErzeugungRegeln;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getAutomatischAktualisieren() != null) {
	                if (getAutomatischAktualisieren().isZustand()) {
	                    datum.getUnscaledValue("AutomatischAktualisieren").setText(getAutomatischAktualisieren().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("AutomatischAktualisieren").set(getAutomatischAktualisieren().getValue());
	                }
				}
				// AttributListenDefinition
					final Data.Array arrayErgebnisErzeugungRegeln = datum.getArray("ErgebnisErzeugungRegeln");
					arrayErgebnisErzeugungRegeln.setLength(getErgebnisErzeugungRegeln().size());
					for (int i = 0; i < arrayErgebnisErzeugungRegeln.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3ErgebnisErzeugungRegel
						 atl = getErgebnisErzeugungRegeln().get(i);
						atl.bean2Atl(arrayErgebnisErzeugungRegeln.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("AutomatischAktualisieren").isState()) {
							setAutomatischAktualisieren(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("AutomatischAktualisieren").getText()));
						} else {
						setAutomatischAktualisieren(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("AutomatischAktualisieren").
								byteValue
						()));
						}
				// AttributListenDefinition
					final Data.Array arrayErgebnisErzeugungRegeln = daten.getArray("ErgebnisErzeugungRegeln");
					for (int i = 0; i < arrayErgebnisErzeugungRegeln.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3ErgebnisErzeugungRegel
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3ErgebnisErzeugungRegel
						 ();
						atl.atl2Bean(arrayErgebnisErzeugungRegeln.getItem(i), factory);
						getErgebnisErzeugungRegeln().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTic3ErgebnisErzeugung clone() {
		AtlTic3ErgebnisErzeugung klon = new AtlTic3ErgebnisErzeugung();
		
						klon.setAutomatischAktualisieren(getAutomatischAktualisieren());
					klon._ergebnisErzeugungRegeln = getErgebnisErzeugungRegeln().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
