/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
TIC3 CreateResultRuleType.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTic3ErgebnisErzeugungRegel implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _verwenden
			;
			private String
			 _elementpfad
			= new String
			()
			;
			private String
			 _elementschluessel
			= new String
			()
			;
	
		/**
		Verwenden.
		<p>
		TIC3 Info XML Element: Use (USE),	Specifies whether or not the element is used to create the data	contained in this object.
		</p>
		
		@return der Wert von Verwenden.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getVerwenden() {
			return _verwenden;
		}
	
		/**
		Verwenden.
		<p>
		TIC3 Info XML Element: Use (USE),	Specifies whether or not the element is used to create the data	contained in this object.
		</p>
		
		@param _verwenden der neue Wert von Verwenden.
		*/
		public void setVerwenden(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _verwenden) {
			this._verwenden = _verwenden;
		}
	
		/**
		Elementpfad.
		<p>
		TIC3 Info XML Element: ElementPath (ELP), The address of the element which was combined, consisting of the path from the root of the object type to the element and the element identifier.
		</p>
		
		@return der Wert von Elementpfad.
		*/
			public String
			 getElementpfad() {
			return _elementpfad;
		}
	
		/**
		Elementpfad.
		<p>
		TIC3 Info XML Element: ElementPath (ELP), The address of the element which was combined, consisting of the path from the root of the object type to the element and the element identifier.
		</p>
		
		@param _elementpfad der neue Wert von Elementpfad.
		*/
		public void setElementpfad(String
		 _elementpfad) {
			if (_elementpfad.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._elementpfad = _elementpfad;
		}
	
		/**
		Elementschlüssel.
		<p>
		TIC3 Info XML Element: ElementKey (ELV), The key of the element which was combined.
		</p>
		
		@return der Wert von Elementschluessel.
		*/
			public String
			 getElementschluessel() {
			return _elementschluessel;
		}
	
		/**
		Elementschlüssel.
		<p>
		TIC3 Info XML Element: ElementKey (ELV), The key of the element which was combined.
		</p>
		
		@param _elementschluessel der neue Wert von Elementschluessel.
		*/
		public void setElementschluessel(String
		 _elementschluessel) {
			if (_elementschluessel.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._elementschluessel = _elementschluessel;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getVerwenden() != null) {
	                if (getVerwenden().isZustand()) {
	                    datum.getUnscaledValue("Verwenden").setText(getVerwenden().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Verwenden").set(getVerwenden().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getElementpfad() != null) {
					datum.getTextValue("Elementpfad").setText(getElementpfad());
				}
				// ZeichenkettenAttributTyp
				if (getElementschluessel() != null) {
					datum.getTextValue("Elementschlüssel").setText(getElementschluessel());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Verwenden").isState()) {
							setVerwenden(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Verwenden").getText()));
						} else {
						setVerwenden(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Verwenden").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					setElementpfad(daten.getTextValue("Elementpfad").getText());
				// ZeichenkettenAttributTyp
					setElementschluessel(daten.getTextValue("Elementschlüssel").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTic3ErgebnisErzeugungRegel clone() {
		AtlTic3ErgebnisErzeugungRegel klon = new AtlTic3ErgebnisErzeugungRegel();
		
						klon.setVerwenden(getVerwenden());
						klon.setElementpfad(getElementpfad());
						klon.setElementschluessel(getElementschluessel());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
