/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
TIC3-Ereignisdaten.
<p>
Entspricht TIC3 Typ 'TrafficAndTravelEventType' (ohne SaeRdsEvent).
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class AtlTic3Event implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "")
			private String
			 _beschreibung
			= new String
			()
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tmcEvent
			> _tIC3TmcEvent = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tmcEvent
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tic3Event
			> _tIC3Tic3Event = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tic3Event
			>(0, true);
	
		/**
		Beschreibung.
		<p>
		Wert des 'description'-Attributes TIC Info XML Element Event.
		</p>
		
		@return der Wert von Beschreibung.
		*/
			public String
			 getBeschreibung() {
			return _beschreibung;
		}
	
		/**
		Beschreibung.
		<p>
		Wert des 'description'-Attributes TIC Info XML Element Event.
		</p>
		
		@param _beschreibung der neue Wert von Beschreibung.
		*/
		public void setBeschreibung(String
		 _beschreibung) {
			if (_beschreibung.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._beschreibung = _beschreibung;
		}
	
		/**
		TMC-codierte Ereignisse.
		<p>
		TIC3 Info XML Element: TmcEvent (TMC), A list of one or more TMC event codes with additional information which are equivalent to "TIC3 event" codes, where TMC is defined in the TMC standard ISO 14819-2.
		</p>
		
		@return der Wert von TIC3TmcEvent.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tmcEvent
			> getTIC3TmcEvent() {
			return _tIC3TmcEvent;
		}
	
	
		/**
		TIC3-codierte Ereignisse.
		<p>
		TIC3 Info XML Element: Tic3Event (T3E), A list of one or more TIC3 traffic and travel event codes and their attributes, where the TIC3 event codes are defined based on a combination of standards such asTMC or SAE RDS.
		</p>
		
		@return der Wert von TIC3Tic3Event.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tic3Event
			> getTIC3Tic3Event() {
			return _tIC3Tic3Event;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getBeschreibung() != null) {
					datum.getTextValue("Beschreibung").setText(getBeschreibung());
				}
				// AttributListenDefinition
					final Data.Array arrayTIC3TmcEvent = datum.getArray("TIC3TmcEvent");
					arrayTIC3TmcEvent.setLength(getTIC3TmcEvent().size());
					for (int i = 0; i < arrayTIC3TmcEvent.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tmcEvent
						 atl = getTIC3TmcEvent().get(i);
						atl.bean2Atl(arrayTIC3TmcEvent.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayTIC3Tic3Event = datum.getArray("TIC3Tic3Event");
					arrayTIC3Tic3Event.setLength(getTIC3Tic3Event().size());
					for (int i = 0; i < arrayTIC3Tic3Event.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tic3Event
						 atl = getTIC3Tic3Event().get(i);
						atl.bean2Atl(arrayTIC3Tic3Event.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setBeschreibung(daten.getTextValue("Beschreibung").getText());
				// AttributListenDefinition
					final Data.Array arrayTIC3TmcEvent = daten.getArray("TIC3TmcEvent");
					for (int i = 0; i < arrayTIC3TmcEvent.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tmcEvent
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tmcEvent
						 ();
						atl.atl2Bean(arrayTIC3TmcEvent.getItem(i), factory);
						getTIC3TmcEvent().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayTIC3Tic3Event = daten.getArray("TIC3Tic3Event");
					for (int i = 0; i < arrayTIC3Tic3Event.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tic3Event
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tic3Event
						 ();
						atl.atl2Bean(arrayTIC3Tic3Event.getItem(i), factory);
						getTIC3Tic3Event().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTic3Event clone() {
		AtlTic3Event klon = new AtlTic3Event();
		
						klon.setBeschreibung(getBeschreibung());
					klon._tIC3TmcEvent = getTIC3TmcEvent().clone();
					klon._tIC3Tic3Event = getTIC3Tic3Event().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
