/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
TIC3-Lokationsinformationen.
<p>
Entspricht TIC3 Info Typ 'LocationType', TIC3 Info XML Element: Location (LOC): Information about a location specified by one or more location referencing methods such as TIC3 location, geographical position, or TMC location.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTic3Location implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "")
			private String
			 _beschreibung
			= new String
			()
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3KoordinatenLocation
			> _tIC3KoordinatenLocation = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3KoordinatenLocation
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tmcLocation
			> _tIC3TmcLocation = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tmcLocation
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tic3Location
			> _tIC3TicLocation = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tic3Location
			>(0, true);
	
		/**
		Beschreibung der Lokation.
		<p>
		Wert des 'description'-Attributes TIC Info XML Element Location.
		</p>
		
		@return der Wert von Beschreibung.
		*/
			public String
			 getBeschreibung() {
			return _beschreibung;
		}
	
		/**
		Beschreibung der Lokation.
		<p>
		Wert des 'description'-Attributes TIC Info XML Element Location.
		</p>
		
		@param _beschreibung der neue Wert von Beschreibung.
		*/
		public void setBeschreibung(String
		 _beschreibung) {
			if (_beschreibung.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._beschreibung = _beschreibung;
		}
	
		/**
		TIC3-Lokationsinformationen mit WGS-Koordinaten.
		<p>
		TIC3 Info XML Element: Position (POS), The position as one or more geographical coordinates (WGS84).
		</p>
		
		@return der Wert von TIC3KoordinatenLocation.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3KoordinatenLocation
			> getTIC3KoordinatenLocation() {
			return _tIC3KoordinatenLocation;
		}
	
	
		/**
		TIC3-Lokationsinformationen mit TMC-Lokationen.
		<p>
		TIC3 Info XML Element: TmcLocation (TMC), A list of information about TMC coded locations.
		</p>
		
		@return der Wert von TIC3TmcLocation.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tmcLocation
			> getTIC3TmcLocation() {
			return _tIC3TmcLocation;
		}
	
	
		/**
		TIC3-Lokationsinformationen mit TIC3-Lokationen.
		<p>
		TIC3 Info XML Element: Tic3Location (T3L), A list of network references per network.
		</p>
		
		@return der Wert von TIC3TicLocation.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tic3Location
			> getTIC3TicLocation() {
			return _tIC3TicLocation;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getBeschreibung() != null) {
					datum.getTextValue("Beschreibung").setText(getBeschreibung());
				}
				// AttributListenDefinition
					final Data.Array arrayTIC3KoordinatenLocation = datum.getArray("TIC3KoordinatenLocation");
					arrayTIC3KoordinatenLocation.setLength(getTIC3KoordinatenLocation().size());
					for (int i = 0; i < arrayTIC3KoordinatenLocation.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3KoordinatenLocation
						 atl = getTIC3KoordinatenLocation().get(i);
						atl.bean2Atl(arrayTIC3KoordinatenLocation.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayTIC3TmcLocation = datum.getArray("TIC3TmcLocation");
					arrayTIC3TmcLocation.setLength(getTIC3TmcLocation().size());
					for (int i = 0; i < arrayTIC3TmcLocation.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tmcLocation
						 atl = getTIC3TmcLocation().get(i);
						atl.bean2Atl(arrayTIC3TmcLocation.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayTIC3TicLocation = datum.getArray("TIC3TicLocation");
					arrayTIC3TicLocation.setLength(getTIC3TicLocation().size());
					for (int i = 0; i < arrayTIC3TicLocation.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tic3Location
						 atl = getTIC3TicLocation().get(i);
						atl.bean2Atl(arrayTIC3TicLocation.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setBeschreibung(daten.getTextValue("Beschreibung").getText());
				// AttributListenDefinition
					final Data.Array arrayTIC3KoordinatenLocation = daten.getArray("TIC3KoordinatenLocation");
					for (int i = 0; i < arrayTIC3KoordinatenLocation.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3KoordinatenLocation
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3KoordinatenLocation
						 ();
						atl.atl2Bean(arrayTIC3KoordinatenLocation.getItem(i), factory);
						getTIC3KoordinatenLocation().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayTIC3TmcLocation = daten.getArray("TIC3TmcLocation");
					for (int i = 0; i < arrayTIC3TmcLocation.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tmcLocation
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tmcLocation
						 ();
						atl.atl2Bean(arrayTIC3TmcLocation.getItem(i), factory);
						getTIC3TmcLocation().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayTIC3TicLocation = daten.getArray("TIC3TicLocation");
					for (int i = 0; i < arrayTIC3TicLocation.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tic3Location
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tic3Location
						 ();
						atl.atl2Bean(arrayTIC3TicLocation.getItem(i), factory);
						getTIC3TicLocation().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTic3Location clone() {
		AtlTic3Location klon = new AtlTic3Location();
		
						klon.setBeschreibung(getBeschreibung());
					klon._tIC3KoordinatenLocation = getTIC3KoordinatenLocation().clone();
					klon._tIC3TmcLocation = getTIC3TmcLocation().clone();
					klon._tIC3TicLocation = getTIC3TicLocation().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
