/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
TIC3-Lokationkoordinaten.
<p>
Koordinaten im WGS 84 Format in Grad.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTic3LocationKoordinaten implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
			 _tIC3KoordinateX
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
			 _tIC3KoordinateY
			;
	
		/**
		Länge.
		<p>
		TIC3 Info XML Element: Longitude (LON), The longitude (°) specifies the location of a place on Earth east or west of the meridian. Lines of longitude are the vertical lines shown running north to south on maps. The range is from -180 (west of the meridian) to +180 (east of the meridian).
		</p>
		
		@return der Wert von TIC3KoordinateX.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
			 getTIC3KoordinateX() {
			return _tIC3KoordinateX;
		}
	
		/**
		Länge.
		<p>
		TIC3 Info XML Element: Longitude (LON), The longitude (°) specifies the location of a place on Earth east or west of the meridian. Lines of longitude are the vertical lines shown running north to south on maps. The range is from -180 (west of the meridian) to +180 (east of the meridian).
		</p>
		
		@param _tIC3KoordinateX der neue Wert von TIC3KoordinateX.
		*/
		public void setTIC3KoordinateX(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
		 _tIC3KoordinateX) {
			this._tIC3KoordinateX = _tIC3KoordinateX;
		}
	
		/**
		Breite.
		<p>
		TIC3 Info XML Element: Latitude (LAT), The latitude (°) specifies the location of a place on Earth north or south of the equator. Lines of latitude are the horizontal lines shown running east to west on maps. The range is from -90 (south pole) to 90 (north pole).
		</p>
		
		@return der Wert von TIC3KoordinateY.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
			 getTIC3KoordinateY() {
			return _tIC3KoordinateY;
		}
	
		/**
		Breite.
		<p>
		TIC3 Info XML Element: Latitude (LAT), The latitude (°) specifies the location of a place on Earth north or south of the equator. Lines of latitude are the horizontal lines shown running east to west on maps. The range is from -90 (south pole) to 90 (north pole).
		</p>
		
		@param _tIC3KoordinateY der neue Wert von TIC3KoordinateY.
		*/
		public void setTIC3KoordinateY(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
		 _tIC3KoordinateY) {
			this._tIC3KoordinateY = _tIC3KoordinateY;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getTIC3KoordinateX() != null) {
	                if (getTIC3KoordinateX().isZustand()) {
	                    datum.getUnscaledValue("TIC3KoordinateX").setText(getTIC3KoordinateX().toString());
	                } else {
						datum.
						getScaledValue
	                	("TIC3KoordinateX").set(getTIC3KoordinateX().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getTIC3KoordinateY() != null) {
	                if (getTIC3KoordinateY().isZustand()) {
	                    datum.getUnscaledValue("TIC3KoordinateY").setText(getTIC3KoordinateY().toString());
	                } else {
						datum.
						getScaledValue
	                	("TIC3KoordinateY").set(getTIC3KoordinateY().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("TIC3KoordinateX").isState()) {
							setTIC3KoordinateX(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
							.getZustand(daten.getScaledValue("TIC3KoordinateX").getText()));
						} else {
						setTIC3KoordinateX(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Laenge
						(daten.
							getScaledValue
						("TIC3KoordinateX").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("TIC3KoordinateY").isState()) {
							setTIC3KoordinateY(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
							.getZustand(daten.getScaledValue("TIC3KoordinateY").getText()));
						} else {
						setTIC3KoordinateY(new de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.attribute.AttWgs84Breite
						(daten.
							getScaledValue
						("TIC3KoordinateY").
							doubleValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTic3LocationKoordinaten clone() {
		AtlTic3LocationKoordinaten klon = new AtlTic3LocationKoordinaten();
		
						klon.setTIC3KoordinateX(getTIC3KoordinateX());
						klon.setTIC3KoordinateY(getTIC3KoordinateY());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
