/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Informationen zur benutzten Location-Tabelle.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTic3LocationTabelleInfo implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _locationTabelleErweiterterLandescode
			= new String
			()
			;
			private String
			 _locationTabelleLandescode
			= new String
			()
			;
			private String
			 _locationTabelleNummer
			= new String
			()
			;
			private String
			 _locationTabelleVersion
			= new String
			()
			;
	
		/**
		Erweiterter Ländercode der Locationtabelle.
		<p>
		TIC Info XML Element:	LocationTableExtendedCountryCode (ECC). (The extended country code (ECC) of the TMC location table as defined in the RDS standard IEC 62106)
		</p>
		
		@return der Wert von LocationTabelleErweiterterLandescode.
		*/
			public String
			 getLocationTabelleErweiterterLandescode() {
			return _locationTabelleErweiterterLandescode;
		}
	
		/**
		Erweiterter Ländercode der Locationtabelle.
		<p>
		TIC Info XML Element:	LocationTableExtendedCountryCode (ECC). (The extended country code (ECC) of the TMC location table as defined in the RDS standard IEC 62106)
		</p>
		
		@param _locationTabelleErweiterterLandescode der neue Wert von LocationTabelleErweiterterLandescode.
		*/
		public void setLocationTabelleErweiterterLandescode(String
		 _locationTabelleErweiterterLandescode) {
			if (_locationTabelleErweiterterLandescode.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._locationTabelleErweiterterLandescode = _locationTabelleErweiterterLandescode;
		}
	
		/**
		Ländercode der Locationtabelle.
		<p>
		TIC Info XML Element: LocationTableCountryCode (CCO). (The country code (CC) of the TMC location table as defined in the RDS standard IEC 62106)
		</p>
		
		@return der Wert von LocationTabelleLandescode.
		*/
			public String
			 getLocationTabelleLandescode() {
			return _locationTabelleLandescode;
		}
	
		/**
		Ländercode der Locationtabelle.
		<p>
		TIC Info XML Element: LocationTableCountryCode (CCO). (The country code (CC) of the TMC location table as defined in the RDS standard IEC 62106)
		</p>
		
		@param _locationTabelleLandescode der neue Wert von LocationTabelleLandescode.
		*/
		public void setLocationTabelleLandescode(String
		 _locationTabelleLandescode) {
			if (_locationTabelleLandescode.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._locationTabelleLandescode = _locationTabelleLandescode;
		}
	
		/**
		Nummer der Locationtabelle.
		<p>
		TIC Info XML Element: LocationTableNumber (TNU).
		</p>
		
		@return der Wert von LocationTabelleNummer.
		*/
			public String
			 getLocationTabelleNummer() {
			return _locationTabelleNummer;
		}
	
		/**
		Nummer der Locationtabelle.
		<p>
		TIC Info XML Element: LocationTableNumber (TNU).
		</p>
		
		@param _locationTabelleNummer der neue Wert von LocationTabelleNummer.
		*/
		public void setLocationTabelleNummer(String
		 _locationTabelleNummer) {
			if (_locationTabelleNummer.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._locationTabelleNummer = _locationTabelleNummer;
		}
	
		/**
		Version der Locationtabelle.
		<p>
		TIC Info XML Element: LocationTableVersion (TVR).
		</p>
		
		@return der Wert von LocationTabelleVersion.
		*/
			public String
			 getLocationTabelleVersion() {
			return _locationTabelleVersion;
		}
	
		/**
		Version der Locationtabelle.
		<p>
		TIC Info XML Element: LocationTableVersion (TVR).
		</p>
		
		@param _locationTabelleVersion der neue Wert von LocationTabelleVersion.
		*/
		public void setLocationTabelleVersion(String
		 _locationTabelleVersion) {
			if (_locationTabelleVersion.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._locationTabelleVersion = _locationTabelleVersion;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getLocationTabelleErweiterterLandescode() != null) {
					datum.getTextValue("LocationTabelleErweiterterLandescode").setText(getLocationTabelleErweiterterLandescode());
				}
				// ZeichenkettenAttributTyp
				if (getLocationTabelleLandescode() != null) {
					datum.getTextValue("LocationTabelleLandescode").setText(getLocationTabelleLandescode());
				}
				// ZeichenkettenAttributTyp
				if (getLocationTabelleNummer() != null) {
					datum.getTextValue("LocationTabelleNummer").setText(getLocationTabelleNummer());
				}
				// ZeichenkettenAttributTyp
				if (getLocationTabelleVersion() != null) {
					datum.getTextValue("LocationTabelleVersion").setText(getLocationTabelleVersion());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setLocationTabelleErweiterterLandescode(daten.getTextValue("LocationTabelleErweiterterLandescode").getText());
				// ZeichenkettenAttributTyp
					setLocationTabelleLandescode(daten.getTextValue("LocationTabelleLandescode").getText());
				// ZeichenkettenAttributTyp
					setLocationTabelleNummer(daten.getTextValue("LocationTabelleNummer").getText());
				// ZeichenkettenAttributTyp
					setLocationTabelleVersion(daten.getTextValue("LocationTabelleVersion").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTic3LocationTabelleInfo clone() {
		AtlTic3LocationTabelleInfo klon = new AtlTic3LocationTabelleInfo();
		
						klon.setLocationTabelleErweiterterLandescode(getLocationTabelleErweiterterLandescode());
						klon.setLocationTabelleLandescode(getLocationTabelleLandescode());
						klon.setLocationTabelleNummer(getLocationTabelleNummer());
						klon.setLocationTabelleVersion(getLocationTabelleVersion());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
