/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
TIC3 NetworkAreaDescriptionType.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTic3NetworkAreaDescriptionType implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _tIC3GebietName
			= new String
			()
			;
			private String
			 _tIC3GebietKategorie
			= new String
			()
			;
			private String
			 _tIC3GebietUnterkategorie
			= new String
			()
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3AreaCategoryNameType
			> _tIC3UmschliessendesGebiet = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3AreaCategoryNameType
			>(0, true);
			private String
			 _tIC3GebietLand
			= new String
			()
			;
	
		/**
		Name des Gebietes.
		<p>
		TIC3 Info XML Element: Name (NAM), The name of the object, in one or more languages configured on the system.
		</p>
		
		@return der Wert von TIC3GebietName.
		*/
			public String
			 getTIC3GebietName() {
			return _tIC3GebietName;
		}
	
		/**
		Name des Gebietes.
		<p>
		TIC3 Info XML Element: Name (NAM), The name of the object, in one or more languages configured on the system.
		</p>
		
		@param _tIC3GebietName der neue Wert von TIC3GebietName.
		*/
		public void setTIC3GebietName(String
		 _tIC3GebietName) {
			if (_tIC3GebietName.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._tIC3GebietName = _tIC3GebietName;
		}
	
		/**
		Kategorie des Gebietes.
		<p>
		TIC3 Info XML Element: Category (CAT), The area category such as "Nature", "Administrative area", and "Built-up area".
		</p>
		
		@return der Wert von TIC3GebietKategorie.
		*/
			public String
			 getTIC3GebietKategorie() {
			return _tIC3GebietKategorie;
		}
	
		/**
		Kategorie des Gebietes.
		<p>
		TIC3 Info XML Element: Category (CAT), The area category such as "Nature", "Administrative area", and "Built-up area".
		</p>
		
		@param _tIC3GebietKategorie der neue Wert von TIC3GebietKategorie.
		*/
		public void setTIC3GebietKategorie(String
		 _tIC3GebietKategorie) {
			if (_tIC3GebietKategorie.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._tIC3GebietKategorie = _tIC3GebietKategorie;
		}
	
		/**
		Unterkategorie des Gebietes.
		<p>
		TIC3 Info XML Element: SubCategory (SCA), The area subcategory such as "Country", "Sea", or "Forest".
		</p>
		
		@return der Wert von TIC3GebietUnterkategorie.
		*/
			public String
			 getTIC3GebietUnterkategorie() {
			return _tIC3GebietUnterkategorie;
		}
	
		/**
		Unterkategorie des Gebietes.
		<p>
		TIC3 Info XML Element: SubCategory (SCA), The area subcategory such as "Country", "Sea", or "Forest".
		</p>
		
		@param _tIC3GebietUnterkategorie der neue Wert von TIC3GebietUnterkategorie.
		*/
		public void setTIC3GebietUnterkategorie(String
		 _tIC3GebietUnterkategorie) {
			if (_tIC3GebietUnterkategorie.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._tIC3GebietUnterkategorie = _tIC3GebietUnterkategorie;
		}
	
		/**
		Umschließendes Gebiet.
		<p>
		TIC3 Info XML Element: EnclosingArea (ARE), A list of enclosing areas.
		</p>
		
		@return der Wert von TIC3UmschliessendesGebiet.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3AreaCategoryNameType
			> getTIC3UmschliessendesGebiet() {
			return _tIC3UmschliessendesGebiet;
		}
	
	
		/**
		Land des Gebietes.
		<p>
		TIC3 Info XML Element: Country (CTR), A reference to the "Country" which contains the location.
		</p>
		
		@return der Wert von TIC3GebietLand.
		*/
			public String
			 getTIC3GebietLand() {
			return _tIC3GebietLand;
		}
	
		/**
		Land des Gebietes.
		<p>
		TIC3 Info XML Element: Country (CTR), A reference to the "Country" which contains the location.
		</p>
		
		@param _tIC3GebietLand der neue Wert von TIC3GebietLand.
		*/
		public void setTIC3GebietLand(String
		 _tIC3GebietLand) {
			if (_tIC3GebietLand.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._tIC3GebietLand = _tIC3GebietLand;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getTIC3GebietName() != null) {
					datum.getTextValue("TIC3GebietName").setText(getTIC3GebietName());
				}
				// ZeichenkettenAttributTyp
				if (getTIC3GebietKategorie() != null) {
					datum.getTextValue("TIC3GebietKategorie").setText(getTIC3GebietKategorie());
				}
				// ZeichenkettenAttributTyp
				if (getTIC3GebietUnterkategorie() != null) {
					datum.getTextValue("TIC3GebietUnterkategorie").setText(getTIC3GebietUnterkategorie());
				}
				// AttributListenDefinition
					final Data.Array arrayTIC3UmschliessendesGebiet = datum.getArray("TIC3UmschliessendesGebiet");
					arrayTIC3UmschliessendesGebiet.setLength(getTIC3UmschliessendesGebiet().size());
					for (int i = 0; i < arrayTIC3UmschliessendesGebiet.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3AreaCategoryNameType
						 atl = getTIC3UmschliessendesGebiet().get(i);
						atl.bean2Atl(arrayTIC3UmschliessendesGebiet.getItem(i), factory);
	
					}
				// ZeichenkettenAttributTyp
				if (getTIC3GebietLand() != null) {
					datum.getTextValue("TIC3GebietLand").setText(getTIC3GebietLand());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setTIC3GebietName(daten.getTextValue("TIC3GebietName").getText());
				// ZeichenkettenAttributTyp
					setTIC3GebietKategorie(daten.getTextValue("TIC3GebietKategorie").getText());
				// ZeichenkettenAttributTyp
					setTIC3GebietUnterkategorie(daten.getTextValue("TIC3GebietUnterkategorie").getText());
				// AttributListenDefinition
					final Data.Array arrayTIC3UmschliessendesGebiet = daten.getArray("TIC3UmschliessendesGebiet");
					for (int i = 0; i < arrayTIC3UmschliessendesGebiet.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3AreaCategoryNameType
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3AreaCategoryNameType
						 ();
						atl.atl2Bean(arrayTIC3UmschliessendesGebiet.getItem(i), factory);
						getTIC3UmschliessendesGebiet().add(atl);
					}
				// ZeichenkettenAttributTyp
					setTIC3GebietLand(daten.getTextValue("TIC3GebietLand").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTic3NetworkAreaDescriptionType clone() {
		AtlTic3NetworkAreaDescriptionType klon = new AtlTic3NetworkAreaDescriptionType();
		
						klon.setTIC3GebietName(getTIC3GebietName());
						klon.setTIC3GebietKategorie(getTIC3GebietKategorie());
						klon.setTIC3GebietUnterkategorie(getTIC3GebietUnterkategorie());
					klon._tIC3UmschliessendesGebiet = getTIC3UmschliessendesGebiet().clone();
						klon.setTIC3GebietLand(getTIC3GebietLand());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
