/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
TIC3 NetworkPointOfInterestType.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTic3NetworkPointOfInterest implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _tIC3NetworkPointOfInterestIdentifier
			= new String
			()
			;
	
		/**
		NetworkPointOfInterestIdentifier.
		<p>
		TIC3 Info XML Element: NetworkPointOfInterestIdentifier (POI), A reference to "Point of Interest".
		</p>
		
		@return der Wert von TIC3NetworkPointOfInterestIdentifier.
		*/
			public String
			 getTIC3NetworkPointOfInterestIdentifier() {
			return _tIC3NetworkPointOfInterestIdentifier;
		}
	
		/**
		NetworkPointOfInterestIdentifier.
		<p>
		TIC3 Info XML Element: NetworkPointOfInterestIdentifier (POI), A reference to "Point of Interest".
		</p>
		
		@param _tIC3NetworkPointOfInterestIdentifier der neue Wert von TIC3NetworkPointOfInterestIdentifier.
		*/
		public void setTIC3NetworkPointOfInterestIdentifier(String
		 _tIC3NetworkPointOfInterestIdentifier) {
			if (_tIC3NetworkPointOfInterestIdentifier.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._tIC3NetworkPointOfInterestIdentifier = _tIC3NetworkPointOfInterestIdentifier;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getTIC3NetworkPointOfInterestIdentifier() != null) {
					datum.getTextValue("TIC3NetworkPointOfInterestIdentifier").setText(getTIC3NetworkPointOfInterestIdentifier());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setTIC3NetworkPointOfInterestIdentifier(daten.getTextValue("TIC3NetworkPointOfInterestIdentifier").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTic3NetworkPointOfInterest clone() {
		AtlTic3NetworkPointOfInterest klon = new AtlTic3NetworkPointOfInterest();
		
						klon.setTIC3NetworkPointOfInterestIdentifier(getTIC3NetworkPointOfInterestIdentifier());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
