/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
TIC3 DestinationType.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTic3Reiseziel implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _name
			= new String
			()
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3HimmelsRichtung
			> _himmelsrichtung = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3HimmelsRichtung
			>(1, true);
	
		/**
		Name.
		<p>
		TIC3 Info XML Element: Name (NAM), The name of the object, in one or more languages configured on the system.
		</p>
		
		@return der Wert von Name.
		*/
			public String
			 getName() {
			return _name;
		}
	
		/**
		Name.
		<p>
		TIC3 Info XML Element: Name (NAM), The name of the object, in one or more languages configured on the system.
		</p>
		
		@param _name der neue Wert von Name.
		*/
		public void setName(String
		 _name) {
			if (_name.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._name = _name;
		}
	
		/**
		Name.
		<p>
		TIC3 Info XML Element: CompassDirection (CPS), The name corresponding to a compass direction such as "North", "South", "East", or "West".
		</p>
		
		@return der Wert von Himmelsrichtung.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3HimmelsRichtung
			> getHimmelsrichtung() {
			return _himmelsrichtung;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getName() != null) {
					datum.getTextValue("Name").setText(getName());
				}
				// GanzzahlAttributTyp
				if (getHimmelsrichtung() != null) {
					final Data.NumberArray arrayHimmelsrichtung = datum.
						getUnscaledArray
						("Himmelsrichtung");
					arrayHimmelsrichtung.setLength(getHimmelsrichtung().size());
					for (int i = 0; i < arrayHimmelsrichtung.getLength(); ++i) {
						arrayHimmelsrichtung.getValue(i).set(getHimmelsrichtung().get(i).getValue());
					}
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setName(daten.getTextValue("Name").getText());
				// GanzzahlAttributTyp
					final Data.NumberArray arrayHimmelsrichtung = daten.
						getUnscaledArray
					("Himmelsrichtung");
	
					for (int i = 0; i < arrayHimmelsrichtung.getLength(); ++i) {
	                    if (arrayHimmelsrichtung.getValue(i).isState()) {
	                        getHimmelsrichtung().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3HimmelsRichtung
	                        .getZustand(arrayHimmelsrichtung.getValue(i).getState().getName()));
	                    } else {
	                    getHimmelsrichtung().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3HimmelsRichtung
	                    (arrayHimmelsrichtung.
	                    		byteValue
	                    (i)));
	                    }
	                }
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTic3Reiseziel clone() {
		AtlTic3Reiseziel klon = new AtlTic3Reiseziel();
		
						klon.setName(getName());
					klon._himmelsrichtung = getHimmelsrichtung().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
