/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
&gt;TIC3 TrafficAndTravelEventAttributeType.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTic3TrafficAndTravelEventAttributeType implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "")
			private String
			 _beschreibung
			= new String
			()
			;
			private String
			 _attribut
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
			 _wert
			;
	
		/**
		Beschreibung aus Wert des 'description'-Attributes.
		<p>
		
		</p>
		
		@return der Wert von Beschreibung.
		*/
			public String
			 getBeschreibung() {
			return _beschreibung;
		}
	
		/**
		Beschreibung aus Wert des 'description'-Attributes.
		<p>
		
		</p>
		
		@param _beschreibung der neue Wert von Beschreibung.
		*/
		public void setBeschreibung(String
		 _beschreibung) {
			if (_beschreibung.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._beschreibung = _beschreibung;
		}
	
		/**
		TIC3 Info XML Element: Attribute (ATT), A reference to "Traffic And Travel Event Attribute".
		<p>
		
		</p>
		
		@return der Wert von Attribut.
		*/
			public String
			 getAttribut() {
			return _attribut;
		}
	
		/**
		TIC3 Info XML Element: Attribute (ATT), A reference to "Traffic And Travel Event Attribute".
		<p>
		
		</p>
		
		@param _attribut der neue Wert von Attribut.
		*/
		public void setAttribut(String
		 _attribut) {
			if (_attribut.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._attribut = _attribut;
		}
	
		/**
		TIC3 Info XML Element: Value (VAL), The value which is assigned to the traffic and travel	event code attribute.
		<p>
		
		</p>
		
		@return der Wert von Wert.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
			 getWert() {
			return _wert;
		}
	
		/**
		TIC3 Info XML Element: Value (VAL), The value which is assigned to the traffic and travel	event code attribute.
		<p>
		
		</p>
		
		@param _wert der neue Wert von Wert.
		*/
		public void setWert(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
		 _wert) {
			this._wert = _wert;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getBeschreibung() != null) {
					datum.getTextValue("Beschreibung").setText(getBeschreibung());
				}
				// ZeichenkettenAttributTyp
				if (getAttribut() != null) {
					datum.getTextValue("Attribut").setText(getAttribut());
				}
				// GanzzahlAttributTyp
				if (getWert() != null) {
	                if (getWert().isZustand()) {
	                    datum.getUnscaledValue("Wert").setText(getWert().toString());
	                } else {
						datum.
						getScaledValue
	                	("Wert").set(getWert().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setBeschreibung(daten.getTextValue("Beschreibung").getText());
				// ZeichenkettenAttributTyp
					setAttribut(daten.getTextValue("Attribut").getText());
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Wert").isState()) {
							setWert(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
							.getZustand(daten.getScaledValue("Wert").getText()));
						} else {
						setWert(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
						(daten.
							getScaledValue
						("Wert").
							doubleValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTic3TrafficAndTravelEventAttributeType clone() {
		AtlTic3TrafficAndTravelEventAttributeType klon = new AtlTic3TrafficAndTravelEventAttributeType();
		
						klon.setBeschreibung(getBeschreibung());
						klon.setAttribut(getAttribut());
						klon.setWert(getWert());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
