/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
TIC3 DetourRouteType. (Umleitungsstrecke).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTic3Umleitung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _name
			= new String
			()
			;
			private String
			 _beschreibung
			= new String
			()
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Location
			> _lokation = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Location
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3FahrzeugTyp
			> _fahrzeugtyp = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3FahrzeugTyp
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Reiseziel
			> _reiseziel = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Reiseziel
			>(1, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
			 _fahrzeuggewichtAb
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
			 _fahrzeugbreiteAb
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
			 _fahrzeughoeheAb
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
			 _fahrzeugLaengeAb
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
			 _maximalesFahrzeugGewicht
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
			 _maximaleFahrzeugBreite
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
			 _maximaleFahrzeugHoehe
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
			 _maximaleFahrzeugLaenge
			;
			@Defaultwert(wert = "Nein")
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _bedarfsumleitung
			;
	
		/**
		Name.
		<p>
		TIC3 Info XML Element: Name (NAM), The name of the diversion route, in one or more languages configured on the system. The name is used to easily identify this diversion route when later viewing or selecting this route in another window.
		</p>
		
		@return der Wert von Name.
		*/
			public String
			 getName() {
			return _name;
		}
	
		/**
		Name.
		<p>
		TIC3 Info XML Element: Name (NAM), The name of the diversion route, in one or more languages configured on the system. The name is used to easily identify this diversion route when later viewing or selecting this route in another window.
		</p>
		
		@param _name der neue Wert von Name.
		*/
		public void setName(String
		 _name) {
			if (_name.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._name = _name;
		}
	
		/**
		Beschreibung.
		<p>
		TIC3 Info XML Element: Description (DES), The description of the diversion route, in one or more languages configured on the system. The description is usually a summary containing enough detail for travellers to understand and decide if they will use this diversion route. The description becomes part of the traffic information provided.
		</p>
		
		@return der Wert von Beschreibung.
		*/
			public String
			 getBeschreibung() {
			return _beschreibung;
		}
	
		/**
		Beschreibung.
		<p>
		TIC3 Info XML Element: Description (DES), The description of the diversion route, in one or more languages configured on the system. The description is usually a summary containing enough detail for travellers to understand and decide if they will use this diversion route. The description becomes part of the traffic information provided.
		</p>
		
		@param _beschreibung der neue Wert von Beschreibung.
		*/
		public void setBeschreibung(String
		 _beschreibung) {
			if (_beschreibung.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._beschreibung = _beschreibung;
		}
	
		/**
		Lokation.
		<p>
		TIC3 Info XML Element: Location (ROU), Information about a diversion route specified by one or more location referencing methods such as TIC3 location, geographical position, or TMC location.
		</p>
		
		@return der Wert von Lokation.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Location
			> getLokation() {
			return _lokation;
		}
	
	
		/**
		Lokation.
		<p>
		TIC3 Info XML Element: VehicleType (VTY), The type of the vehicle such as car, truck, or any type.
		</p>
		
		@return der Wert von Fahrzeugtyp.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3FahrzeugTyp
			> getFahrzeugtyp() {
			return _fahrzeugtyp;
		}
	
	
		/**
		Reiseziel.
		<p>
		TIC3 Info XML Element: Destination (DST), The destination for which the diversion is specified.
		</p>
		
		@return der Wert von Reiseziel.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Reiseziel
			> getReiseziel() {
			return _reiseziel;
		}
	
	
		/**
		Ab Fahrzeuggewicht.
		<p>
		TIC3 Info XML Element: VehicleWeightOver (VWE), The vehicle weight above which the diversion route is specified.
		</p>
		
		@return der Wert von FahrzeuggewichtAb.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
			 getFahrzeuggewichtAb() {
			return _fahrzeuggewichtAb;
		}
	
		/**
		Ab Fahrzeuggewicht.
		<p>
		TIC3 Info XML Element: VehicleWeightOver (VWE), The vehicle weight above which the diversion route is specified.
		</p>
		
		@param _fahrzeuggewichtAb der neue Wert von FahrzeuggewichtAb.
		*/
		public void setFahrzeuggewichtAb(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
		 _fahrzeuggewichtAb) {
			this._fahrzeuggewichtAb = _fahrzeuggewichtAb;
		}
	
		/**
		Ab Fahrzeugbreite.
		<p>
		TIC3 Info XML Element: VehicleWidthOver (VW1), The vehicle width above which the diversion route is specified.
		</p>
		
		@return der Wert von FahrzeugbreiteAb.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
			 getFahrzeugbreiteAb() {
			return _fahrzeugbreiteAb;
		}
	
		/**
		Ab Fahrzeugbreite.
		<p>
		TIC3 Info XML Element: VehicleWidthOver (VW1), The vehicle width above which the diversion route is specified.
		</p>
		
		@param _fahrzeugbreiteAb der neue Wert von FahrzeugbreiteAb.
		*/
		public void setFahrzeugbreiteAb(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
		 _fahrzeugbreiteAb) {
			this._fahrzeugbreiteAb = _fahrzeugbreiteAb;
		}
	
		/**
		Ab Fahrzeughöhe.
		<p>
		TIC3 Info XML Element: VehicleHeightOver (VHE), The vehicle height above which the diversion route is specified.
		</p>
		
		@return der Wert von FahrzeughoeheAb.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
			 getFahrzeughoeheAb() {
			return _fahrzeughoeheAb;
		}
	
		/**
		Ab Fahrzeughöhe.
		<p>
		TIC3 Info XML Element: VehicleHeightOver (VHE), The vehicle height above which the diversion route is specified.
		</p>
		
		@param _fahrzeughoeheAb der neue Wert von FahrzeughoeheAb.
		*/
		public void setFahrzeughoeheAb(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
		 _fahrzeughoeheAb) {
			this._fahrzeughoeheAb = _fahrzeughoeheAb;
		}
	
		/**
		Ab Fahrzeuglänge.
		<p>
		TIC3 Info XML Element: VehicleLengthOver (VLE), The vehicle length above which the diversion route is specified.
		</p>
		
		@return der Wert von FahrzeugLaengeAb.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
			 getFahrzeugLaengeAb() {
			return _fahrzeugLaengeAb;
		}
	
		/**
		Ab Fahrzeuglänge.
		<p>
		TIC3 Info XML Element: VehicleLengthOver (VLE), The vehicle length above which the diversion route is specified.
		</p>
		
		@param _fahrzeugLaengeAb der neue Wert von FahrzeugLaengeAb.
		*/
		public void setFahrzeugLaengeAb(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
		 _fahrzeugLaengeAb) {
			this._fahrzeugLaengeAb = _fahrzeugLaengeAb;
		}
	
		/**
		Maximales Fahrzeuggewicht.
		<p>
		TIC3 Info XML Element: MaximumVehicleWeight (MVW), The maximum weight of vehicles which can use the diversion route.
		</p>
		
		@return der Wert von MaximalesFahrzeugGewicht.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
			 getMaximalesFahrzeugGewicht() {
			return _maximalesFahrzeugGewicht;
		}
	
		/**
		Maximales Fahrzeuggewicht.
		<p>
		TIC3 Info XML Element: MaximumVehicleWeight (MVW), The maximum weight of vehicles which can use the diversion route.
		</p>
		
		@param _maximalesFahrzeugGewicht der neue Wert von MaximalesFahrzeugGewicht.
		*/
		public void setMaximalesFahrzeugGewicht(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
		 _maximalesFahrzeugGewicht) {
			this._maximalesFahrzeugGewicht = _maximalesFahrzeugGewicht;
		}
	
		/**
		Maximale Fahrzeugbreite.
		<p>
		TIC3 Info XML Element: MaximumVehicleWidth (MVI), The maximum width of vehicles which can use the diversion route.
		</p>
		
		@return der Wert von MaximaleFahrzeugBreite.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
			 getMaximaleFahrzeugBreite() {
			return _maximaleFahrzeugBreite;
		}
	
		/**
		Maximale Fahrzeugbreite.
		<p>
		TIC3 Info XML Element: MaximumVehicleWidth (MVI), The maximum width of vehicles which can use the diversion route.
		</p>
		
		@param _maximaleFahrzeugBreite der neue Wert von MaximaleFahrzeugBreite.
		*/
		public void setMaximaleFahrzeugBreite(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
		 _maximaleFahrzeugBreite) {
			this._maximaleFahrzeugBreite = _maximaleFahrzeugBreite;
		}
	
		/**
		Maximale Fahrzeughöhe.
		<p>
		TIC3 Info XML Element: MaximumVehicleHeight (MVH), The maximum height of vehicles which can use the diversion route.
		</p>
		
		@return der Wert von MaximaleFahrzeugHoehe.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
			 getMaximaleFahrzeugHoehe() {
			return _maximaleFahrzeugHoehe;
		}
	
		/**
		Maximale Fahrzeughöhe.
		<p>
		TIC3 Info XML Element: MaximumVehicleHeight (MVH), The maximum height of vehicles which can use the diversion route.
		</p>
		
		@param _maximaleFahrzeugHoehe der neue Wert von MaximaleFahrzeugHoehe.
		*/
		public void setMaximaleFahrzeugHoehe(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
		 _maximaleFahrzeugHoehe) {
			this._maximaleFahrzeugHoehe = _maximaleFahrzeugHoehe;
		}
	
		/**
		Maximale Fahrzeuglänge.
		<p>
		TIC3 Info XML Element: MaximumVehicleLength (MVL), The maximum length of vehicles which can use the diversion route.
		</p>
		
		@return der Wert von MaximaleFahrzeugLaenge.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
			 getMaximaleFahrzeugLaenge() {
			return _maximaleFahrzeugLaenge;
		}
	
		/**
		Maximale Fahrzeuglänge.
		<p>
		TIC3 Info XML Element: MaximumVehicleLength (MVL), The maximum length of vehicles which can use the diversion route.
		</p>
		
		@param _maximaleFahrzeugLaenge der neue Wert von MaximaleFahrzeugLaenge.
		*/
		public void setMaximaleFahrzeugLaenge(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
		 _maximaleFahrzeugLaenge) {
			this._maximaleFahrzeugLaenge = _maximaleFahrzeugLaenge;
		}
	
		/**
		Enthält permanente Umleitungen. (Bedarfsumleitung).
		<p>
		TIC3 Info XML Element: PermanentDiversionRoute (PDR), Indicates whether or not this route was created using one or more permanent diversion routes.
		</p>
		
		@return der Wert von Bedarfsumleitung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getBedarfsumleitung() {
			return _bedarfsumleitung;
		}
	
		/**
		Enthält permanente Umleitungen. (Bedarfsumleitung).
		<p>
		TIC3 Info XML Element: PermanentDiversionRoute (PDR), Indicates whether or not this route was created using one or more permanent diversion routes.
		</p>
		
		@param _bedarfsumleitung der neue Wert von Bedarfsumleitung.
		*/
		public void setBedarfsumleitung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _bedarfsumleitung) {
			this._bedarfsumleitung = _bedarfsumleitung;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getName() != null) {
					datum.getTextValue("Name").setText(getName());
				}
				// ZeichenkettenAttributTyp
				if (getBeschreibung() != null) {
					datum.getTextValue("Beschreibung").setText(getBeschreibung());
				}
				// AttributListenDefinition
					final Data.Array arrayLokation = datum.getArray("Lokation");
					arrayLokation.setLength(getLokation().size());
					for (int i = 0; i < arrayLokation.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Location
						 atl = getLokation().get(i);
						atl.bean2Atl(arrayLokation.getItem(i), factory);
	
					}
				// GanzzahlAttributTyp
				if (getFahrzeugtyp() != null) {
					final Data.NumberArray arrayFahrzeugtyp = datum.
						getUnscaledArray
						("Fahrzeugtyp");
					arrayFahrzeugtyp.setLength(getFahrzeugtyp().size());
					for (int i = 0; i < arrayFahrzeugtyp.getLength(); ++i) {
						arrayFahrzeugtyp.getValue(i).set(getFahrzeugtyp().get(i).getValue());
					}
				}
				// AttributListenDefinition
					final Data.Array arrayReiseziel = datum.getArray("Reiseziel");
					arrayReiseziel.setLength(getReiseziel().size());
					for (int i = 0; i < arrayReiseziel.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Reiseziel
						 atl = getReiseziel().get(i);
						atl.bean2Atl(arrayReiseziel.getItem(i), factory);
	
					}
				// GanzzahlAttributTyp
				if (getFahrzeuggewichtAb() != null) {
	                if (getFahrzeuggewichtAb().isZustand()) {
	                    datum.getUnscaledValue("FahrzeuggewichtAb").setText(getFahrzeuggewichtAb().toString());
	                } else {
						datum.
						getScaledValue
	                	("FahrzeuggewichtAb").set(getFahrzeuggewichtAb().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getFahrzeugbreiteAb() != null) {
	                if (getFahrzeugbreiteAb().isZustand()) {
	                    datum.getUnscaledValue("FahrzeugbreiteAb").setText(getFahrzeugbreiteAb().toString());
	                } else {
						datum.
						getScaledValue
	                	("FahrzeugbreiteAb").set(getFahrzeugbreiteAb().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getFahrzeughoeheAb() != null) {
	                if (getFahrzeughoeheAb().isZustand()) {
	                    datum.getUnscaledValue("FahrzeughöheAb").setText(getFahrzeughoeheAb().toString());
	                } else {
						datum.
						getScaledValue
	                	("FahrzeughöheAb").set(getFahrzeughoeheAb().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getFahrzeugLaengeAb() != null) {
	                if (getFahrzeugLaengeAb().isZustand()) {
	                    datum.getUnscaledValue("FahrzeugLängeAb").setText(getFahrzeugLaengeAb().toString());
	                } else {
						datum.
						getScaledValue
	                	("FahrzeugLängeAb").set(getFahrzeugLaengeAb().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getMaximalesFahrzeugGewicht() != null) {
	                if (getMaximalesFahrzeugGewicht().isZustand()) {
	                    datum.getUnscaledValue("MaximalesFahrzeugGewicht").setText(getMaximalesFahrzeugGewicht().toString());
	                } else {
						datum.
						getScaledValue
	                	("MaximalesFahrzeugGewicht").set(getMaximalesFahrzeugGewicht().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getMaximaleFahrzeugBreite() != null) {
	                if (getMaximaleFahrzeugBreite().isZustand()) {
	                    datum.getUnscaledValue("MaximaleFahrzeugBreite").setText(getMaximaleFahrzeugBreite().toString());
	                } else {
						datum.
						getScaledValue
	                	("MaximaleFahrzeugBreite").set(getMaximaleFahrzeugBreite().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getMaximaleFahrzeugHoehe() != null) {
	                if (getMaximaleFahrzeugHoehe().isZustand()) {
	                    datum.getUnscaledValue("MaximaleFahrzeugHöhe").setText(getMaximaleFahrzeugHoehe().toString());
	                } else {
						datum.
						getScaledValue
	                	("MaximaleFahrzeugHöhe").set(getMaximaleFahrzeugHoehe().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getMaximaleFahrzeugLaenge() != null) {
	                if (getMaximaleFahrzeugLaenge().isZustand()) {
	                    datum.getUnscaledValue("MaximaleFahrzeugLänge").setText(getMaximaleFahrzeugLaenge().toString());
	                } else {
						datum.
						getScaledValue
	                	("MaximaleFahrzeugLänge").set(getMaximaleFahrzeugLaenge().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getBedarfsumleitung() != null) {
	                if (getBedarfsumleitung().isZustand()) {
	                    datum.getUnscaledValue("Bedarfsumleitung").setText(getBedarfsumleitung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Bedarfsumleitung").set(getBedarfsumleitung().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setName(daten.getTextValue("Name").getText());
				// ZeichenkettenAttributTyp
					setBeschreibung(daten.getTextValue("Beschreibung").getText());
				// AttributListenDefinition
					final Data.Array arrayLokation = daten.getArray("Lokation");
					for (int i = 0; i < arrayLokation.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Location
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Location
						 ();
						atl.atl2Bean(arrayLokation.getItem(i), factory);
						getLokation().add(atl);
					}
				// GanzzahlAttributTyp
					final Data.NumberArray arrayFahrzeugtyp = daten.
						getUnscaledArray
					("Fahrzeugtyp");
	
					for (int i = 0; i < arrayFahrzeugtyp.getLength(); ++i) {
	                    if (arrayFahrzeugtyp.getValue(i).isState()) {
	                        getFahrzeugtyp().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3FahrzeugTyp
	                        .getZustand(arrayFahrzeugtyp.getValue(i).getState().getName()));
	                    } else {
	                    getFahrzeugtyp().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3FahrzeugTyp
	                    (arrayFahrzeugtyp.
	                    		byteValue
	                    (i)));
	                    }
	                }
				// AttributListenDefinition
					final Data.Array arrayReiseziel = daten.getArray("Reiseziel");
					for (int i = 0; i < arrayReiseziel.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Reiseziel
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Reiseziel
						 ();
						atl.atl2Bean(arrayReiseziel.getItem(i), factory);
						getReiseziel().add(atl);
					}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("FahrzeuggewichtAb").isState()) {
							setFahrzeuggewichtAb(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
							.getZustand(daten.getScaledValue("FahrzeuggewichtAb").getText()));
						} else {
						setFahrzeuggewichtAb(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
						(daten.
							getScaledValue
						("FahrzeuggewichtAb").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("FahrzeugbreiteAb").isState()) {
							setFahrzeugbreiteAb(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
							.getZustand(daten.getScaledValue("FahrzeugbreiteAb").getText()));
						} else {
						setFahrzeugbreiteAb(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
						(daten.
							getScaledValue
						("FahrzeugbreiteAb").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("FahrzeughöheAb").isState()) {
							setFahrzeughoeheAb(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
							.getZustand(daten.getScaledValue("FahrzeughöheAb").getText()));
						} else {
						setFahrzeughoeheAb(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
						(daten.
							getScaledValue
						("FahrzeughöheAb").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("FahrzeugLängeAb").isState()) {
							setFahrzeugLaengeAb(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
							.getZustand(daten.getScaledValue("FahrzeugLängeAb").getText()));
						} else {
						setFahrzeugLaengeAb(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
						(daten.
							getScaledValue
						("FahrzeugLängeAb").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("MaximalesFahrzeugGewicht").isState()) {
							setMaximalesFahrzeugGewicht(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
							.getZustand(daten.getScaledValue("MaximalesFahrzeugGewicht").getText()));
						} else {
						setMaximalesFahrzeugGewicht(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
						(daten.
							getScaledValue
						("MaximalesFahrzeugGewicht").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("MaximaleFahrzeugBreite").isState()) {
							setMaximaleFahrzeugBreite(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
							.getZustand(daten.getScaledValue("MaximaleFahrzeugBreite").getText()));
						} else {
						setMaximaleFahrzeugBreite(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
						(daten.
							getScaledValue
						("MaximaleFahrzeugBreite").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("MaximaleFahrzeugHöhe").isState()) {
							setMaximaleFahrzeugHoehe(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
							.getZustand(daten.getScaledValue("MaximaleFahrzeugHöhe").getText()));
						} else {
						setMaximaleFahrzeugHoehe(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
						(daten.
							getScaledValue
						("MaximaleFahrzeugHöhe").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("MaximaleFahrzeugLänge").isState()) {
							setMaximaleFahrzeugLaenge(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
							.getZustand(daten.getScaledValue("MaximaleFahrzeugLänge").getText()));
						} else {
						setMaximaleFahrzeugLaenge(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
						(daten.
							getScaledValue
						("MaximaleFahrzeugLänge").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Bedarfsumleitung").isState()) {
							setBedarfsumleitung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Bedarfsumleitung").getText()));
						} else {
						setBedarfsumleitung(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Bedarfsumleitung").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTic3Umleitung clone() {
		AtlTic3Umleitung klon = new AtlTic3Umleitung();
		
						klon.setName(getName());
						klon.setBeschreibung(getBeschreibung());
					klon._lokation = getLokation().clone();
					klon._fahrzeugtyp = getFahrzeugtyp().clone();
					klon._reiseziel = getReiseziel().clone();
						klon.setFahrzeuggewichtAb(getFahrzeuggewichtAb());
						klon.setFahrzeugbreiteAb(getFahrzeugbreiteAb());
						klon.setFahrzeughoeheAb(getFahrzeughoeheAb());
						klon.setFahrzeugLaengeAb(getFahrzeugLaengeAb());
						klon.setMaximalesFahrzeugGewicht(getMaximalesFahrzeugGewicht());
						klon.setMaximaleFahrzeugBreite(getMaximaleFahrzeugBreite());
						klon.setMaximaleFahrzeugHoehe(getMaximaleFahrzeugHoehe());
						klon.setMaximaleFahrzeugLaenge(getMaximaleFahrzeugLaenge());
						klon.setBedarfsumleitung(getBedarfsumleitung());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
