/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
&gt;TIC3 ScheduleType.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTic3Zeitplan implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "")
			private String
			 _beschreibung
			= new String
			()
			;
			private Feld<	Zeitstempel
			> _startZeit = new Feld<	Zeitstempel
			>(1, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _startZeitUnbekannt
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _startetUmMitternacht
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _startzeitUngefaehr
			;
			private Feld<	Zeitstempel
			> _endZeit = new Feld<	Zeitstempel
			>(1, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _endZeitUnbekannt
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _endetUmMitternacht
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _endzeitUngefaehr
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3RecurrenceType
			> _wiederholung = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3RecurrenceType
			>(0, true);
	
		/**
		Beschreibung aus Wert des 'description'-Attributes.
		<p>
		
		</p>
		
		@return der Wert von Beschreibung.
		*/
			public String
			 getBeschreibung() {
			return _beschreibung;
		}
	
		/**
		Beschreibung aus Wert des 'description'-Attributes.
		<p>
		
		</p>
		
		@param _beschreibung der neue Wert von Beschreibung.
		*/
		public void setBeschreibung(String
		 _beschreibung) {
			if (_beschreibung.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._beschreibung = _beschreibung;
		}
	
		/**
		Startzeit.
		<p>
		TIC3 Info XML Element: StartTime (BGN), The date and time when the overall schedule starts.
		</p>
		
		@return der Wert von StartZeit.
		*/
			public Feld<	Zeitstempel
			> getStartZeit() {
			return _startZeit;
		}
	
	
		/**
		Startzeit unbekannt.
		<p>
		TIC3 Info XML Element: StartTimeUnknown (STU), Specifies whether or not the start time is unknown, and when unknown, the start time is assumed to be at midnight.
		</p>
		
		@return der Wert von StartZeitUnbekannt.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getStartZeitUnbekannt() {
			return _startZeitUnbekannt;
		}
	
		/**
		Startzeit unbekannt.
		<p>
		TIC3 Info XML Element: StartTimeUnknown (STU), Specifies whether or not the start time is unknown, and when unknown, the start time is assumed to be at midnight.
		</p>
		
		@param _startZeitUnbekannt der neue Wert von StartZeitUnbekannt.
		*/
		public void setStartZeitUnbekannt(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _startZeitUnbekannt) {
			this._startZeitUnbekannt = _startZeitUnbekannt;
		}
	
		/**
		Startet um Mitternacht.
		<p>
		TIC3 Info XML Element: StartsAtMidnight (SAM), Specifies whether or not the start time is at midnight.
		</p>
		
		@return der Wert von StartetUmMitternacht.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getStartetUmMitternacht() {
			return _startetUmMitternacht;
		}
	
		/**
		Startet um Mitternacht.
		<p>
		TIC3 Info XML Element: StartsAtMidnight (SAM), Specifies whether or not the start time is at midnight.
		</p>
		
		@param _startetUmMitternacht der neue Wert von StartetUmMitternacht.
		*/
		public void setStartetUmMitternacht(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _startetUmMitternacht) {
			this._startetUmMitternacht = _startetUmMitternacht;
		}
	
		/**
		Startzeit ungefähr.
		<p>
		TIC3 Info XML Element: StartTimeApproximate (STP), Specifies whether or not the start time is approximate to indicate that the event will start shortly before or after.
		</p>
		
		@return der Wert von StartzeitUngefaehr.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getStartzeitUngefaehr() {
			return _startzeitUngefaehr;
		}
	
		/**
		Startzeit ungefähr.
		<p>
		TIC3 Info XML Element: StartTimeApproximate (STP), Specifies whether or not the start time is approximate to indicate that the event will start shortly before or after.
		</p>
		
		@param _startzeitUngefaehr der neue Wert von StartzeitUngefaehr.
		*/
		public void setStartzeitUngefaehr(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _startzeitUngefaehr) {
			this._startzeitUngefaehr = _startzeitUngefaehr;
		}
	
		/**
		Endzeit.
		<p>
		TIC3 Info XML Element: EndTime (END), The date and time when the overall schedule ends.
		</p>
		
		@return der Wert von EndZeit.
		*/
			public Feld<	Zeitstempel
			> getEndZeit() {
			return _endZeit;
		}
	
	
		/**
		Endzeit unbekannt.
		<p>
		TIC3 Info XML Element: EndTimeUnknown (ETU), Specifies whether or not the end time is unknown, and when unknown, the end time is assumed to be just before midnight.
		</p>
		
		@return der Wert von EndZeitUnbekannt.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getEndZeitUnbekannt() {
			return _endZeitUnbekannt;
		}
	
		/**
		Endzeit unbekannt.
		<p>
		TIC3 Info XML Element: EndTimeUnknown (ETU), Specifies whether or not the end time is unknown, and when unknown, the end time is assumed to be just before midnight.
		</p>
		
		@param _endZeitUnbekannt der neue Wert von EndZeitUnbekannt.
		*/
		public void setEndZeitUnbekannt(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _endZeitUnbekannt) {
			this._endZeitUnbekannt = _endZeitUnbekannt;
		}
	
		/**
		Endet um Mitternacht.
		<p>
		TIC3 Info XML Element: EndsAtMidnight (EAM), Specifies whether or not the end time is just before midnight.
		</p>
		
		@return der Wert von EndetUmMitternacht.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getEndetUmMitternacht() {
			return _endetUmMitternacht;
		}
	
		/**
		Endet um Mitternacht.
		<p>
		TIC3 Info XML Element: EndsAtMidnight (EAM), Specifies whether or not the end time is just before midnight.
		</p>
		
		@param _endetUmMitternacht der neue Wert von EndetUmMitternacht.
		*/
		public void setEndetUmMitternacht(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _endetUmMitternacht) {
			this._endetUmMitternacht = _endetUmMitternacht;
		}
	
		/**
		Endzeit ungefähr.
		<p>
		TIC3 Info XML Element: EndTimeApproximate (ETP), Specifies whether or not the end time is approximate to indicate that the event will end shortly before or after.
		</p>
		
		@return der Wert von EndzeitUngefaehr.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getEndzeitUngefaehr() {
			return _endzeitUngefaehr;
		}
	
		/**
		Endzeit ungefähr.
		<p>
		TIC3 Info XML Element: EndTimeApproximate (ETP), Specifies whether or not the end time is approximate to indicate that the event will end shortly before or after.
		</p>
		
		@param _endzeitUngefaehr der neue Wert von EndzeitUngefaehr.
		*/
		public void setEndzeitUngefaehr(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _endzeitUngefaehr) {
			this._endzeitUngefaehr = _endzeitUngefaehr;
		}
	
		/**
		Wiederholung.
		<p>
		TIC3 Info XML Element: Recurrence (REC), A list of recurring periods between the overall begin and end times during which the overall schedule is limited to specific days and times.
		</p>
		
		@return der Wert von Wiederholung.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3RecurrenceType
			> getWiederholung() {
			return _wiederholung;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getBeschreibung() != null) {
					datum.getTextValue("Beschreibung").setText(getBeschreibung());
				}
				// ZeitstempelAttributTyp
					final Data.TimeArray arrayStartZeit = datum.getTimeArray("StartZeit");
					arrayStartZeit.setLength(getStartZeit().size());
					for (int i = 0; i < arrayStartZeit.getLength(); ++i) {
						arrayStartZeit.getTimeValue(i).setMillis(getStartZeit().get(i).getTime());
					}
				// GanzzahlAttributTyp
				if (getStartZeitUnbekannt() != null) {
	                if (getStartZeitUnbekannt().isZustand()) {
	                    datum.getUnscaledValue("StartZeitUnbekannt").setText(getStartZeitUnbekannt().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("StartZeitUnbekannt").set(getStartZeitUnbekannt().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getStartetUmMitternacht() != null) {
	                if (getStartetUmMitternacht().isZustand()) {
	                    datum.getUnscaledValue("StartetUmMitternacht").setText(getStartetUmMitternacht().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("StartetUmMitternacht").set(getStartetUmMitternacht().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getStartzeitUngefaehr() != null) {
	                if (getStartzeitUngefaehr().isZustand()) {
	                    datum.getUnscaledValue("StartzeitUngefähr").setText(getStartzeitUngefaehr().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("StartzeitUngefähr").set(getStartzeitUngefaehr().getValue());
	                }
				}
				// ZeitstempelAttributTyp
					final Data.TimeArray arrayEndZeit = datum.getTimeArray("EndZeit");
					arrayEndZeit.setLength(getEndZeit().size());
					for (int i = 0; i < arrayEndZeit.getLength(); ++i) {
						arrayEndZeit.getTimeValue(i).setMillis(getEndZeit().get(i).getTime());
					}
				// GanzzahlAttributTyp
				if (getEndZeitUnbekannt() != null) {
	                if (getEndZeitUnbekannt().isZustand()) {
	                    datum.getUnscaledValue("EndZeitUnbekannt").setText(getEndZeitUnbekannt().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("EndZeitUnbekannt").set(getEndZeitUnbekannt().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getEndetUmMitternacht() != null) {
	                if (getEndetUmMitternacht().isZustand()) {
	                    datum.getUnscaledValue("EndetUmMitternacht").setText(getEndetUmMitternacht().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("EndetUmMitternacht").set(getEndetUmMitternacht().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getEndzeitUngefaehr() != null) {
	                if (getEndzeitUngefaehr().isZustand()) {
	                    datum.getUnscaledValue("EndzeitUngefähr").setText(getEndzeitUngefaehr().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("EndzeitUngefähr").set(getEndzeitUngefaehr().getValue());
	                }
				}
				// AttributListenDefinition
					final Data.Array arrayWiederholung = datum.getArray("Wiederholung");
					arrayWiederholung.setLength(getWiederholung().size());
					for (int i = 0; i < arrayWiederholung.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3RecurrenceType
						 atl = getWiederholung().get(i);
						atl.bean2Atl(arrayWiederholung.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setBeschreibung(daten.getTextValue("Beschreibung").getText());
				// ZeitstempelAttributTyp
					final Data.Array arrayStartZeit = daten.getArray("StartZeit");
					for (int i = 0; i < arrayStartZeit.getLength(); ++i) {
							Zeitstempel
						 atl = new 	Zeitstempel
						 (arrayStartZeit.getItem(i).asTimeValue().getMillis());
						getStartZeit().add(atl);
					}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("StartZeitUnbekannt").isState()) {
							setStartZeitUnbekannt(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("StartZeitUnbekannt").getText()));
						} else {
						setStartZeitUnbekannt(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("StartZeitUnbekannt").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("StartetUmMitternacht").isState()) {
							setStartetUmMitternacht(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("StartetUmMitternacht").getText()));
						} else {
						setStartetUmMitternacht(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("StartetUmMitternacht").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("StartzeitUngefähr").isState()) {
							setStartzeitUngefaehr(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("StartzeitUngefähr").getText()));
						} else {
						setStartzeitUngefaehr(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("StartzeitUngefähr").
								byteValue
						()));
						}
				// ZeitstempelAttributTyp
					final Data.Array arrayEndZeit = daten.getArray("EndZeit");
					for (int i = 0; i < arrayEndZeit.getLength(); ++i) {
							Zeitstempel
						 atl = new 	Zeitstempel
						 (arrayEndZeit.getItem(i).asTimeValue().getMillis());
						getEndZeit().add(atl);
					}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("EndZeitUnbekannt").isState()) {
							setEndZeitUnbekannt(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("EndZeitUnbekannt").getText()));
						} else {
						setEndZeitUnbekannt(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("EndZeitUnbekannt").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("EndetUmMitternacht").isState()) {
							setEndetUmMitternacht(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("EndetUmMitternacht").getText()));
						} else {
						setEndetUmMitternacht(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("EndetUmMitternacht").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("EndzeitUngefähr").isState()) {
							setEndzeitUngefaehr(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("EndzeitUngefähr").getText()));
						} else {
						setEndzeitUngefaehr(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("EndzeitUngefähr").
								byteValue
						()));
						}
				// AttributListenDefinition
					final Data.Array arrayWiederholung = daten.getArray("Wiederholung");
					for (int i = 0; i < arrayWiederholung.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3RecurrenceType
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3RecurrenceType
						 ();
						atl.atl2Bean(arrayWiederholung.getItem(i), factory);
						getWiederholung().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTic3Zeitplan clone() {
		AtlTic3Zeitplan klon = new AtlTic3Zeitplan();
		
						klon.setBeschreibung(getBeschreibung());
					klon._startZeit = getStartZeit().clone();
						klon.setStartZeitUnbekannt(getStartZeitUnbekannt());
						klon.setStartetUmMitternacht(getStartetUmMitternacht());
						klon.setStartzeitUngefaehr(getStartzeitUngefaehr());
					klon._endZeit = getEndZeit().clone();
						klon.setEndZeitUnbekannt(getEndZeitUnbekannt());
						klon.setEndetUmMitternacht(getEndetUmMitternacht());
						klon.setEndzeitUngefaehr(getEndzeitUngefaehr());
					klon._wiederholung = getWiederholung().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
