/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Entspricht TIC3-Typ 'TrafficAndTravelEventCodeAndAttributeType'.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTic3tic3Event implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "")
			private String
			 _beschreibung
			= new String
			()
			;
			private String
			 _verkehrsUndReiseereigniscode
			= new String
			()
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3TrafficAndTravelEventAttributeType
			> _verkehrsUndReiseereignisAttribute = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3TrafficAndTravelEventAttributeType
			>(0, true);
	
		/**
		Beschreibung.
		<p>
		Wert des 'description'-Attributes TIC Info XML Element Tic3Event.
		</p>
		
		@return der Wert von Beschreibung.
		*/
			public String
			 getBeschreibung() {
			return _beschreibung;
		}
	
		/**
		Beschreibung.
		<p>
		Wert des 'description'-Attributes TIC Info XML Element Tic3Event.
		</p>
		
		@param _beschreibung der neue Wert von Beschreibung.
		*/
		public void setBeschreibung(String
		 _beschreibung) {
			if (_beschreibung.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._beschreibung = _beschreibung;
		}
	
		/**
		Verkehrs- und Reiseereigniscode.
		<p>
		TIC3 Info XML Element: TrafficAndTravelEventCode (TEC), A reference to "Traffic and Travel Event Code".
		</p>
		
		@return der Wert von VerkehrsUndReiseereigniscode.
		*/
			public String
			 getVerkehrsUndReiseereigniscode() {
			return _verkehrsUndReiseereigniscode;
		}
	
		/**
		Verkehrs- und Reiseereigniscode.
		<p>
		TIC3 Info XML Element: TrafficAndTravelEventCode (TEC), A reference to "Traffic and Travel Event Code".
		</p>
		
		@param _verkehrsUndReiseereigniscode der neue Wert von VerkehrsUndReiseereigniscode.
		*/
		public void setVerkehrsUndReiseereigniscode(String
		 _verkehrsUndReiseereigniscode) {
			if (_verkehrsUndReiseereigniscode.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._verkehrsUndReiseereigniscode = _verkehrsUndReiseereigniscode;
		}
	
		/**
		Event-Attribute.
		<p>
		TIC3 Info XML Element: TrafficAndTravelEventAttribute (TEA), A list of traffic and travel event attributes corresponding to the traffic and travel event code.
		</p>
		
		@return der Wert von VerkehrsUndReiseereignisAttribute.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3TrafficAndTravelEventAttributeType
			> getVerkehrsUndReiseereignisAttribute() {
			return _verkehrsUndReiseereignisAttribute;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getBeschreibung() != null) {
					datum.getTextValue("Beschreibung").setText(getBeschreibung());
				}
				// ZeichenkettenAttributTyp
				if (getVerkehrsUndReiseereigniscode() != null) {
					datum.getTextValue("VerkehrsUndReiseereigniscode").setText(getVerkehrsUndReiseereigniscode());
				}
				// AttributListenDefinition
					final Data.Array arrayVerkehrsUndReiseereignisAttribute = datum.getArray("VerkehrsUndReiseereignisAttribute");
					arrayVerkehrsUndReiseereignisAttribute.setLength(getVerkehrsUndReiseereignisAttribute().size());
					for (int i = 0; i < arrayVerkehrsUndReiseereignisAttribute.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3TrafficAndTravelEventAttributeType
						 atl = getVerkehrsUndReiseereignisAttribute().get(i);
						atl.bean2Atl(arrayVerkehrsUndReiseereignisAttribute.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setBeschreibung(daten.getTextValue("Beschreibung").getText());
				// ZeichenkettenAttributTyp
					setVerkehrsUndReiseereigniscode(daten.getTextValue("VerkehrsUndReiseereigniscode").getText());
				// AttributListenDefinition
					final Data.Array arrayVerkehrsUndReiseereignisAttribute = daten.getArray("VerkehrsUndReiseereignisAttribute");
					for (int i = 0; i < arrayVerkehrsUndReiseereignisAttribute.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3TrafficAndTravelEventAttributeType
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3TrafficAndTravelEventAttributeType
						 ();
						atl.atl2Bean(arrayVerkehrsUndReiseereignisAttribute.getItem(i), factory);
						getVerkehrsUndReiseereignisAttribute().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTic3tic3Event clone() {
		AtlTic3tic3Event klon = new AtlTic3tic3Event();
		
						klon.setBeschreibung(getBeschreibung());
						klon.setVerkehrsUndReiseereigniscode(getVerkehrsUndReiseereigniscode());
					klon._verkehrsUndReiseereignisAttribute = getVerkehrsUndReiseereignisAttribute().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
