/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
TIC3-Lokationsinformationen mit TIC3-Lokationen.
<p>
Entspricht TIC3 Typ 'Tic3LocationType' (aktuell ohne EdgeTyp).
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTic3tic3Location implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			@Defaultwert(wert = "")
			private String
			 _tIC3Netzkennung
			= new String
			()
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3NetworkArea
			> _tIC3Netzgebiet = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3NetworkArea
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3NetworkPointOfInterest
			> _tIC3NetworkPointOfInterest = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3NetworkPointOfInterest
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3KoordinatenLocation
			> _tIC3Shape = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3KoordinatenLocation
			>(0, true);
			private Feld<	Zeitstempel
			> _tIC3Netzerzeugungszeit = new Feld<	Zeitstempel
			>(1, true);
	
		/**
		TIC3 Netzkennung.
		<p>
		TIC Info XML Element: NetworkIdentifier (NID), The identifier of the network. The network version is specified by the combination of the network identifier and the network release date. A reference to "Network".
		</p>
		
		@return der Wert von TIC3Netzkennung.
		*/
			public String
			 getTIC3Netzkennung() {
			return _tIC3Netzkennung;
		}
	
		/**
		TIC3 Netzkennung.
		<p>
		TIC Info XML Element: NetworkIdentifier (NID), The identifier of the network. The network version is specified by the combination of the network identifier and the network release date. A reference to "Network".
		</p>
		
		@param _tIC3Netzkennung der neue Wert von TIC3Netzkennung.
		*/
		public void setTIC3Netzkennung(String
		 _tIC3Netzkennung) {
			if (_tIC3Netzkennung.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._tIC3Netzkennung = _tIC3Netzkennung;
		}
	
		/**
		TIC3 Netzgebiet.
		<p>
		TIC Info XML Element: NetworkArea (NAR), Information about an area such as the reference and description.
		</p>
		
		@return der Wert von TIC3Netzgebiet.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3NetworkArea
			> getTIC3Netzgebiet() {
			return _tIC3Netzgebiet;
		}
	
	
		/**
		TIC3 NetworkPointOfInterest.
		<p>
		TIC Info XML Element: NetworkPointOfInterest (POI), Information about a point of interest (POI) such as the reference and description.
		</p>
		
		@return der Wert von TIC3NetworkPointOfInterest.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3NetworkPointOfInterest
			> getTIC3NetworkPointOfInterest() {
			return _tIC3NetworkPointOfInterest;
		}
	
	
		/**
		TIC3 Liste von Umrissen.
		<p>
		TIC Info XML Element: Shape (SHP), A list of shapes.
		</p>
		
		@return der Wert von TIC3Shape.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3KoordinatenLocation
			> getTIC3Shape() {
			return _tIC3Shape;
		}
	
	
		/**
		TIC3 Netzerzeugungszeit.
		<p>
		TIC Info XML Element: NetworkCreateTime (NVR), The date and time when the network was created, used as the release date of the identified network. The network version is specified by the combination of the network identifier and the network release date.
		</p>
		
		@return der Wert von TIC3Netzerzeugungszeit.
		*/
			public Feld<	Zeitstempel
			> getTIC3Netzerzeugungszeit() {
			return _tIC3Netzerzeugungszeit;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getTIC3Netzkennung() != null) {
					datum.getTextValue("TIC3Netzkennung").setText(getTIC3Netzkennung());
				}
				// AttributListenDefinition
					final Data.Array arrayTIC3Netzgebiet = datum.getArray("TIC3Netzgebiet");
					arrayTIC3Netzgebiet.setLength(getTIC3Netzgebiet().size());
					for (int i = 0; i < arrayTIC3Netzgebiet.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3NetworkArea
						 atl = getTIC3Netzgebiet().get(i);
						atl.bean2Atl(arrayTIC3Netzgebiet.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayTIC3NetworkPointOfInterest = datum.getArray("TIC3NetworkPointOfInterest");
					arrayTIC3NetworkPointOfInterest.setLength(getTIC3NetworkPointOfInterest().size());
					for (int i = 0; i < arrayTIC3NetworkPointOfInterest.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3NetworkPointOfInterest
						 atl = getTIC3NetworkPointOfInterest().get(i);
						atl.bean2Atl(arrayTIC3NetworkPointOfInterest.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayTIC3Shape = datum.getArray("TIC3Shape");
					arrayTIC3Shape.setLength(getTIC3Shape().size());
					for (int i = 0; i < arrayTIC3Shape.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3KoordinatenLocation
						 atl = getTIC3Shape().get(i);
						atl.bean2Atl(arrayTIC3Shape.getItem(i), factory);
	
					}
				// ZeitstempelAttributTyp
					final Data.TimeArray arrayTIC3Netzerzeugungszeit = datum.getTimeArray("TIC3Netzerzeugungszeit");
					arrayTIC3Netzerzeugungszeit.setLength(getTIC3Netzerzeugungszeit().size());
					for (int i = 0; i < arrayTIC3Netzerzeugungszeit.getLength(); ++i) {
						arrayTIC3Netzerzeugungszeit.getTimeValue(i).setMillis(getTIC3Netzerzeugungszeit().get(i).getTime());
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setTIC3Netzkennung(daten.getTextValue("TIC3Netzkennung").getText());
				// AttributListenDefinition
					final Data.Array arrayTIC3Netzgebiet = daten.getArray("TIC3Netzgebiet");
					for (int i = 0; i < arrayTIC3Netzgebiet.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3NetworkArea
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3NetworkArea
						 ();
						atl.atl2Bean(arrayTIC3Netzgebiet.getItem(i), factory);
						getTIC3Netzgebiet().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayTIC3NetworkPointOfInterest = daten.getArray("TIC3NetworkPointOfInterest");
					for (int i = 0; i < arrayTIC3NetworkPointOfInterest.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3NetworkPointOfInterest
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3NetworkPointOfInterest
						 ();
						atl.atl2Bean(arrayTIC3NetworkPointOfInterest.getItem(i), factory);
						getTIC3NetworkPointOfInterest().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayTIC3Shape = daten.getArray("TIC3Shape");
					for (int i = 0; i < arrayTIC3Shape.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3KoordinatenLocation
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3KoordinatenLocation
						 ();
						atl.atl2Bean(arrayTIC3Shape.getItem(i), factory);
						getTIC3Shape().add(atl);
					}
				// ZeitstempelAttributTyp
					final Data.Array arrayTIC3Netzerzeugungszeit = daten.getArray("TIC3Netzerzeugungszeit");
					for (int i = 0; i < arrayTIC3Netzerzeugungszeit.getLength(); ++i) {
							Zeitstempel
						 atl = new 	Zeitstempel
						 (arrayTIC3Netzerzeugungszeit.getItem(i).asTimeValue().getMillis());
						getTIC3Netzerzeugungszeit().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTic3tic3Location clone() {
		AtlTic3tic3Location klon = new AtlTic3tic3Location();
		
						klon.setTIC3Netzkennung(getTIC3Netzkennung());
					klon._tIC3Netzgebiet = getTIC3Netzgebiet().clone();
					klon._tIC3NetworkPointOfInterest = getTIC3NetworkPointOfInterest().clone();
					klon._tIC3Shape = getTIC3Shape().clone();
					klon._tIC3Netzerzeugungszeit = getTIC3Netzerzeugungszeit().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
