/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Entspricht TIC3-Typ 'TmcEventAndQuantifierType'.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class AtlTic3tmcEvent implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _code
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTmcEventCodeTypeEnum
			 _type
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			> _updateClass = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tmcQuantifier
			> _quantifier = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tmcQuantifier
			>(0, true);
	
		/**
		TMC-Code.
		<p>
		TIC3 Info XML Element: Code (COD), The TMC event or supplementary information code.
		</p>
		
		@return der Wert von Code.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getCode() {
			return _code;
		}
	
		/**
		TMC-Code.
		<p>
		TIC3 Info XML Element: Code (COD), The TMC event or supplementary information code.
		</p>
		
		@param _code der neue Wert von Code.
		*/
		public void setCode(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _code) {
			this._code = _code;
		}
	
		/**
		TMC-Eventcode Typ.
		<p>
		TIC3 Info XML Element: Type (TYP), The type of TMC event code such as "Event code" or "Supplementary information code".
		</p>
		
		@return der Wert von Type.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTmcEventCodeTypeEnum
			 getType() {
			return _type;
		}
	
		/**
		TMC-Eventcode Typ.
		<p>
		TIC3 Info XML Element: Type (TYP), The type of TMC event code such as "Event code" or "Supplementary information code".
		</p>
		
		@param _type der neue Wert von Type.
		*/
		public void setType(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTmcEventCodeTypeEnum
		 _type) {
			this._type = _type;
		}
	
		/**
		Update-Klasse.
		<p>
		TIC3 Info XML Element: UpdateClass (UCL), The update class to which the TMC event code belongs.
		</p>
		
		@return der Wert von UpdateClass.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			> getUpdateClass() {
			return _updateClass;
		}
	
	
		/**
		Quantifizierer.
		<p>
		TIC3 Info XML Element: Quantifier (QUA), A list of additional quantifiers used in combination with the TMC event code.
		</p>
		
		@return der Wert von Quantifier.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tmcQuantifier
			> getQuantifier() {
			return _quantifier;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getCode() != null) {
	                if (getCode().isZustand()) {
	                    datum.getUnscaledValue("Code").setText(getCode().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Code").set(getCode().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getType() != null) {
	                if (getType().isZustand()) {
	                    datum.getUnscaledValue("Type").setText(getType().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Type").set(getType().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getUpdateClass() != null) {
					final Data.NumberArray arrayUpdateClass = datum.
						getUnscaledArray
						("UpdateClass");
					arrayUpdateClass.setLength(getUpdateClass().size());
					for (int i = 0; i < arrayUpdateClass.getLength(); ++i) {
						arrayUpdateClass.getValue(i).set(getUpdateClass().get(i).getValue());
					}
				}
				// AttributListenDefinition
					final Data.Array arrayQuantifier = datum.getArray("Quantifier");
					arrayQuantifier.setLength(getQuantifier().size());
					for (int i = 0; i < arrayQuantifier.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tmcQuantifier
						 atl = getQuantifier().get(i);
						atl.bean2Atl(arrayQuantifier.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setCode(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("Code").
								longValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Type").isState()) {
							setType(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTmcEventCodeTypeEnum
							.getZustand(daten.getScaledValue("Type").getText()));
						} else {
						setType(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTmcEventCodeTypeEnum
						(daten.
							getUnscaledValue
						("Type").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
					final Data.NumberArray arrayUpdateClass = daten.
						getUnscaledArray
					("UpdateClass");
	
					for (int i = 0; i < arrayUpdateClass.getLength(); ++i) {
	                    getUpdateClass().add(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
	                    (arrayUpdateClass.
	                    		longValue
	                    (i)));
	                }
				// AttributListenDefinition
					final Data.Array arrayQuantifier = daten.getArray("Quantifier");
					for (int i = 0; i < arrayQuantifier.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tmcQuantifier
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3tmcQuantifier
						 ();
						atl.atl2Bean(arrayQuantifier.getItem(i), factory);
						getQuantifier().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTic3tmcEvent clone() {
		AtlTic3tmcEvent klon = new AtlTic3tmcEvent();
		
						klon.setCode(getCode());
						klon.setType(getType());
					klon._updateClass = getUpdateClass().clone();
					klon._quantifier = getQuantifier().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
