/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
TIC3-Lokationsinformationen mit TMC-Lokationen.
<p>
Entspricht TIC3 Info Typ 'TmcLocationType'.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTic3tmcLocation implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3LocationTabelleInfo
			 _locationTabelleInfo
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3LocationTabelleInfo
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3TMCRichtung
			 _tMCRichtung
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _ausmass
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _primaerLokation
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _sekundaerLokation
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
			 _primaerEntfernung
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
			 _sekundaerEntfernung
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _primaerLokationIstEinAusfahrt
			;
			@Defaultwert(wert = "NichtVersorgt")
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
			 _laenge
			;
	
		/**
		Informationen zur Location-Tabelle.
		<p>
		Enhält alle Informationen zur benutzten Location-Tabelle.
		</p>
		
		@return der Wert von LocationTabelleInfo.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3LocationTabelleInfo
			 getLocationTabelleInfo() {
			return _locationTabelleInfo;
		}
	
		/**
		Informationen zur Location-Tabelle.
		<p>
		Enhält alle Informationen zur benutzten Location-Tabelle.
		</p>
		
		@param _locationTabelleInfo der neue Wert von LocationTabelleInfo.
		*/
		public void setLocationTabelleInfo(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3LocationTabelleInfo
		 _locationTabelleInfo) {
			this._locationTabelleInfo = _locationTabelleInfo;
		}
	
		/**
		TMC-Richtung.
		<p>
		TIC Info XML Element: Direction (DIR), The direction indicates the TMC direction of queue growth. It can be either 0 (positive) or 1 (negative).
		</p>
		
		@return der Wert von TMCRichtung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3TMCRichtung
			 getTMCRichtung() {
			return _tMCRichtung;
		}
	
		/**
		TMC-Richtung.
		<p>
		TIC Info XML Element: Direction (DIR), The direction indicates the TMC direction of queue growth. It can be either 0 (positive) or 1 (negative).
		</p>
		
		@param _tMCRichtung der neue Wert von TMCRichtung.
		*/
		public void setTMCRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3TMCRichtung
		 _tMCRichtung) {
			this._tMCRichtung = _tMCRichtung;
		}
	
		/**
		Ausmaß.
		<p>
		TIC Info XML Element: Extent (EXT), The extent as a number of steps through adjacent defined TMC locations from the "Primary location" to the "Secondary location"
		</p>
		
		@return der Wert von Ausmass.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getAusmass() {
			return _ausmass;
		}
	
		/**
		Ausmaß.
		<p>
		TIC Info XML Element: Extent (EXT), The extent as a number of steps through adjacent defined TMC locations from the "Primary location" to the "Secondary location"
		</p>
		
		@param _ausmass der neue Wert von Ausmass.
		*/
		public void setAusmass(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _ausmass) {
			this._ausmass = _ausmass;
		}
	
		/**
		Primäre Location.
		<p>
		TIC Info XML Element: PrimaryLocation (PRI), The TMC location code of the primary location.
		</p>
		
		@return der Wert von PrimaerLokation.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getPrimaerLokation() {
			return _primaerLokation;
		}
	
		/**
		Primäre Location.
		<p>
		TIC Info XML Element: PrimaryLocation (PRI), The TMC location code of the primary location.
		</p>
		
		@param _primaerLokation der neue Wert von PrimaerLokation.
		*/
		public void setPrimaerLokation(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _primaerLokation) {
			this._primaerLokation = _primaerLokation;
		}
	
		/**
		Sekundäre Location.
		<p>
		TIC Info XML Element: SecondaryLocation (SEC), The TMC location code of the secondary location.
		</p>
		
		@return der Wert von SekundaerLokation.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getSekundaerLokation() {
			return _sekundaerLokation;
		}
	
		/**
		Sekundäre Location.
		<p>
		TIC Info XML Element: SecondaryLocation (SEC), The TMC location code of the secondary location.
		</p>
		
		@param _sekundaerLokation der neue Wert von SekundaerLokation.
		*/
		public void setSekundaerLokation(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _sekundaerLokation) {
			this._sekundaerLokation = _sekundaerLokation;
		}
	
		/**
		Entfernung zur primären Location.
		<p>
		TIC Info XML Element: DistancePrimaryLocation (DPR), The distance between the end of the incident and the primary location.
		</p>
		
		@return der Wert von PrimaerEntfernung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
			 getPrimaerEntfernung() {
			return _primaerEntfernung;
		}
	
		/**
		Entfernung zur primären Location.
		<p>
		TIC Info XML Element: DistancePrimaryLocation (DPR), The distance between the end of the incident and the primary location.
		</p>
		
		@param _primaerEntfernung der neue Wert von PrimaerEntfernung.
		*/
		public void setPrimaerEntfernung(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
		 _primaerEntfernung) {
			this._primaerEntfernung = _primaerEntfernung;
		}
	
		/**
		Entfernung zur sekundären Location.
		<p>
		TIC Info XML Element: DistanceSecondaryLocation (DSE), The distance between the secondary location and the begin of the incident.
		</p>
		
		@return der Wert von SekundaerEntfernung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
			 getSekundaerEntfernung() {
			return _sekundaerEntfernung;
		}
	
		/**
		Entfernung zur sekundären Location.
		<p>
		TIC Info XML Element: DistanceSecondaryLocation (DSE), The distance between the secondary location and the begin of the incident.
		</p>
		
		@param _sekundaerEntfernung der neue Wert von SekundaerEntfernung.
		*/
		public void setSekundaerEntfernung(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
		 _sekundaerEntfernung) {
			this._sekundaerEntfernung = _sekundaerEntfernung;
		}
	
		/**
		Primärer Locationcode ist Ein- und Ausfahrt zugewiesen.
		<p>
		TIC Info XML Element: PrimaryLocationCodeIsUsedForEntranceOrExit (LEE), Specifies whether or not the primary TMC location code is assigned to one or more ramps which enter or exit the road.
		</p>
		
		@return der Wert von PrimaerLokationIstEinAusfahrt.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getPrimaerLokationIstEinAusfahrt() {
			return _primaerLokationIstEinAusfahrt;
		}
	
		/**
		Primärer Locationcode ist Ein- und Ausfahrt zugewiesen.
		<p>
		TIC Info XML Element: PrimaryLocationCodeIsUsedForEntranceOrExit (LEE), Specifies whether or not the primary TMC location code is assigned to one or more ramps which enter or exit the road.
		</p>
		
		@param _primaerLokationIstEinAusfahrt der neue Wert von PrimaerLokationIstEinAusfahrt.
		*/
		public void setPrimaerLokationIstEinAusfahrt(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _primaerLokationIstEinAusfahrt) {
			this._primaerLokationIstEinAusfahrt = _primaerLokationIstEinAusfahrt;
		}
	
		/**
		Länge.
		<p>
		TIC Info XML Element: LocationLength (LEN), The distance between the begin and the end of the incident.
		</p>
		
		@return der Wert von Laenge.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
			 getLaenge() {
			return _laenge;
		}
	
		/**
		Länge.
		<p>
		TIC Info XML Element: LocationLength (LEN), The distance between the begin and the end of the incident.
		</p>
		
		@param _laenge der neue Wert von Laenge.
		*/
		public void setLaenge(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
		 _laenge) {
			this._laenge = _laenge;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// AttributListenDefinition
					getLocationTabelleInfo().bean2Atl(datum.getItem("LocationTabelleInfo"), factory);
				// GanzzahlAttributTyp
				if (getTMCRichtung() != null) {
	                if (getTMCRichtung().isZustand()) {
	                    datum.getUnscaledValue("TMCRichtung").setText(getTMCRichtung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("TMCRichtung").set(getTMCRichtung().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getAusmass() != null) {
	                if (getAusmass().isZustand()) {
	                    datum.getUnscaledValue("Ausmass").setText(getAusmass().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Ausmass").set(getAusmass().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getPrimaerLokation() != null) {
	                if (getPrimaerLokation().isZustand()) {
	                    datum.getUnscaledValue("PrimaerLokation").setText(getPrimaerLokation().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("PrimaerLokation").set(getPrimaerLokation().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getSekundaerLokation() != null) {
	                if (getSekundaerLokation().isZustand()) {
	                    datum.getUnscaledValue("SekundaerLokation").setText(getSekundaerLokation().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("SekundaerLokation").set(getSekundaerLokation().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getPrimaerEntfernung() != null) {
	                if (getPrimaerEntfernung().isZustand()) {
	                    datum.getUnscaledValue("PrimaerEntfernung").setText(getPrimaerEntfernung().toString());
	                } else {
						datum.
						getScaledValue
	                	("PrimaerEntfernung").set(getPrimaerEntfernung().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getSekundaerEntfernung() != null) {
	                if (getSekundaerEntfernung().isZustand()) {
	                    datum.getUnscaledValue("SekundaerEntfernung").setText(getSekundaerEntfernung().toString());
	                } else {
						datum.
						getScaledValue
	                	("SekundaerEntfernung").set(getSekundaerEntfernung().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getPrimaerLokationIstEinAusfahrt() != null) {
	                if (getPrimaerLokationIstEinAusfahrt().isZustand()) {
	                    datum.getUnscaledValue("PrimaerLokationIstEinAusfahrt").setText(getPrimaerLokationIstEinAusfahrt().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("PrimaerLokationIstEinAusfahrt").set(getPrimaerLokationIstEinAusfahrt().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getLaenge() != null) {
	                if (getLaenge().isZustand()) {
	                    datum.getUnscaledValue("Laenge").setText(getLaenge().toString());
	                } else {
						datum.
						getScaledValue
	                	("Laenge").set(getLaenge().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// AttributListenDefinition
					getLocationTabelleInfo().atl2Bean(daten.getItem("LocationTabelleInfo"), factory);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("TMCRichtung").isState()) {
							setTMCRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3TMCRichtung
							.getZustand(daten.getScaledValue("TMCRichtung").getText()));
						} else {
						setTMCRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3TMCRichtung
						(daten.
							getUnscaledValue
						("TMCRichtung").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						setAusmass(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("Ausmass").
								longValue
						()));
				// GanzzahlAttributTyp
						setPrimaerLokation(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("PrimaerLokation").
								longValue
						()));
				// GanzzahlAttributTyp
						setSekundaerLokation(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("SekundaerLokation").
								longValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("PrimaerEntfernung").isState()) {
							setPrimaerEntfernung(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
							.getZustand(daten.getScaledValue("PrimaerEntfernung").getText()));
						} else {
						setPrimaerEntfernung(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
						(daten.
							getScaledValue
						("PrimaerEntfernung").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("SekundaerEntfernung").isState()) {
							setSekundaerEntfernung(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
							.getZustand(daten.getScaledValue("SekundaerEntfernung").getText()));
						} else {
						setSekundaerEntfernung(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
						(daten.
							getScaledValue
						("SekundaerEntfernung").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("PrimaerLokationIstEinAusfahrt").isState()) {
							setPrimaerLokationIstEinAusfahrt(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("PrimaerLokationIstEinAusfahrt").getText()));
						} else {
						setPrimaerLokationIstEinAusfahrt(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("PrimaerLokationIstEinAusfahrt").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Laenge").isState()) {
							setLaenge(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
							.getZustand(daten.getScaledValue("Laenge").getText()));
						} else {
						setLaenge(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3OptionalerDoubleWert
						(daten.
							getScaledValue
						("Laenge").
							doubleValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTic3tmcLocation clone() {
		AtlTic3tmcLocation klon = new AtlTic3tmcLocation();
		
						klon._locationTabelleInfo = getLocationTabelleInfo().clone();
						klon.setTMCRichtung(getTMCRichtung());
						klon.setAusmass(getAusmass());
						klon.setPrimaerLokation(getPrimaerLokation());
						klon.setSekundaerLokation(getSekundaerLokation());
						klon.setPrimaerEntfernung(getPrimaerEntfernung());
						klon.setSekundaerEntfernung(getSekundaerEntfernung());
						klon.setPrimaerLokationIstEinAusfahrt(getPrimaerLokationIstEinAusfahrt());
						klon.setLaenge(getLaenge());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
