/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
TIC3 CompassDirectionEnum.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttTic3HimmelsRichtung extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttTic3HimmelsRichtung ZUSTAND_1N_NICHTVERSORGT = new AttTic3HimmelsRichtung("NichtVersorgt", 		Byte
	.valueOf("-1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTic3HimmelsRichtung ZUSTAND_1_NORD = new AttTic3HimmelsRichtung("Nord", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTic3HimmelsRichtung ZUSTAND_2_SUED = new AttTic3HimmelsRichtung("Süd", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTic3HimmelsRichtung ZUSTAND_3_OST = new AttTic3HimmelsRichtung("Ost", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTic3HimmelsRichtung ZUSTAND_4_WEST = new AttTic3HimmelsRichtung("West", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTic3HimmelsRichtung ZUSTAND_5_NORDWEST = new AttTic3HimmelsRichtung("Nordwest", 		Byte
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTic3HimmelsRichtung ZUSTAND_6_NORDOST = new AttTic3HimmelsRichtung("Nordost", 		Byte
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTic3HimmelsRichtung ZUSTAND_7_SUEDWEST = new AttTic3HimmelsRichtung("Südwest", 		Byte
	.valueOf("7"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTic3HimmelsRichtung ZUSTAND_8_SUEDOST = new AttTic3HimmelsRichtung("Südost", 		Byte
	.valueOf("8"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTic3HimmelsRichtung getZustand(final 		Byte
	 value) {
		for (AttTic3HimmelsRichtung e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTic3HimmelsRichtung getZustand(final String value) {
		for (AttTic3HimmelsRichtung e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTic3HimmelsRichtung> getZustaende() {
		List<AttTic3HimmelsRichtung> list = new ArrayList<AttTic3HimmelsRichtung>();
		list.add(ZUSTAND_1N_NICHTVERSORGT);
		list.add(ZUSTAND_1_NORD);
		list.add(ZUSTAND_2_SUED);
		list.add(ZUSTAND_3_OST);
		list.add(ZUSTAND_4_WEST);
		list.add(ZUSTAND_5_NORDWEST);
		list.add(ZUSTAND_6_NORDOST);
		list.add(ZUSTAND_7_SUEDWEST);
		list.add(ZUSTAND_8_SUEDOST);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TIC3Himmelsrichtung.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTic3HimmelsRichtung(final 		Byte
	 value) {
		super(value);
	}
	
	private AttTic3HimmelsRichtung(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
