/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
TIC3-Meldung im systeminternen Format.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class OdTmcTic3infoMeldung extends AbstractOnlineDatensatz<OdTmcTic3infoMeldung.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.LmsEmpfangen,
				};
			}
	
			/**
			 * Empfangene Meldung.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt LmsEmpfangen = new Aspekte("LMSEmpfangen", "asp.lmsEmpfangen");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _tIC3TicId
				= new String
				()
				;
				@Defaultwert(wert = "")
				private String
				 _tIC3Datenproduzent
				= new String
				()
				;
				@Defaultwert(wert = "")
				private String
				 _tIC3Datenkennung
				= new String
				()
				;
				private String
				 _tIC3Beschreibung
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Location
				 _tIC3Location
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Location
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Event
				 _tIC3Ereignis
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Event
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Zeitplan
				> _tIC3Dauer = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Zeitplan
				>(1, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Umleitung
				> _tIC3Umleitungen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Umleitung
				>(0, true);
				@Defaultwert(wert = "")
				private String
				 _tIC3NichtKodierbareInformation
				= new String
				()
				;
				@Defaultwert(wert = "NichtVersorgt")
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3Prioritaet
				 _tIC3Prioritaet
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Location
				 _tIC3LocationGegenrichtung
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Location
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Quelle
				> _tIC3Quellen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Quelle
				>(0, true);
				@Defaultwert(wert = "")
				private String
				 _tIC3Name
				= new String
				()
				;
				@Defaultwert(wert = "")
				private String
				 _tIC3ErzeugtDurchProzess
				= new String
				()
				;
				private Feld<	Zeitstempel
				> _tIC3Datenerzeugungszeit = new Feld<	Zeitstempel
				>(1, true);
				private Feld<	Zeitstempel
				> _tIC3Datenersterzeugungszeit = new Feld<	Zeitstempel
				>(1, true);
				@Defaultwert(wert = "")
				private String
				 _tIC3ZeitZone
				= new String
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Location
				> _tIC3KreuzungsLokationen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Location
				>(0, true);
				@Defaultwert(wert = "Ja")
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _tIC3KeineWeiterenAktualisierungen
				;
				private Feld<	Zeitstempel
				> _tIC3Objektversionserzeugungszeit = new Feld<	Zeitstempel
				>(1, true);
				private Feld<	Zeitstempel
				> _tIC3Objektversionsendeszeit = new Feld<	Zeitstempel
				>(1, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3Status
				 _tIC3Status
				;
				private Feld<	Zeitstempel
				> _tIC3Speicherzeit = new Feld<	Zeitstempel
				>(1, true);
				@Defaultwert(wert = "")
				private String
				 _tIC3ErzeugtDurchBenutzer
				= new String
				()
				;
				@Defaultwert(wert = "")
				private String
				 _tIC3ErzeugtDurchTeam
				= new String
				()
				;
				@Defaultwert(wert = "")
				private String
				 _tIC3ErzeugtDurchTICServerKomponente
				= new String
				()
				;
				@Defaultwert(wert = "")
				private String
				 _tIC3ErzeugtDurchSystem
				= new String
				()
				;
		
			/**
			Identifikator.
			<p>
			TIC3 Info XML Element: TicId (TID), Globaler eindeutiger Identifikator der Information.
			</p>
			
			@return der Wert von TIC3TicId.
			*/
				public String
				 getTIC3TicId() {
				return _tIC3TicId;
			}
		
			/**
			Identifikator.
			<p>
			TIC3 Info XML Element: TicId (TID), Globaler eindeutiger Identifikator der Information.
			</p>
			
			@param _tIC3TicId der neue Wert von TIC3TicId.
			*/
			public void setTIC3TicId(String
			 _tIC3TicId) {
				if (_tIC3TicId.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._tIC3TicId = _tIC3TicId;
			}
		
			/**
			Datenerzeugende Organisation.
			<p>
			TIC3 Info XML Element: DataProducer (DPR), Organisation, welche die Daten erzeugt hat.
			</p>
			
			@return der Wert von TIC3Datenproduzent.
			*/
				public String
				 getTIC3Datenproduzent() {
				return _tIC3Datenproduzent;
			}
		
			/**
			Datenerzeugende Organisation.
			<p>
			TIC3 Info XML Element: DataProducer (DPR), Organisation, welche die Daten erzeugt hat.
			</p>
			
			@param _tIC3Datenproduzent der neue Wert von TIC3Datenproduzent.
			*/
			public void setTIC3Datenproduzent(String
			 _tIC3Datenproduzent) {
				if (_tIC3Datenproduzent.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._tIC3Datenproduzent = _tIC3Datenproduzent;
			}
		
			/**
			Identifikation.
			<p>
			TIC3 Info XML Element: DataIdentifier (DID), eindeutige Identifikation.
			</p>
			
			@return der Wert von TIC3Datenkennung.
			*/
				public String
				 getTIC3Datenkennung() {
				return _tIC3Datenkennung;
			}
		
			/**
			Identifikation.
			<p>
			TIC3 Info XML Element: DataIdentifier (DID), eindeutige Identifikation.
			</p>
			
			@param _tIC3Datenkennung der neue Wert von TIC3Datenkennung.
			*/
			public void setTIC3Datenkennung(String
			 _tIC3Datenkennung) {
				if (_tIC3Datenkennung.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._tIC3Datenkennung = _tIC3Datenkennung;
			}
		
			/**
			Beschreibung des Ereignisses.
			<p>
			TIC3 Info XML Element: Description (DES), Beschreibung des Ereignisses.
			</p>
			
			@return der Wert von TIC3Beschreibung.
			*/
				public String
				 getTIC3Beschreibung() {
				return _tIC3Beschreibung;
			}
		
			/**
			Beschreibung des Ereignisses.
			<p>
			TIC3 Info XML Element: Description (DES), Beschreibung des Ereignisses.
			</p>
			
			@param _tIC3Beschreibung der neue Wert von TIC3Beschreibung.
			*/
			public void setTIC3Beschreibung(String
			 _tIC3Beschreibung) {
				if (_tIC3Beschreibung.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._tIC3Beschreibung = _tIC3Beschreibung;
			}
		
			/**
			Lokationen.
			<p>
			TIC3 Info XML Element: Location (LOC), Information about a location specified by one or more location referencing methods such as TIC3 location, geographical position, or TMC location.
			</p>
			
			@return der Wert von TIC3Location.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Location
				 getTIC3Location() {
				return _tIC3Location;
			}
		
			/**
			Lokationen.
			<p>
			TIC3 Info XML Element: Location (LOC), Information about a location specified by one or more location referencing methods such as TIC3 location, geographical position, or TMC location.
			</p>
			
			@param _tIC3Location der neue Wert von TIC3Location.
			*/
			public void setTIC3Location(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Location
			 _tIC3Location) {
				this._tIC3Location = _tIC3Location;
			}
		
			/**
			Ereignisdaten.
			<p>
			TIC3 Info XML Element: Event (EVT), Event codes with additional information for different event coding methods, such as TIC3, TMC, or SAE RDS.
			</p>
			
			@return der Wert von TIC3Ereignis.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Event
				 getTIC3Ereignis() {
				return _tIC3Ereignis;
			}
		
			/**
			Ereignisdaten.
			<p>
			TIC3 Info XML Element: Event (EVT), Event codes with additional information for different event coding methods, such as TIC3, TMC, or SAE RDS.
			</p>
			
			@param _tIC3Ereignis der neue Wert von TIC3Ereignis.
			*/
			public void setTIC3Ereignis(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Event
			 _tIC3Ereignis) {
				this._tIC3Ereignis = _tIC3Ereignis;
			}
		
			/**
			Dauer.
			<p>
			TIC3 Info XML Element: Duration (DUR), A schedule specifying the duration of the traffic and travel event. The schedule is specified by the overall local begin and end times which can then be limited to recurring days and times. The time zone specified in element "Time zone" is used to convert between local and UTC times.
			</p>
			
			@return der Wert von TIC3Dauer.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Zeitplan
				> getTIC3Dauer() {
				return _tIC3Dauer;
			}
		
		
			/**
			Umleitungen.
			<p>
			TIC3 Info XML Element: DiversionRoute (DRO), A list of diversion routes and the vehicle types to which the diversion applies.
			</p>
			
			@return der Wert von TIC3Umleitungen.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Umleitung
				> getTIC3Umleitungen() {
				return _tIC3Umleitungen;
			}
		
		
			/**
			Nicht kodierbare Information.
			<p>
			TIC3 Info XML Element: AdditionalNonCodeableInformation (ANI), A culture-dependent free text providing additional information which cannot be coded in other data elements.
			</p>
			
			@return der Wert von TIC3NichtKodierbareInformation.
			*/
				public String
				 getTIC3NichtKodierbareInformation() {
				return _tIC3NichtKodierbareInformation;
			}
		
			/**
			Nicht kodierbare Information.
			<p>
			TIC3 Info XML Element: AdditionalNonCodeableInformation (ANI), A culture-dependent free text providing additional information which cannot be coded in other data elements.
			</p>
			
			@param _tIC3NichtKodierbareInformation der neue Wert von TIC3NichtKodierbareInformation.
			*/
			public void setTIC3NichtKodierbareInformation(String
			 _tIC3NichtKodierbareInformation) {
				if (_tIC3NichtKodierbareInformation.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._tIC3NichtKodierbareInformation = _tIC3NichtKodierbareInformation;
			}
		
			/**
			Priorität.
			<p>
			TIC3 Info XML Element: Urgency (URG), The urgency such as normal, urgent, or extremely urgent.
			</p>
			
			@return der Wert von TIC3Prioritaet.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3Prioritaet
				 getTIC3Prioritaet() {
				return _tIC3Prioritaet;
			}
		
			/**
			Priorität.
			<p>
			TIC3 Info XML Element: Urgency (URG), The urgency such as normal, urgent, or extremely urgent.
			</p>
			
			@param _tIC3Prioritaet der neue Wert von TIC3Prioritaet.
			*/
			public void setTIC3Prioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3Prioritaet
			 _tIC3Prioritaet) {
				this._tIC3Prioritaet = _tIC3Prioritaet;
			}
		
			/**
			Lokationsinformationen der Gegenrichtung.
			<p>
			TIC Info XML Element: OppositeDirectionLocation (OPP), When the condition or event is in both directions, information about the location which corresponds to the opposite direction of traffic, specified by one or more location referencing methods such as TIC3 location, geographical position, or TMC location.
			</p>
			
			@return der Wert von TIC3LocationGegenrichtung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Location
				 getTIC3LocationGegenrichtung() {
				return _tIC3LocationGegenrichtung;
			}
		
			/**
			Lokationsinformationen der Gegenrichtung.
			<p>
			TIC Info XML Element: OppositeDirectionLocation (OPP), When the condition or event is in both directions, information about the location which corresponds to the opposite direction of traffic, specified by one or more location referencing methods such as TIC3 location, geographical position, or TMC location.
			</p>
			
			@param _tIC3LocationGegenrichtung der neue Wert von TIC3LocationGegenrichtung.
			*/
			public void setTIC3LocationGegenrichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Location
			 _tIC3LocationGegenrichtung) {
				this._tIC3LocationGegenrichtung = _tIC3LocationGegenrichtung;
			}
		
			/**
			Quellen.
			<p>
			TIC3 Info XML Element: Source (SRC), A list of references to and information about the source data used to create the data contained in this object.
			</p>
			
			@return der Wert von TIC3Quellen.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Quelle
				> getTIC3Quellen() {
				return _tIC3Quellen;
			}
		
		
			/**
			Name.
			<p>
			TIC3 Info XML Element: Name (NAM), The name of the object, in one or more languages configured on the system.
			</p>
			
			@return der Wert von TIC3Name.
			*/
				public String
				 getTIC3Name() {
				return _tIC3Name;
			}
		
			/**
			Name.
			<p>
			TIC3 Info XML Element: Name (NAM), The name of the object, in one or more languages configured on the system.
			</p>
			
			@param _tIC3Name der neue Wert von TIC3Name.
			*/
			public void setTIC3Name(String
			 _tIC3Name) {
				if (_tIC3Name.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._tIC3Name = _tIC3Name;
			}
		
			/**
			Erzeugt durch Prozess.
			<p>
			TIC3 Info XML Element: CreatedByProcess (CBP), The manually create data process, specifying the process in which the data have been created. A reference to "ManuallyCreateDataProcess".
			</p>
			
			@return der Wert von TIC3ErzeugtDurchProzess.
			*/
				public String
				 getTIC3ErzeugtDurchProzess() {
				return _tIC3ErzeugtDurchProzess;
			}
		
			/**
			Erzeugt durch Prozess.
			<p>
			TIC3 Info XML Element: CreatedByProcess (CBP), The manually create data process, specifying the process in which the data have been created. A reference to "ManuallyCreateDataProcess".
			</p>
			
			@param _tIC3ErzeugtDurchProzess der neue Wert von TIC3ErzeugtDurchProzess.
			*/
			public void setTIC3ErzeugtDurchProzess(String
			 _tIC3ErzeugtDurchProzess) {
				if (_tIC3ErzeugtDurchProzess.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._tIC3ErzeugtDurchProzess = _tIC3ErzeugtDurchProzess;
			}
		
			/**
			TIC3 Datenerzeugungszeit.
			<p>
			TIC Info XML Element: CreateTime (CRT), The date and time when the data contained in this object version was created.
			</p>
			
			@return der Wert von TIC3Datenerzeugungszeit.
			*/
				public Feld<	Zeitstempel
				> getTIC3Datenerzeugungszeit() {
				return _tIC3Datenerzeugungszeit;
			}
		
		
			/**
			TIC3 Datenersterzeugungszeit.
			<p>
			TIC Info XML Element: FirstCreateTime (FCT), The date and time when the data contained in the first object version was created.
			</p>
			
			@return der Wert von TIC3Datenersterzeugungszeit.
			*/
				public Feld<	Zeitstempel
				> getTIC3Datenersterzeugungszeit() {
				return _tIC3Datenersterzeugungszeit;
			}
		
		
			/**
			Zeitzone.
			<p>
			TIC3 Info XML Element: TimeZone (TZO), The time zone as defined for Microsoft operating systems, described by a name and offset to Coordinated Universal Time (UTC), and used for time data which is provided in the local time and which has been adjusted to local Daylight Savings Time (DST).
			</p>
			
			@return der Wert von TIC3ZeitZone.
			*/
				public String
				 getTIC3ZeitZone() {
				return _tIC3ZeitZone;
			}
		
			/**
			Zeitzone.
			<p>
			TIC3 Info XML Element: TimeZone (TZO), The time zone as defined for Microsoft operating systems, described by a name and offset to Coordinated Universal Time (UTC), and used for time data which is provided in the local time and which has been adjusted to local Daylight Savings Time (DST).
			</p>
			
			@param _tIC3ZeitZone der neue Wert von TIC3ZeitZone.
			*/
			public void setTIC3ZeitZone(String
			 _tIC3ZeitZone) {
				if (_tIC3ZeitZone.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._tIC3ZeitZone = _tIC3ZeitZone;
			}
		
			/**
			Lokationsinformationen der kreuzenden Lokationen.
			<p>
			TIC Info XML Element: CrossLocation (CLO), One or more roads crossing the roads specified by the location, which are also affected by the event. Each item in the list contains information about a crossing road specified by one or more location referencing methods such as TIC3 location, geographical position, or TMC location.
			</p>
			
			@return der Wert von TIC3KreuzungsLokationen.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Location
				> getTIC3KreuzungsLokationen() {
				return _tIC3KreuzungsLokationen;
			}
		
		
			/**
			Keine weiteren Aktualisierungen.
			<p>
			TIC3 Info XML Element: NoFurtherUpdates (NUP), Specifies whether or not it is likely that no further identifiable	updates will be received.
			</p>
			
			@return der Wert von TIC3KeineWeiterenAktualisierungen.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getTIC3KeineWeiterenAktualisierungen() {
				return _tIC3KeineWeiterenAktualisierungen;
			}
		
			/**
			Keine weiteren Aktualisierungen.
			<p>
			TIC3 Info XML Element: NoFurtherUpdates (NUP), Specifies whether or not it is likely that no further identifiable	updates will be received.
			</p>
			
			@param _tIC3KeineWeiterenAktualisierungen der neue Wert von TIC3KeineWeiterenAktualisierungen.
			*/
			public void setTIC3KeineWeiterenAktualisierungen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _tIC3KeineWeiterenAktualisierungen) {
				this._tIC3KeineWeiterenAktualisierungen = _tIC3KeineWeiterenAktualisierungen;
			}
		
			/**
			TIC3 Objektversionserzeugungszeit.
			<p>
			TIC Info XML Element: ObjectVersionBeginTime (OVB), The date and time when this version of the object was created.
			</p>
			
			@return der Wert von TIC3Objektversionserzeugungszeit.
			*/
				public Feld<	Zeitstempel
				> getTIC3Objektversionserzeugungszeit() {
				return _tIC3Objektversionserzeugungszeit;
			}
		
		
			/**
			TIC3 Objektversionsendezeit.
			<p>
			TIC Info XML Element: ObjectVersionEndTime (OVE), The date and time when this version of the object ended. The end time is assigned when a new object version is created or the current version is deleted.
			</p>
			
			@return der Wert von TIC3Objektversionsendeszeit.
			*/
				public Feld<	Zeitstempel
				> getTIC3Objektversionsendeszeit() {
				return _tIC3Objektversionsendeszeit;
			}
		
		
			/**
			TIC3 Objektversionsstatus.
			<p>
			TIC Info XML Element: ObjectVersionStatus (OVS), The type of the object version, specifying whether the object is new, changed, or deleted.
			</p>
			
			@return der Wert von TIC3Status.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3Status
				 getTIC3Status() {
				return _tIC3Status;
			}
		
			/**
			TIC3 Objektversionsstatus.
			<p>
			TIC Info XML Element: ObjectVersionStatus (OVS), The type of the object version, specifying whether the object is new, changed, or deleted.
			</p>
			
			@param _tIC3Status der neue Wert von TIC3Status.
			*/
			public void setTIC3Status(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3Status
			 _tIC3Status) {
				this._tIC3Status = _tIC3Status;
			}
		
			/**
			TIC3 Speicherzeit.
			<p>
			TIC Info XML Element: StoreTime (STT), The date and time when this version of the data was stored.
			</p>
			
			@return der Wert von TIC3Speicherzeit.
			*/
				public Feld<	Zeitstempel
				> getTIC3Speicherzeit() {
				return _tIC3Speicherzeit;
			}
		
		
			/**
			Erzeugt durch Benutzer.
			<p>
			TIC3 Info XML Element: CreatedByUser (CBU), The user who created this version of the data. A reference to	"User".
			</p>
			
			@return der Wert von TIC3ErzeugtDurchBenutzer.
			*/
				public String
				 getTIC3ErzeugtDurchBenutzer() {
				return _tIC3ErzeugtDurchBenutzer;
			}
		
			/**
			Erzeugt durch Benutzer.
			<p>
			TIC3 Info XML Element: CreatedByUser (CBU), The user who created this version of the data. A reference to	"User".
			</p>
			
			@param _tIC3ErzeugtDurchBenutzer der neue Wert von TIC3ErzeugtDurchBenutzer.
			*/
			public void setTIC3ErzeugtDurchBenutzer(String
			 _tIC3ErzeugtDurchBenutzer) {
				if (_tIC3ErzeugtDurchBenutzer.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._tIC3ErzeugtDurchBenutzer = _tIC3ErzeugtDurchBenutzer;
			}
		
			/**
			Erzeugt durch Team.
			<p>
			TIC3 Info XML Element: CreatedByTeam (CBT), The team which created this version of the data. A reference to "Team".
			</p>
			
			@return der Wert von TIC3ErzeugtDurchTeam.
			*/
				public String
				 getTIC3ErzeugtDurchTeam() {
				return _tIC3ErzeugtDurchTeam;
			}
		
			/**
			Erzeugt durch Team.
			<p>
			TIC3 Info XML Element: CreatedByTeam (CBT), The team which created this version of the data. A reference to "Team".
			</p>
			
			@param _tIC3ErzeugtDurchTeam der neue Wert von TIC3ErzeugtDurchTeam.
			*/
			public void setTIC3ErzeugtDurchTeam(String
			 _tIC3ErzeugtDurchTeam) {
				if (_tIC3ErzeugtDurchTeam.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._tIC3ErzeugtDurchTeam = _tIC3ErzeugtDurchTeam;
			}
		
			/**
			Erzeugt durch TIC Server Komponente.
			<p>
			TIC3 Info XML Element: CreatedByComponent (CBC), The TIC Server component which created this version of the data. A reference to "Component".
			</p>
			
			@return der Wert von TIC3ErzeugtDurchTICServerKomponente.
			*/
				public String
				 getTIC3ErzeugtDurchTICServerKomponente() {
				return _tIC3ErzeugtDurchTICServerKomponente;
			}
		
			/**
			Erzeugt durch TIC Server Komponente.
			<p>
			TIC3 Info XML Element: CreatedByComponent (CBC), The TIC Server component which created this version of the data. A reference to "Component".
			</p>
			
			@param _tIC3ErzeugtDurchTICServerKomponente der neue Wert von TIC3ErzeugtDurchTICServerKomponente.
			*/
			public void setTIC3ErzeugtDurchTICServerKomponente(String
			 _tIC3ErzeugtDurchTICServerKomponente) {
				if (_tIC3ErzeugtDurchTICServerKomponente.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._tIC3ErzeugtDurchTICServerKomponente = _tIC3ErzeugtDurchTICServerKomponente;
			}
		
			/**
			Erzeugt durch System.
			<p>
			TIC3 Info XML Element: CreatedBySystem (CBS), The name of the system.
			</p>
			
			@return der Wert von TIC3ErzeugtDurchSystem.
			*/
				public String
				 getTIC3ErzeugtDurchSystem() {
				return _tIC3ErzeugtDurchSystem;
			}
		
			/**
			Erzeugt durch System.
			<p>
			TIC3 Info XML Element: CreatedBySystem (CBS), The name of the system.
			</p>
			
			@param _tIC3ErzeugtDurchSystem der neue Wert von TIC3ErzeugtDurchSystem.
			*/
			public void setTIC3ErzeugtDurchSystem(String
			 _tIC3ErzeugtDurchSystem) {
				if (_tIC3ErzeugtDurchSystem.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._tIC3ErzeugtDurchSystem = _tIC3ErzeugtDurchSystem;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getTIC3TicId() != null) {
						datum.getTextValue("TIC3TicId").setText(getTIC3TicId());
					}
					// ZeichenkettenAttributTyp
					if (getTIC3Datenproduzent() != null) {
						datum.getTextValue("TIC3Datenproduzent").setText(getTIC3Datenproduzent());
					}
					// ZeichenkettenAttributTyp
					if (getTIC3Datenkennung() != null) {
						datum.getTextValue("TIC3Datenkennung").setText(getTIC3Datenkennung());
					}
					// ZeichenkettenAttributTyp
					if (getTIC3Beschreibung() != null) {
						datum.getTextValue("TIC3Beschreibung").setText(getTIC3Beschreibung());
					}
					// AttributListenDefinition
						getTIC3Location().bean2Atl(datum.getItem("TIC3Location"), factory);
					// AttributListenDefinition
						getTIC3Ereignis().bean2Atl(datum.getItem("TIC3Ereignis"), factory);
					// AttributListenDefinition
						final Data.Array arrayTIC3Dauer = datum.getArray("TIC3Dauer");
						arrayTIC3Dauer.setLength(getTIC3Dauer().size());
						for (int i = 0; i < arrayTIC3Dauer.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Zeitplan
							 atl = getTIC3Dauer().get(i);
							atl.bean2Atl(arrayTIC3Dauer.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayTIC3Umleitungen = datum.getArray("TIC3Umleitungen");
						arrayTIC3Umleitungen.setLength(getTIC3Umleitungen().size());
						for (int i = 0; i < arrayTIC3Umleitungen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Umleitung
							 atl = getTIC3Umleitungen().get(i);
							atl.bean2Atl(arrayTIC3Umleitungen.getItem(i), factory);
		
						}
					// ZeichenkettenAttributTyp
					if (getTIC3NichtKodierbareInformation() != null) {
						datum.getTextValue("TIC3NichtKodierbareInformation").setText(getTIC3NichtKodierbareInformation());
					}
					// GanzzahlAttributTyp
					if (getTIC3Prioritaet() != null) {
		                if (getTIC3Prioritaet().isZustand()) {
		                    datum.getUnscaledValue("TIC3Prioritaet").setText(getTIC3Prioritaet().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("TIC3Prioritaet").set(getTIC3Prioritaet().getValue());
		                }
					}
					// AttributListenDefinition
						getTIC3LocationGegenrichtung().bean2Atl(datum.getItem("TIC3LocationGegenrichtung"), factory);
					// AttributListenDefinition
						final Data.Array arrayTIC3Quellen = datum.getArray("TIC3Quellen");
						arrayTIC3Quellen.setLength(getTIC3Quellen().size());
						for (int i = 0; i < arrayTIC3Quellen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Quelle
							 atl = getTIC3Quellen().get(i);
							atl.bean2Atl(arrayTIC3Quellen.getItem(i), factory);
		
						}
					// ZeichenkettenAttributTyp
					if (getTIC3Name() != null) {
						datum.getTextValue("TIC3Name").setText(getTIC3Name());
					}
					// ZeichenkettenAttributTyp
					if (getTIC3ErzeugtDurchProzess() != null) {
						datum.getTextValue("TIC3ErzeugtDurchProzess").setText(getTIC3ErzeugtDurchProzess());
					}
					// ZeitstempelAttributTyp
						final Data.TimeArray arrayTIC3Datenerzeugungszeit = datum.getTimeArray("TIC3Datenerzeugungszeit");
						arrayTIC3Datenerzeugungszeit.setLength(getTIC3Datenerzeugungszeit().size());
						for (int i = 0; i < arrayTIC3Datenerzeugungszeit.getLength(); ++i) {
							arrayTIC3Datenerzeugungszeit.getTimeValue(i).setMillis(getTIC3Datenerzeugungszeit().get(i).getTime());
						}
					// ZeitstempelAttributTyp
						final Data.TimeArray arrayTIC3Datenersterzeugungszeit = datum.getTimeArray("TIC3Datenersterzeugungszeit");
						arrayTIC3Datenersterzeugungszeit.setLength(getTIC3Datenersterzeugungszeit().size());
						for (int i = 0; i < arrayTIC3Datenersterzeugungszeit.getLength(); ++i) {
							arrayTIC3Datenersterzeugungszeit.getTimeValue(i).setMillis(getTIC3Datenersterzeugungszeit().get(i).getTime());
						}
					// ZeichenkettenAttributTyp
					if (getTIC3ZeitZone() != null) {
						datum.getTextValue("TIC3ZeitZone").setText(getTIC3ZeitZone());
					}
					// AttributListenDefinition
						final Data.Array arrayTIC3KreuzungsLokationen = datum.getArray("TIC3KreuzungsLokationen");
						arrayTIC3KreuzungsLokationen.setLength(getTIC3KreuzungsLokationen().size());
						for (int i = 0; i < arrayTIC3KreuzungsLokationen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Location
							 atl = getTIC3KreuzungsLokationen().get(i);
							atl.bean2Atl(arrayTIC3KreuzungsLokationen.getItem(i), factory);
		
						}
					// GanzzahlAttributTyp
					if (getTIC3KeineWeiterenAktualisierungen() != null) {
		                if (getTIC3KeineWeiterenAktualisierungen().isZustand()) {
		                    datum.getUnscaledValue("TIC3KeineWeiterenAktualisierungen").setText(getTIC3KeineWeiterenAktualisierungen().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("TIC3KeineWeiterenAktualisierungen").set(getTIC3KeineWeiterenAktualisierungen().getValue());
		                }
					}
					// ZeitstempelAttributTyp
						final Data.TimeArray arrayTIC3Objektversionserzeugungszeit = datum.getTimeArray("TIC3Objektversionserzeugungszeit");
						arrayTIC3Objektversionserzeugungszeit.setLength(getTIC3Objektversionserzeugungszeit().size());
						for (int i = 0; i < arrayTIC3Objektversionserzeugungszeit.getLength(); ++i) {
							arrayTIC3Objektversionserzeugungszeit.getTimeValue(i).setMillis(getTIC3Objektversionserzeugungszeit().get(i).getTime());
						}
					// ZeitstempelAttributTyp
						final Data.TimeArray arrayTIC3Objektversionsendeszeit = datum.getTimeArray("TIC3Objektversionsendeszeit");
						arrayTIC3Objektversionsendeszeit.setLength(getTIC3Objektversionsendeszeit().size());
						for (int i = 0; i < arrayTIC3Objektversionsendeszeit.getLength(); ++i) {
							arrayTIC3Objektversionsendeszeit.getTimeValue(i).setMillis(getTIC3Objektversionsendeszeit().get(i).getTime());
						}
					// GanzzahlAttributTyp
					if (getTIC3Status() != null) {
		                if (getTIC3Status().isZustand()) {
		                    datum.getUnscaledValue("TIC3Status").setText(getTIC3Status().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("TIC3Status").set(getTIC3Status().getValue());
		                }
					}
					// ZeitstempelAttributTyp
						final Data.TimeArray arrayTIC3Speicherzeit = datum.getTimeArray("TIC3Speicherzeit");
						arrayTIC3Speicherzeit.setLength(getTIC3Speicherzeit().size());
						for (int i = 0; i < arrayTIC3Speicherzeit.getLength(); ++i) {
							arrayTIC3Speicherzeit.getTimeValue(i).setMillis(getTIC3Speicherzeit().get(i).getTime());
						}
					// ZeichenkettenAttributTyp
					if (getTIC3ErzeugtDurchBenutzer() != null) {
						datum.getTextValue("TIC3ErzeugtDurchBenutzer").setText(getTIC3ErzeugtDurchBenutzer());
					}
					// ZeichenkettenAttributTyp
					if (getTIC3ErzeugtDurchTeam() != null) {
						datum.getTextValue("TIC3ErzeugtDurchTeam").setText(getTIC3ErzeugtDurchTeam());
					}
					// ZeichenkettenAttributTyp
					if (getTIC3ErzeugtDurchTICServerKomponente() != null) {
						datum.getTextValue("TIC3ErzeugtDurchTICServerKomponente").setText(getTIC3ErzeugtDurchTICServerKomponente());
					}
					// ZeichenkettenAttributTyp
					if (getTIC3ErzeugtDurchSystem() != null) {
						datum.getTextValue("TIC3ErzeugtDurchSystem").setText(getTIC3ErzeugtDurchSystem());
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setTIC3TicId(daten.getTextValue("TIC3TicId").getText());
					// ZeichenkettenAttributTyp
						setTIC3Datenproduzent(daten.getTextValue("TIC3Datenproduzent").getText());
					// ZeichenkettenAttributTyp
						setTIC3Datenkennung(daten.getTextValue("TIC3Datenkennung").getText());
					// ZeichenkettenAttributTyp
						setTIC3Beschreibung(daten.getTextValue("TIC3Beschreibung").getText());
					// AttributListenDefinition
						getTIC3Location().atl2Bean(daten.getItem("TIC3Location"), factory);
					// AttributListenDefinition
						getTIC3Ereignis().atl2Bean(daten.getItem("TIC3Ereignis"), factory);
					// AttributListenDefinition
						final Data.Array arrayTIC3Dauer = daten.getArray("TIC3Dauer");
						for (int i = 0; i < arrayTIC3Dauer.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Zeitplan
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Zeitplan
							 ();
							atl.atl2Bean(arrayTIC3Dauer.getItem(i), factory);
							getTIC3Dauer().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayTIC3Umleitungen = daten.getArray("TIC3Umleitungen");
						for (int i = 0; i < arrayTIC3Umleitungen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Umleitung
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Umleitung
							 ();
							atl.atl2Bean(arrayTIC3Umleitungen.getItem(i), factory);
							getTIC3Umleitungen().add(atl);
						}
					// ZeichenkettenAttributTyp
						setTIC3NichtKodierbareInformation(daten.getTextValue("TIC3NichtKodierbareInformation").getText());
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("TIC3Prioritaet").isState()) {
								setTIC3Prioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3Prioritaet
								.getZustand(daten.getScaledValue("TIC3Prioritaet").getText()));
							} else {
							setTIC3Prioritaet(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3Prioritaet
							(daten.
								getUnscaledValue
							("TIC3Prioritaet").
									byteValue
							()));
							}
					// AttributListenDefinition
						getTIC3LocationGegenrichtung().atl2Bean(daten.getItem("TIC3LocationGegenrichtung"), factory);
					// AttributListenDefinition
						final Data.Array arrayTIC3Quellen = daten.getArray("TIC3Quellen");
						for (int i = 0; i < arrayTIC3Quellen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Quelle
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Quelle
							 ();
							atl.atl2Bean(arrayTIC3Quellen.getItem(i), factory);
							getTIC3Quellen().add(atl);
						}
					// ZeichenkettenAttributTyp
						setTIC3Name(daten.getTextValue("TIC3Name").getText());
					// ZeichenkettenAttributTyp
						setTIC3ErzeugtDurchProzess(daten.getTextValue("TIC3ErzeugtDurchProzess").getText());
					// ZeitstempelAttributTyp
						final Data.Array arrayTIC3Datenerzeugungszeit = daten.getArray("TIC3Datenerzeugungszeit");
						for (int i = 0; i < arrayTIC3Datenerzeugungszeit.getLength(); ++i) {
								Zeitstempel
							 atl = new 	Zeitstempel
							 (arrayTIC3Datenerzeugungszeit.getItem(i).asTimeValue().getMillis());
							getTIC3Datenerzeugungszeit().add(atl);
						}
					// ZeitstempelAttributTyp
						final Data.Array arrayTIC3Datenersterzeugungszeit = daten.getArray("TIC3Datenersterzeugungszeit");
						for (int i = 0; i < arrayTIC3Datenersterzeugungszeit.getLength(); ++i) {
								Zeitstempel
							 atl = new 	Zeitstempel
							 (arrayTIC3Datenersterzeugungszeit.getItem(i).asTimeValue().getMillis());
							getTIC3Datenersterzeugungszeit().add(atl);
						}
					// ZeichenkettenAttributTyp
						setTIC3ZeitZone(daten.getTextValue("TIC3ZeitZone").getText());
					// AttributListenDefinition
						final Data.Array arrayTIC3KreuzungsLokationen = daten.getArray("TIC3KreuzungsLokationen");
						for (int i = 0; i < arrayTIC3KreuzungsLokationen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Location
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AtlTic3Location
							 ();
							atl.atl2Bean(arrayTIC3KreuzungsLokationen.getItem(i), factory);
							getTIC3KreuzungsLokationen().add(atl);
						}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("TIC3KeineWeiterenAktualisierungen").isState()) {
								setTIC3KeineWeiterenAktualisierungen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("TIC3KeineWeiterenAktualisierungen").getText()));
							} else {
							setTIC3KeineWeiterenAktualisierungen(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("TIC3KeineWeiterenAktualisierungen").
									byteValue
							()));
							}
					// ZeitstempelAttributTyp
						final Data.Array arrayTIC3Objektversionserzeugungszeit = daten.getArray("TIC3Objektversionserzeugungszeit");
						for (int i = 0; i < arrayTIC3Objektversionserzeugungszeit.getLength(); ++i) {
								Zeitstempel
							 atl = new 	Zeitstempel
							 (arrayTIC3Objektversionserzeugungszeit.getItem(i).asTimeValue().getMillis());
							getTIC3Objektversionserzeugungszeit().add(atl);
						}
					// ZeitstempelAttributTyp
						final Data.Array arrayTIC3Objektversionsendeszeit = daten.getArray("TIC3Objektversionsendeszeit");
						for (int i = 0; i < arrayTIC3Objektversionsendeszeit.getLength(); ++i) {
								Zeitstempel
							 atl = new 	Zeitstempel
							 (arrayTIC3Objektversionsendeszeit.getItem(i).asTimeValue().getMillis());
							getTIC3Objektversionsendeszeit().add(atl);
						}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("TIC3Status").isState()) {
								setTIC3Status(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3Status
								.getZustand(daten.getScaledValue("TIC3Status").getText()));
							} else {
							setTIC3Status(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttTic3Status
							(daten.
								getUnscaledValue
							("TIC3Status").
									byteValue
							()));
							}
					// ZeitstempelAttributTyp
						final Data.Array arrayTIC3Speicherzeit = daten.getArray("TIC3Speicherzeit");
						for (int i = 0; i < arrayTIC3Speicherzeit.getLength(); ++i) {
								Zeitstempel
							 atl = new 	Zeitstempel
							 (arrayTIC3Speicherzeit.getItem(i).asTimeValue().getMillis());
							getTIC3Speicherzeit().add(atl);
						}
					// ZeichenkettenAttributTyp
						setTIC3ErzeugtDurchBenutzer(daten.getTextValue("TIC3ErzeugtDurchBenutzer").getText());
					// ZeichenkettenAttributTyp
						setTIC3ErzeugtDurchTeam(daten.getTextValue("TIC3ErzeugtDurchTeam").getText());
					// ZeichenkettenAttributTyp
						setTIC3ErzeugtDurchTICServerKomponente(daten.getTextValue("TIC3ErzeugtDurchTICServerKomponente").getText());
					// ZeichenkettenAttributTyp
						setTIC3ErzeugtDurchSystem(daten.getTextValue("TIC3ErzeugtDurchSystem").getText());
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setTIC3TicId(getTIC3TicId());
							klon.setTIC3Datenproduzent(getTIC3Datenproduzent());
							klon.setTIC3Datenkennung(getTIC3Datenkennung());
							klon.setTIC3Beschreibung(getTIC3Beschreibung());
							klon._tIC3Location = getTIC3Location().clone();
							klon._tIC3Ereignis = getTIC3Ereignis().clone();
						klon._tIC3Dauer = getTIC3Dauer().clone();
						klon._tIC3Umleitungen = getTIC3Umleitungen().clone();
							klon.setTIC3NichtKodierbareInformation(getTIC3NichtKodierbareInformation());
							klon.setTIC3Prioritaet(getTIC3Prioritaet());
							klon._tIC3LocationGegenrichtung = getTIC3LocationGegenrichtung().clone();
						klon._tIC3Quellen = getTIC3Quellen().clone();
							klon.setTIC3Name(getTIC3Name());
							klon.setTIC3ErzeugtDurchProzess(getTIC3ErzeugtDurchProzess());
						klon._tIC3Datenerzeugungszeit = getTIC3Datenerzeugungszeit().clone();
						klon._tIC3Datenersterzeugungszeit = getTIC3Datenersterzeugungszeit().clone();
							klon.setTIC3ZeitZone(getTIC3ZeitZone());
						klon._tIC3KreuzungsLokationen = getTIC3KreuzungsLokationen().clone();
							klon.setTIC3KeineWeiterenAktualisierungen(getTIC3KeineWeiterenAktualisierungen());
						klon._tIC3Objektversionserzeugungszeit = getTIC3Objektversionserzeugungszeit().clone();
						klon._tIC3Objektversionsendeszeit = getTIC3Objektversionsendeszeit().clone();
							klon.setTIC3Status(getTIC3Status());
						klon._tIC3Speicherzeit = getTIC3Speicherzeit().clone();
							klon.setTIC3ErzeugtDurchBenutzer(getTIC3ErzeugtDurchBenutzer());
							klon.setTIC3ErzeugtDurchTeam(getTIC3ErzeugtDurchTeam());
							klon.setTIC3ErzeugtDurchTICServerKomponente(getTIC3ErzeugtDurchTICServerKomponente());
							klon.setTIC3ErzeugtDurchSystem(getTIC3ErzeugtDurchSystem());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tmcTic3infoMeldung";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTmcTic3infoMeldung(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
