/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Kommunikationsparameter zur Kommunikation mit der
					Landesmeldestelle.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class PdLmsKommunikationsParameter extends AbstractParameterDatensatz<PdLmsKommunikationsParameter.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private String
				 _lMSHostRechner
				= new String
				()
				;
				private String
				 _lMSHostNutzer
				= new String
				()
				;
				private String
				 _lMSHostPasswort
				= new String
				()
				;
				private String
				 _eigeneID
				= new String
				()
				;
				private String
				 _versandDateiNamePrefix
				= new String
				()
				;
				private String
				 _ausgangsverzeichnis
				= new String
				()
				;
				private String
				 _eingangsverzeichnis
				= new String
				()
				;
				private String
				 _sicherungsverzeichnis
				= new String
				()
				;
				@Defaultwert(wert = "5")
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerTage
				 _sicherungszeit
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten
				 _testIntervallKommunikation
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 _laufendeNummer
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttLmsVersandart
				 _versandart
				;
				private 	RelativerZeitstempel
				 _versandZyklus
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern1Bis
				 _koordinatenRaster
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Hostname oder IP-Adresse des Rechners der LMS.
			<p>
			
			</p>
			
			@return der Wert von LMSHostRechner.
			*/
				public String
				 getLMSHostRechner() {
				return _lMSHostRechner;
			}
		
			/**
			Hostname oder IP-Adresse des Rechners der LMS.
			<p>
			
			</p>
			
			@param _lMSHostRechner der neue Wert von LMSHostRechner.
			*/
			public void setLMSHostRechner(String
			 _lMSHostRechner) {
				if (_lMSHostRechner.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._lMSHostRechner = _lMSHostRechner;
			}
		
			/**
			Benutzername am Rechners der LMS.
			<p>
			
			</p>
			
			@return der Wert von LMSHostNutzer.
			*/
				public String
				 getLMSHostNutzer() {
				return _lMSHostNutzer;
			}
		
			/**
			Benutzername am Rechners der LMS.
			<p>
			
			</p>
			
			@param _lMSHostNutzer der neue Wert von LMSHostNutzer.
			*/
			public void setLMSHostNutzer(String
			 _lMSHostNutzer) {
				if (_lMSHostNutzer.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._lMSHostNutzer = _lMSHostNutzer;
			}
		
			/**
			Passwort am Rechners der LMS.
			<p>
			
			</p>
			
			@return der Wert von LMSHostPasswort.
			*/
				public String
				 getLMSHostPasswort() {
				return _lMSHostPasswort;
			}
		
			/**
			Passwort am Rechners der LMS.
			<p>
			
			</p>
			
			@param _lMSHostPasswort der neue Wert von LMSHostPasswort.
			*/
			public void setLMSHostPasswort(String
			 _lMSHostPasswort) {
				if (_lMSHostPasswort.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._lMSHostPasswort = _lMSHostPasswort;
			}
		
			/**
			Eigene ID für die zu versendenden Meldungen.
			<p>
			Vorgabe für das Element 'DataProducer' (Datenproduzent) in der XML-Datei bei zu versendenden Meldungen.
			</p>
			
			@return der Wert von EigeneID.
			*/
				public String
				 getEigeneID() {
				return _eigeneID;
			}
		
			/**
			Eigene ID für die zu versendenden Meldungen.
			<p>
			Vorgabe für das Element 'DataProducer' (Datenproduzent) in der XML-Datei bei zu versendenden Meldungen.
			</p>
			
			@param _eigeneID der neue Wert von EigeneID.
			*/
			public void setEigeneID(String
			 _eigeneID) {
				if (_eigeneID.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._eigeneID = _eigeneID;
			}
		
			/**
			Prefix des Dateinamens für die an die LMS zu sendende Datei.
			<p>
			
			</p>
			
			@return der Wert von VersandDateiNamePrefix.
			*/
				public String
				 getVersandDateiNamePrefix() {
				return _versandDateiNamePrefix;
			}
		
			/**
			Prefix des Dateinamens für die an die LMS zu sendende Datei.
			<p>
			
			</p>
			
			@param _versandDateiNamePrefix der neue Wert von VersandDateiNamePrefix.
			*/
			public void setVersandDateiNamePrefix(String
			 _versandDateiNamePrefix) {
				if (_versandDateiNamePrefix.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._versandDateiNamePrefix = _versandDateiNamePrefix;
			}
		
			/**
			Pfad des Ausgangsverzeichnisses.
			<p>
			&lt;absatz&gt;Pfadname auf dem LMS-Rechner, in dem die zu versendenden Meldungen abgelegt werden sollen.
									&lt;&#47;absatz&gt;
									&lt;absatz&gt; Wenn der Wert nicht gesetzt ist, werden die Dateien ohne Verzeichniswechsel transferiert, d.h. in das Verzeichnis, in dem der FTP-Client nach der Anmeldung steht.
									&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von Ausgangsverzeichnis.
			*/
				public String
				 getAusgangsverzeichnis() {
				return _ausgangsverzeichnis;
			}
		
			/**
			Pfad des Ausgangsverzeichnisses.
			<p>
			&lt;absatz&gt;Pfadname auf dem LMS-Rechner, in dem die zu versendenden Meldungen abgelegt werden sollen.
									&lt;&#47;absatz&gt;
									&lt;absatz&gt; Wenn der Wert nicht gesetzt ist, werden die Dateien ohne Verzeichniswechsel transferiert, d.h. in das Verzeichnis, in dem der FTP-Client nach der Anmeldung steht.
									&lt;&#47;absatz&gt;
			</p>
			
			@param _ausgangsverzeichnis der neue Wert von Ausgangsverzeichnis.
			*/
			public void setAusgangsverzeichnis(String
			 _ausgangsverzeichnis) {
				if (_ausgangsverzeichnis.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._ausgangsverzeichnis = _ausgangsverzeichnis;
			}
		
			/**
			Pfad des Eingangsverzeichnisses.
			<p>
			&lt;absatz&gt;Pfadname auf dem lokalen Rechner, in dem die Meldungen der LMS erwartet werden.
									&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von Eingangsverzeichnis.
			*/
				public String
				 getEingangsverzeichnis() {
				return _eingangsverzeichnis;
			}
		
			/**
			Pfad des Eingangsverzeichnisses.
			<p>
			&lt;absatz&gt;Pfadname auf dem lokalen Rechner, in dem die Meldungen der LMS erwartet werden.
									&lt;&#47;absatz&gt;
			</p>
			
			@param _eingangsverzeichnis der neue Wert von Eingangsverzeichnis.
			*/
			public void setEingangsverzeichnis(String
			 _eingangsverzeichnis) {
				if (_eingangsverzeichnis.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._eingangsverzeichnis = _eingangsverzeichnis;
			}
		
			/**
			Pfad des Sicherungsverzeichnisses.
			<p>
			&lt;absatz&gt;Pfadname auf dem lokalen Rechner, in dem fehlerhafte Dateien gespeichert werden.
									&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von Sicherungsverzeichnis.
			*/
				public String
				 getSicherungsverzeichnis() {
				return _sicherungsverzeichnis;
			}
		
			/**
			Pfad des Sicherungsverzeichnisses.
			<p>
			&lt;absatz&gt;Pfadname auf dem lokalen Rechner, in dem fehlerhafte Dateien gespeichert werden.
									&lt;&#47;absatz&gt;
			</p>
			
			@param _sicherungsverzeichnis der neue Wert von Sicherungsverzeichnis.
			*/
			public void setSicherungsverzeichnis(String
			 _sicherungsverzeichnis) {
				if (_sicherungsverzeichnis.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._sicherungsverzeichnis = _sicherungsverzeichnis;
			}
		
			/**
			Sicherungszeit.
			<p>
			Legt die Dauer (in Tagen) fest, wie lange die gesicherten Dateien im Sicherungsverzeichis gespeichert werden.
			</p>
			
			@return der Wert von Sicherungszeit.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerTage
				 getSicherungszeit() {
				return _sicherungszeit;
			}
		
			/**
			Sicherungszeit.
			<p>
			Legt die Dauer (in Tagen) fest, wie lange die gesicherten Dateien im Sicherungsverzeichis gespeichert werden.
			</p>
			
			@param _sicherungszeit der neue Wert von Sicherungszeit.
			*/
			public void setSicherungszeit(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerTage
			 _sicherungszeit) {
				this._sicherungszeit = _sicherungszeit;
			}
		
			/**
			Zeitintervall zur Überprüfung der Kommunikation.
			<p>
			Die Kommunikation zwischen LMS und VRZ wird mit
									diesem Zyklus überwacht. Der Wert gilt für die Überwachung beider
									Richtungen.
			</p>
			
			@return der Wert von TestIntervallKommunikation.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten
				 getTestIntervallKommunikation() {
				return _testIntervallKommunikation;
			}
		
			/**
			Zeitintervall zur Überprüfung der Kommunikation.
			<p>
			Die Kommunikation zwischen LMS und VRZ wird mit
									diesem Zyklus überwacht. Der Wert gilt für die Überwachung beider
									Richtungen.
			</p>
			
			@param _testIntervallKommunikation der neue Wert von TestIntervallKommunikation.
			*/
			public void setTestIntervallKommunikation(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten
			 _testIntervallKommunikation) {
				this._testIntervallKommunikation = _testIntervallKommunikation;
			}
		
			/**
			Laufende Nummer der Meldung.
			<p>
			Laufende Nummer der letzten an die LMS versendeten
									TIC-Meldung als Basis für die Bildung Element 'DataIdentifier' (Datenkennung).
			</p>
			
			@return der Wert von LaufendeNummer.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 getLaufendeNummer() {
				return _laufendeNummer;
			}
		
			/**
			Laufende Nummer der Meldung.
			<p>
			Laufende Nummer der letzten an die LMS versendeten
									TIC-Meldung als Basis für die Bildung Element 'DataIdentifier' (Datenkennung).
			</p>
			
			@param _laufendeNummer der neue Wert von LaufendeNummer.
			*/
			public void setLaufendeNummer(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _laufendeNummer) {
				this._laufendeNummer = _laufendeNummer;
			}
		
			/**
			Versandart.
			<p>
			
			</p>
			
			@return der Wert von Versandart.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttLmsVersandart
				 getVersandart() {
				return _versandart;
			}
		
			/**
			Versandart.
			<p>
			
			</p>
			
			@param _versandart der neue Wert von Versandart.
			*/
			public void setVersandart(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttLmsVersandart
			 _versandart) {
				this._versandart = _versandart;
			}
		
			/**
			Versandzykluszeit bei Versandart 'zyklisch'.
			<p>
			
			</p>
			
			@return der Wert von VersandZyklus.
			*/
				public 	RelativerZeitstempel
				 getVersandZyklus() {
				return _versandZyklus;
			}
		
			/**
			Versandzykluszeit bei Versandart 'zyklisch'.
			<p>
			
			</p>
			
			@param _versandZyklus der neue Wert von VersandZyklus.
			*/
			public void setVersandZyklus(	RelativerZeitstempel
			 _versandZyklus) {
				this._versandZyklus = _versandZyklus;
			}
		
			/**
			Koodinatenraster in Meter, auf welches die Koordinatenlisten reduziert werden. Wenn nicht angegeben (nicht ermittelbar), werden die Koordinatenlisten unverändert übernommen.
			<p>
			
			</p>
			
			@return der Wert von KoordinatenRaster.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern1Bis
				 getKoordinatenRaster() {
				return _koordinatenRaster;
			}
		
			/**
			Koodinatenraster in Meter, auf welches die Koordinatenlisten reduziert werden. Wenn nicht angegeben (nicht ermittelbar), werden die Koordinatenlisten unverändert übernommen.
			<p>
			
			</p>
			
			@param _koordinatenRaster der neue Wert von KoordinatenRaster.
			*/
			public void setKoordinatenRaster(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern1Bis
			 _koordinatenRaster) {
				this._koordinatenRaster = _koordinatenRaster;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
					if (getLMSHostRechner() != null) {
						datum.getTextValue("LMSHostRechner").setText(getLMSHostRechner());
					}
					// ZeichenkettenAttributTyp
					if (getLMSHostNutzer() != null) {
						datum.getTextValue("LMSHostNutzer").setText(getLMSHostNutzer());
					}
					// ZeichenkettenAttributTyp
					if (getLMSHostPasswort() != null) {
						datum.getTextValue("LMSHostPasswort").setText(getLMSHostPasswort());
					}
					// ZeichenkettenAttributTyp
					if (getEigeneID() != null) {
						datum.getTextValue("EigeneID").setText(getEigeneID());
					}
					// ZeichenkettenAttributTyp
					if (getVersandDateiNamePrefix() != null) {
						datum.getTextValue("VersandDateiNamePrefix").setText(getVersandDateiNamePrefix());
					}
					// ZeichenkettenAttributTyp
					if (getAusgangsverzeichnis() != null) {
						datum.getTextValue("Ausgangsverzeichnis").setText(getAusgangsverzeichnis());
					}
					// ZeichenkettenAttributTyp
					if (getEingangsverzeichnis() != null) {
						datum.getTextValue("Eingangsverzeichnis").setText(getEingangsverzeichnis());
					}
					// ZeichenkettenAttributTyp
					if (getSicherungsverzeichnis() != null) {
						datum.getTextValue("Sicherungsverzeichnis").setText(getSicherungsverzeichnis());
					}
					// GanzzahlAttributTyp
					if (getSicherungszeit() != null) {
		                if (getSicherungszeit().isZustand()) {
		                    datum.getUnscaledValue("Sicherungszeit").setText(getSicherungszeit().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Sicherungszeit").set(getSicherungszeit().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getTestIntervallKommunikation() != null) {
		                if (getTestIntervallKommunikation().isZustand()) {
		                    datum.getUnscaledValue("TestIntervallKommunikation").setText(getTestIntervallKommunikation().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("TestIntervallKommunikation").set(getTestIntervallKommunikation().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLaufendeNummer() != null) {
		                if (getLaufendeNummer().isZustand()) {
		                    datum.getUnscaledValue("LaufendeNummer").setText(getLaufendeNummer().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("LaufendeNummer").set(getLaufendeNummer().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVersandart() != null) {
		                if (getVersandart().isZustand()) {
		                    datum.getUnscaledValue("Versandart").setText(getVersandart().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Versandart").set(getVersandart().getValue());
		                }
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("VersandZyklus").setMillis(getVersandZyklus().getTime());
					// GanzzahlAttributTyp
					if (getKoordinatenRaster() != null) {
		                if (getKoordinatenRaster().isZustand()) {
		                    datum.getUnscaledValue("KoordinatenRaster").setText(getKoordinatenRaster().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("KoordinatenRaster").set(getKoordinatenRaster().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
						setLMSHostRechner(daten.getTextValue("LMSHostRechner").getText());
					// ZeichenkettenAttributTyp
						setLMSHostNutzer(daten.getTextValue("LMSHostNutzer").getText());
					// ZeichenkettenAttributTyp
						setLMSHostPasswort(daten.getTextValue("LMSHostPasswort").getText());
					// ZeichenkettenAttributTyp
						setEigeneID(daten.getTextValue("EigeneID").getText());
					// ZeichenkettenAttributTyp
						setVersandDateiNamePrefix(daten.getTextValue("VersandDateiNamePrefix").getText());
					// ZeichenkettenAttributTyp
						setAusgangsverzeichnis(daten.getTextValue("Ausgangsverzeichnis").getText());
					// ZeichenkettenAttributTyp
						setEingangsverzeichnis(daten.getTextValue("Eingangsverzeichnis").getText());
					// ZeichenkettenAttributTyp
						setSicherungsverzeichnis(daten.getTextValue("Sicherungsverzeichnis").getText());
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Sicherungszeit").isState()) {
								setSicherungszeit(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerTage
								.getZustand(daten.getScaledValue("Sicherungszeit").getText()));
							} else {
							setSicherungszeit(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerTage
							(daten.
								getUnscaledValue
							("Sicherungszeit").
									longValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("TestIntervallKommunikation").isState()) {
								setTestIntervallKommunikation(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten
								.getZustand(daten.getScaledValue("TestIntervallKommunikation").getText()));
							} else {
							setTestIntervallKommunikation(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten
							(daten.
								getUnscaledValue
							("TestIntervallKommunikation").
									longValue
							()));
							}
					// GanzzahlAttributTyp
							setLaufendeNummer(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
							(daten.
								getUnscaledValue
							("LaufendeNummer").
									longValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Versandart").isState()) {
								setVersandart(de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttLmsVersandart
								.getZustand(daten.getScaledValue("Versandart").getText()));
							} else {
							setVersandart(new de.bsvrz.sys.funclib.bitctrl.modell.tmkexlmstic3.attribute.AttLmsVersandart
							(daten.
								getUnscaledValue
							("Versandart").
									byteValue
							()));
							}
					// ZeitstempelAttributTyp
						setVersandZyklus(new
							RelativerZeitstempel
							(daten.getTimeValue("VersandZyklus").getMillis()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("KoordinatenRaster").isState()) {
								setKoordinatenRaster(de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern1Bis
								.getZustand(daten.getScaledValue("KoordinatenRaster").getText()));
							} else {
							setKoordinatenRaster(new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.attribute.AttLaengeInMetern1Bis
							(daten.
								getUnscaledValue
							("KoordinatenRaster").
									intValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setLMSHostRechner(getLMSHostRechner());
							klon.setLMSHostNutzer(getLMSHostNutzer());
							klon.setLMSHostPasswort(getLMSHostPasswort());
							klon.setEigeneID(getEigeneID());
							klon.setVersandDateiNamePrefix(getVersandDateiNamePrefix());
							klon.setAusgangsverzeichnis(getAusgangsverzeichnis());
							klon.setEingangsverzeichnis(getEingangsverzeichnis());
							klon.setSicherungsverzeichnis(getSicherungsverzeichnis());
							klon.setSicherungszeit(getSicherungszeit());
							klon.setTestIntervallKommunikation(getTestIntervallKommunikation());
							klon.setLaufendeNummer(getLaufendeNummer());
							klon.setVersandart(getVersandart());
							klon.setVersandZyklus(getVersandZyklus());
							klon.setKoordinatenRaster(getKoordinatenRaster());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.lmsKommunikationsParameter";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdLmsKommunikationsParameter(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
