/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zusatzinformationen zum Bereich DP.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Wertebereich(
	minimum = 0L,
	maximum = 2L,
	einheit = ""
)
public class AttTlsLveProVerkehrsStufeInfoDP extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Byte
	 MIN_VALUE =
				Byte
		.valueOf("0");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Byte
	 MAX_VALUE =
				Byte
		.valueOf("2");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	D kleiner DP2Ein.
	<p>
	
	</p>
	*/
	public static final AttTlsLveProVerkehrsStufeInfoDP ZUSTAND_0_D_KLEINER_DP2EIN = new AttTlsLveProVerkehrsStufeInfoDP("D kleiner DP2Ein", 		Byte
	.valueOf("0"));

	/**
	D größer DP2Ein UND D kleinerGleich DP4Ein.
	<p>
	
	</p>
	*/
	public static final AttTlsLveProVerkehrsStufeInfoDP ZUSTAND_1_D_GROESSER_DP2EIN_UND_D_KLEINERGLEICH_DP4EIN = new AttTlsLveProVerkehrsStufeInfoDP("D größer DP2Ein UND D kleinerGleich DP4Ein", 		Byte
	.valueOf("1"));

	/**
	D größer DP4Ein.
	<p>
	
	</p>
	*/
	public static final AttTlsLveProVerkehrsStufeInfoDP ZUSTAND_2_D_GROESSER_DP4EIN = new AttTlsLveProVerkehrsStufeInfoDP("D größer DP4Ein", 		Byte
	.valueOf("2"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsLveProVerkehrsStufeInfoDP getZustand(final 		Byte
	 value) {
		for (AttTlsLveProVerkehrsStufeInfoDP e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsLveProVerkehrsStufeInfoDP getZustand(final String value) {
		for (AttTlsLveProVerkehrsStufeInfoDP e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsLveProVerkehrsStufeInfoDP> getZustaende() {
		List<AttTlsLveProVerkehrsStufeInfoDP> list = new ArrayList<AttTlsLveProVerkehrsStufeInfoDP>();
		list.add(ZUSTAND_0_D_KLEINER_DP2EIN);
		list.add(ZUSTAND_1_D_GROESSER_DP2EIN_UND_D_KLEINERGLEICH_DP4EIN);
		list.add(ZUSTAND_2_D_GROESSER_DP4EIN);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TlsLveProVerkehrsStufeInfoDP.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsLveProVerkehrsStufeInfoDP(final 		Byte
	 value) {
		super(value);
	}
	
	private AttTlsLveProVerkehrsStufeInfoDP(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
