/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zusatzinformationen zum Bereich VKfzP.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Wertebereich(
	minimum = 0L,
	maximum = 2L,
	einheit = ""
)
public class AttTlsLveProVerkehrsStufeInfoVKfzP extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Byte
	 MIN_VALUE =
				Byte
		.valueOf("0");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Byte
	 MAX_VALUE =
				Byte
		.valueOf("2");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	VKfzP größerGleich VKfzP3Ein.
	<p>
	
	</p>
	*/
	public static final AttTlsLveProVerkehrsStufeInfoVKfzP ZUSTAND_0_VKFZP_GROESSERGLEICH_VKFZP3EIN = new AttTlsLveProVerkehrsStufeInfoVKfzP("VKfzP größerGleich VKfzP3Ein", 		Byte
	.valueOf("0"));

	/**
	VKfzP kleiner VKfzP3Ein UND VKfzP größerGlleich VKfzP4Ein.
	<p>
	
	</p>
	*/
	public static final AttTlsLveProVerkehrsStufeInfoVKfzP ZUSTAND_1_VKFZP_KLEINER_VKFZP3EIN_UND_VKFZP_GROESSERGLLEICH_VKFZP4EIN = new AttTlsLveProVerkehrsStufeInfoVKfzP("VKfzP kleiner VKfzP3Ein UND VKfzP größerGlleich VKfzP4Ein", 		Byte
	.valueOf("1"));

	/**
	VKfzP kleiner VKfzP4Ein.
	<p>
	
	</p>
	*/
	public static final AttTlsLveProVerkehrsStufeInfoVKfzP ZUSTAND_2_VKFZP_KLEINER_VKFZP4EIN = new AttTlsLveProVerkehrsStufeInfoVKfzP("VKfzP kleiner VKfzP4Ein", 		Byte
	.valueOf("2"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsLveProVerkehrsStufeInfoVKfzP getZustand(final 		Byte
	 value) {
		for (AttTlsLveProVerkehrsStufeInfoVKfzP e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsLveProVerkehrsStufeInfoVKfzP getZustand(final String value) {
		for (AttTlsLveProVerkehrsStufeInfoVKfzP e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsLveProVerkehrsStufeInfoVKfzP> getZustaende() {
		List<AttTlsLveProVerkehrsStufeInfoVKfzP> list = new ArrayList<AttTlsLveProVerkehrsStufeInfoVKfzP>();
		list.add(ZUSTAND_0_VKFZP_GROESSERGLEICH_VKFZP3EIN);
		list.add(ZUSTAND_1_VKFZP_KLEINER_VKFZP3EIN_UND_VKFZP_GROESSERGLLEICH_VKFZP4EIN);
		list.add(ZUSTAND_2_VKFZP_KLEINER_VKFZP4EIN);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TlsLveProVerkehrsStufeInfoVKfzP.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsLveProVerkehrsStufeInfoVKfzP(final 		Byte
	 value) {
		super(value);
	}
	
	private AttTlsLveProVerkehrsStufeInfoVKfzP(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
