/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter für richtungsbezogene Kenndaten bei Zuflussregelung (FG 1 &#47; Typ 162 - Dürr).
<p>
&lt;sektion&gt;
                        &lt;titel&gt;FG 1: DE-Block-Struktur im Typ 162 "Parameter für richtungsbezogene Kenndaten"&lt;&#47;titel&gt;
                        &lt;absatz&gt;Wird verwendet mit ID 3 (Parameter) in Abruf- und Antwortrichtung oder mit ID 35
                            (Parametermeldung aus Puffer) in Antwortrichtung.
                        &lt;&#47;absatz&gt;
                        &lt;absatz&gt;Die Nachricht überträgt Parameter für richtungsbezogene Kenndaten.
                        &lt;&#47;absatz&gt;
                    &lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class PdTlsLveParamProRichtungsBezogeneKenndaten extends AbstractParameterDatensatz<PdTlsLveParamProRichtungsBezogeneKenndaten.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsParameterVorgabeArchiv,
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.TlsVorgabeBedienung,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt für den Quittierungsmechanismus des Archivs. Wird alternativ zu asp.parameterVorgabe
						verwendet, wenn die Vorgabe indirekt nach der Archivierung durch das Archiv
						erfolgen soll.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsParameterVorgabeArchiv = new Aspekte("TlsVorgabeArchiv", "asp.tlsParameterVorgabeArchiv");
			
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * NICHT VERWENDEN. KANN JEDERZEIT WIEDER GELÖSCHT
						WERDEN. Aspekt für Vorgaben von einer Bedienung, die
						nicht wie die Parametersätze automatisch verschickt
						werden (z.B. Schaltdaten, dient zur Unterscheidung
						der Quelle).	 
			 *
			 * <p>
			 * NICHT VERWENDEN. KANN JEDERZEIT WIEDER GELÖSCHT
						WERDEN. Wird verwendet, wenn zusätzlich zum
						asp.tlsVorgabe weitere unterscheidbare Vorgaben
						benötigt werden. Vorgaben aus diesem Aspekt werden
						i. d. R. nicht direkt an die SS geschickt, sondern
						(z. B. über WAN-COM) an eine Zwischensschicht, um
						DaV-Systeme mit Altsystemen zu koppeln.
	         * </p>
			 */
			public static final Aspekt TlsVorgabeBedienung = new Aspekte("TlsVorgabeBedienung", "asp.tlsVorgabeBedienung");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
				 _hersteller
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProKanalMaske
				 _kanalMaske01Bis08
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProKanalMaske
				 _kanalMaske09Bis16
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProKanalMaske
				 _kanalMaske17Bis24
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProKanalMaske
				 _kanalMaske25Bis32
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 _reserve01
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 _reserve02
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 _reserve03
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 _reserve04
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qx
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vKfz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vPkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vLkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 _reserve05
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProAlpha
				 _alpha1
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProBeta
				 _beta1
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProAlpha
				 _alpha2
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProBeta
				 _beta2
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProGewichtung
				 _k1
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProGewichtung
				 _k2
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProAnzahlZyklen
				 _zTtimo
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 _reserve06
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
				 _dMax
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
				 _dGrenz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 _reserve07
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 _reserve08
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 _reserve09
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 _reserve10
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Herstellercode: Dürr = 48.
			<p>
			
			</p>
			
			@return der Wert von Hersteller.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
				 getHersteller() {
				return _hersteller;
			}
		
			/**
			Herstellercode: Dürr = 48.
			<p>
			
			</p>
			
			@param _hersteller der neue Wert von Hersteller.
			*/
			public void setHersteller(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
			 _hersteller) {
				this._hersteller = _hersteller;
			}
		
			/**
			Die richtungsbezogenen Kenngrößen beziehen sich auf Daten mehrerer Fahrstreifen. Die Einzelfahrstreifen müssen sich im gleichen Cluster (also auf dem gleichen EAK) befinden. Die Nummer der einzelen Bits in der Maske bezeichnet den physikalischen Kanal der Fahrstreifen die für die richtungsbezogenen Kenngrößen verarbeitet werden: gesetzt bedeutet der Kanal wird bearbeitet.
			<p>
			
			</p>
			
			@return der Wert von KanalMaske01Bis08.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProKanalMaske
				 getKanalMaske01Bis08() {
				return _kanalMaske01Bis08;
			}
		
			/**
			Die richtungsbezogenen Kenngrößen beziehen sich auf Daten mehrerer Fahrstreifen. Die Einzelfahrstreifen müssen sich im gleichen Cluster (also auf dem gleichen EAK) befinden. Die Nummer der einzelen Bits in der Maske bezeichnet den physikalischen Kanal der Fahrstreifen die für die richtungsbezogenen Kenngrößen verarbeitet werden: gesetzt bedeutet der Kanal wird bearbeitet.
			<p>
			
			</p>
			
			@param _kanalMaske01Bis08 der neue Wert von KanalMaske01Bis08.
			*/
			public void setKanalMaske01Bis08(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProKanalMaske
			 _kanalMaske01Bis08) {
				this._kanalMaske01Bis08 = _kanalMaske01Bis08;
			}
		
			/**
			Die richtungsbezogenen Kenngrößen beziehen sich auf Daten mehrerer Fahrstreifen. Die Einzelfahrstreifen müssen sich im gleichen Cluster (also auf dem gleichen EAK) befinden. Die Nummer der einzelen Bits in der Maske bezeichnet den physikalischen Kanal der Fahrstreifen die für die richtungsbezogenen Kenngrößen verarbeitet werden: gesetzt bedeutet der Kanal wird bearbeitet.
			<p>
			
			</p>
			
			@return der Wert von KanalMaske09Bis16.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProKanalMaske
				 getKanalMaske09Bis16() {
				return _kanalMaske09Bis16;
			}
		
			/**
			Die richtungsbezogenen Kenngrößen beziehen sich auf Daten mehrerer Fahrstreifen. Die Einzelfahrstreifen müssen sich im gleichen Cluster (also auf dem gleichen EAK) befinden. Die Nummer der einzelen Bits in der Maske bezeichnet den physikalischen Kanal der Fahrstreifen die für die richtungsbezogenen Kenngrößen verarbeitet werden: gesetzt bedeutet der Kanal wird bearbeitet.
			<p>
			
			</p>
			
			@param _kanalMaske09Bis16 der neue Wert von KanalMaske09Bis16.
			*/
			public void setKanalMaske09Bis16(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProKanalMaske
			 _kanalMaske09Bis16) {
				this._kanalMaske09Bis16 = _kanalMaske09Bis16;
			}
		
			/**
			Die richtungsbezogenen Kenngrößen beziehen sich auf Daten mehrerer Fahrstreifen. Die Einzelfahrstreifen müssen sich im gleichen Cluster (also auf dem gleichen EAK) befinden. Die Nummer der einzelen Bits in der Maske bezeichnet den physikalischen Kanal der Fahrstreifen die für die richtungsbezogenen Kenngrößen verarbeitet werden: gesetzt bedeutet der Kanal wird bearbeitet.
			<p>
			
			</p>
			
			@return der Wert von KanalMaske17Bis24.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProKanalMaske
				 getKanalMaske17Bis24() {
				return _kanalMaske17Bis24;
			}
		
			/**
			Die richtungsbezogenen Kenngrößen beziehen sich auf Daten mehrerer Fahrstreifen. Die Einzelfahrstreifen müssen sich im gleichen Cluster (also auf dem gleichen EAK) befinden. Die Nummer der einzelen Bits in der Maske bezeichnet den physikalischen Kanal der Fahrstreifen die für die richtungsbezogenen Kenngrößen verarbeitet werden: gesetzt bedeutet der Kanal wird bearbeitet.
			<p>
			
			</p>
			
			@param _kanalMaske17Bis24 der neue Wert von KanalMaske17Bis24.
			*/
			public void setKanalMaske17Bis24(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProKanalMaske
			 _kanalMaske17Bis24) {
				this._kanalMaske17Bis24 = _kanalMaske17Bis24;
			}
		
			/**
			Die richtungsbezogenen Kenngrößen beziehen sich auf Daten mehrerer Fahrstreifen. Die Einzelfahrstreifen müssen sich im gleichen Cluster (also auf dem gleichen EAK) befinden. Die Nummer der einzelen Bits in der Maske bezeichnet den physikalischen Kanal der Fahrstreifen die für die richtungsbezogenen Kenngrößen verarbeitet werden: gesetzt bedeutet der Kanal wird bearbeitet.
			<p>
			
			</p>
			
			@return der Wert von KanalMaske25Bis32.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProKanalMaske
				 getKanalMaske25Bis32() {
				return _kanalMaske25Bis32;
			}
		
			/**
			Die richtungsbezogenen Kenngrößen beziehen sich auf Daten mehrerer Fahrstreifen. Die Einzelfahrstreifen müssen sich im gleichen Cluster (also auf dem gleichen EAK) befinden. Die Nummer der einzelen Bits in der Maske bezeichnet den physikalischen Kanal der Fahrstreifen die für die richtungsbezogenen Kenngrößen verarbeitet werden: gesetzt bedeutet der Kanal wird bearbeitet.
			<p>
			
			</p>
			
			@param _kanalMaske25Bis32 der neue Wert von KanalMaske25Bis32.
			*/
			public void setKanalMaske25Bis32(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProKanalMaske
			 _kanalMaske25Bis32) {
				this._kanalMaske25Bis32 = _kanalMaske25Bis32;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@return der Wert von Reserve01.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 getReserve01() {
				return _reserve01;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@param _reserve01 der neue Wert von Reserve01.
			*/
			public void setReserve01(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
			 _reserve01) {
				this._reserve01 = _reserve01;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@return der Wert von Reserve02.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 getReserve02() {
				return _reserve02;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@param _reserve02 der neue Wert von Reserve02.
			*/
			public void setReserve02(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
			 _reserve02) {
				this._reserve02 = _reserve02;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@return der Wert von Reserve03.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 getReserve03() {
				return _reserve03;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@param _reserve03 der neue Wert von Reserve03.
			*/
			public void setReserve03(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
			 _reserve03) {
				this._reserve03 = _reserve03;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@return der Wert von Reserve04.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 getReserve04() {
				return _reserve04;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@param _reserve04 der neue Wert von Reserve04.
			*/
			public void setReserve04(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
			 _reserve04) {
				this._reserve04 = _reserve04;
			}
		
			/**
			Startwert für Qx, siehe MARZ Kapitel 2.3.2.1.3.
			<p>
			
			</p>
			
			@return der Wert von Qx.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQx() {
				return _qx;
			}
		
			/**
			Startwert für Qx, siehe MARZ Kapitel 2.3.2.1.3.
			<p>
			
			</p>
			
			@param _qx der neue Wert von Qx.
			*/
			public void setQx(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qx) {
				this._qx = _qx;
			}
		
			/**
			Startwert für VKfz.
			<p>
			
			</p>
			
			@return der Wert von VKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVKfz() {
				return _vKfz;
			}
		
			/**
			Startwert für VKfz.
			<p>
			
			</p>
			
			@param _vKfz der neue Wert von VKfz.
			*/
			public void setVKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vKfz) {
				this._vKfz = _vKfz;
			}
		
			/**
			Startwert für VPkw.
			<p>
			
			</p>
			
			@return der Wert von VPkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVPkw() {
				return _vPkw;
			}
		
			/**
			Startwert für VPkw.
			<p>
			
			</p>
			
			@param _vPkw der neue Wert von VPkw.
			*/
			public void setVPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vPkw) {
				this._vPkw = _vPkw;
			}
		
			/**
			Startwert für VLkw.
			<p>
			
			</p>
			
			@return der Wert von VLkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVLkw() {
				return _vLkw;
			}
		
			/**
			Startwert für VLkw.
			<p>
			
			</p>
			
			@param _vLkw der neue Wert von VLkw.
			*/
			public void setVLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vLkw) {
				this._vLkw = _vLkw;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@return der Wert von Reserve05.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 getReserve05() {
				return _reserve05;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@param _reserve05 der neue Wert von Reserve05.
			*/
			public void setReserve05(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
			 _reserve05) {
				this._reserve05 = _reserve05;
			}
		
			/**
			Prognoseglättungsfaktor Mittelwert alpha1.
			<p>
			
			</p>
			
			@return der Wert von Alpha1.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProAlpha
				 getAlpha1() {
				return _alpha1;
			}
		
			/**
			Prognoseglättungsfaktor Mittelwert alpha1.
			<p>
			
			</p>
			
			@param _alpha1 der neue Wert von Alpha1.
			*/
			public void setAlpha1(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProAlpha
			 _alpha1) {
				this._alpha1 = _alpha1;
			}
		
			/**
			Prognoseglättungsfaktor Trend beta1.
			<p>
			
			</p>
			
			@return der Wert von Beta1.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProBeta
				 getBeta1() {
				return _beta1;
			}
		
			/**
			Prognoseglättungsfaktor Trend beta1.
			<p>
			
			</p>
			
			@param _beta1 der neue Wert von Beta1.
			*/
			public void setBeta1(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProBeta
			 _beta1) {
				this._beta1 = _beta1;
			}
		
			/**
			Prognoseglättungsfaktor Mittelwert alpha2.
			<p>
			
			</p>
			
			@return der Wert von Alpha2.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProAlpha
				 getAlpha2() {
				return _alpha2;
			}
		
			/**
			Prognoseglättungsfaktor Mittelwert alpha2.
			<p>
			
			</p>
			
			@param _alpha2 der neue Wert von Alpha2.
			*/
			public void setAlpha2(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProAlpha
			 _alpha2) {
				this._alpha2 = _alpha2;
			}
		
			/**
			Prognoseglättungsfaktor Trend beta2.
			<p>
			
			</p>
			
			@return der Wert von Beta2.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProBeta
				 getBeta2() {
				return _beta2;
			}
		
			/**
			Prognoseglättungsfaktor Trend beta2.
			<p>
			
			</p>
			
			@param _beta2 der neue Wert von Beta2.
			*/
			public void setBeta2(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProBeta
			 _beta2) {
				this._beta2 = _beta2;
			}
		
			/**
			Gewichtungsfaktor k1.
			<p>
			
			</p>
			
			@return der Wert von K1.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProGewichtung
				 getK1() {
				return _k1;
			}
		
			/**
			Gewichtungsfaktor k1.
			<p>
			
			</p>
			
			@param _k1 der neue Wert von K1.
			*/
			public void setK1(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProGewichtung
			 _k1) {
				this._k1 = _k1;
			}
		
			/**
			Gewichtungsfaktor k2.
			<p>
			
			</p>
			
			@return der Wert von K2.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProGewichtung
				 getK2() {
				return _k2;
			}
		
			/**
			Gewichtungsfaktor k2.
			<p>
			
			</p>
			
			@param _k2 der neue Wert von K2.
			*/
			public void setK2(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProGewichtung
			 _k2) {
				this._k2 = _k2;
			}
		
			/**
			Anzahl der Zyklen (LVE-Erfassungsintervalldauer&#47;Kurzzeitdaten), in denen ein ausgefallener Istwert ersetzt werden soll.
			<p>
			
			</p>
			
			@return der Wert von ZTtimo.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProAnzahlZyklen
				 getZTtimo() {
				return _zTtimo;
			}
		
			/**
			Anzahl der Zyklen (LVE-Erfassungsintervalldauer&#47;Kurzzeitdaten), in denen ein ausgefallener Istwert ersetzt werden soll.
			<p>
			
			</p>
			
			@param _zTtimo der neue Wert von ZTtimo.
			*/
			public void setZTtimo(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProAnzahlZyklen
			 _zTtimo) {
				this._zTtimo = _zTtimo;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@return der Wert von Reserve06.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 getReserve06() {
				return _reserve06;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@param _reserve06 der neue Wert von Reserve06.
			*/
			public void setReserve06(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
			 _reserve06) {
				this._reserve06 = _reserve06;
			}
		
			/**
			Dichte Maximal.
			<p>
			
			</p>
			
			@return der Wert von DMax.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
				 getDMax() {
				return _dMax;
			}
		
			/**
			Dichte Maximal.
			<p>
			
			</p>
			
			@param _dMax der neue Wert von DMax.
			*/
			public void setDMax(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
			 _dMax) {
				this._dMax = _dMax;
			}
		
			/**
			Dichte Grenzwert.
			<p>
			
			</p>
			
			@return der Wert von DGrenz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
				 getDGrenz() {
				return _dGrenz;
			}
		
			/**
			Dichte Grenzwert.
			<p>
			
			</p>
			
			@param _dGrenz der neue Wert von DGrenz.
			*/
			public void setDGrenz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
			 _dGrenz) {
				this._dGrenz = _dGrenz;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@return der Wert von Reserve07.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 getReserve07() {
				return _reserve07;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@param _reserve07 der neue Wert von Reserve07.
			*/
			public void setReserve07(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
			 _reserve07) {
				this._reserve07 = _reserve07;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@return der Wert von Reserve08.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 getReserve08() {
				return _reserve08;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@param _reserve08 der neue Wert von Reserve08.
			*/
			public void setReserve08(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
			 _reserve08) {
				this._reserve08 = _reserve08;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@return der Wert von Reserve09.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 getReserve09() {
				return _reserve09;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@param _reserve09 der neue Wert von Reserve09.
			*/
			public void setReserve09(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
			 _reserve09) {
				this._reserve09 = _reserve09;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@return der Wert von Reserve10.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 getReserve10() {
				return _reserve10;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@param _reserve10 der neue Wert von Reserve10.
			*/
			public void setReserve10(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
			 _reserve10) {
				this._reserve10 = _reserve10;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getHersteller() != null) {
		                if (getHersteller().isZustand()) {
		                    datum.getUnscaledValue("Hersteller").setText(getHersteller().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Hersteller").set(getHersteller().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getKanalMaske01Bis08() != null) {
		                if (getKanalMaske01Bis08().isZustand()) {
		                    datum.getUnscaledValue("KanalMaske01Bis08").setText(getKanalMaske01Bis08().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("KanalMaske01Bis08").set(getKanalMaske01Bis08().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getKanalMaske09Bis16() != null) {
		                if (getKanalMaske09Bis16().isZustand()) {
		                    datum.getUnscaledValue("KanalMaske09Bis16").setText(getKanalMaske09Bis16().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("KanalMaske09Bis16").set(getKanalMaske09Bis16().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getKanalMaske17Bis24() != null) {
		                if (getKanalMaske17Bis24().isZustand()) {
		                    datum.getUnscaledValue("KanalMaske17Bis24").setText(getKanalMaske17Bis24().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("KanalMaske17Bis24").set(getKanalMaske17Bis24().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getKanalMaske25Bis32() != null) {
		                if (getKanalMaske25Bis32().isZustand()) {
		                    datum.getUnscaledValue("KanalMaske25Bis32").setText(getKanalMaske25Bis32().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("KanalMaske25Bis32").set(getKanalMaske25Bis32().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getReserve01() != null) {
		                if (getReserve01().isZustand()) {
		                    datum.getUnscaledValue("Reserve01").setText(getReserve01().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Reserve01").set(getReserve01().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getReserve02() != null) {
		                if (getReserve02().isZustand()) {
		                    datum.getUnscaledValue("Reserve02").setText(getReserve02().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Reserve02").set(getReserve02().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getReserve03() != null) {
		                if (getReserve03().isZustand()) {
		                    datum.getUnscaledValue("Reserve03").setText(getReserve03().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Reserve03").set(getReserve03().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getReserve04() != null) {
		                if (getReserve04().isZustand()) {
		                    datum.getUnscaledValue("Reserve04").setText(getReserve04().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Reserve04").set(getReserve04().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQx() != null) {
		                if (getQx().isZustand()) {
		                    datum.getUnscaledValue("Qx").setText(getQx().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Qx").set(getQx().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVKfz() != null) {
		                if (getVKfz().isZustand()) {
		                    datum.getUnscaledValue("VKfz").setText(getVKfz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VKfz").set(getVKfz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVPkw() != null) {
		                if (getVPkw().isZustand()) {
		                    datum.getUnscaledValue("VPkw").setText(getVPkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VPkw").set(getVPkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVLkw() != null) {
		                if (getVLkw().isZustand()) {
		                    datum.getUnscaledValue("VLkw").setText(getVLkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VLkw").set(getVLkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getReserve05() != null) {
		                if (getReserve05().isZustand()) {
		                    datum.getUnscaledValue("Reserve05").setText(getReserve05().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Reserve05").set(getReserve05().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAlpha1() != null) {
		                if (getAlpha1().isZustand()) {
		                    datum.getUnscaledValue("alpha1").setText(getAlpha1().toString());
		                } else {
							datum.
							getScaledValue
		                	("alpha1").set(getAlpha1().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getBeta1() != null) {
		                if (getBeta1().isZustand()) {
		                    datum.getUnscaledValue("beta1").setText(getBeta1().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("beta1").set(getBeta1().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAlpha2() != null) {
		                if (getAlpha2().isZustand()) {
		                    datum.getUnscaledValue("alpha2").setText(getAlpha2().toString());
		                } else {
							datum.
							getScaledValue
		                	("alpha2").set(getAlpha2().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getBeta2() != null) {
		                if (getBeta2().isZustand()) {
		                    datum.getUnscaledValue("beta2").setText(getBeta2().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("beta2").set(getBeta2().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getK1() != null) {
		                if (getK1().isZustand()) {
		                    datum.getUnscaledValue("k1").setText(getK1().toString());
		                } else {
							datum.
							getScaledValue
		                	("k1").set(getK1().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getK2() != null) {
		                if (getK2().isZustand()) {
		                    datum.getUnscaledValue("k2").setText(getK2().toString());
		                } else {
							datum.
							getScaledValue
		                	("k2").set(getK2().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getZTtimo() != null) {
		                if (getZTtimo().isZustand()) {
		                    datum.getUnscaledValue("ZTtimo").setText(getZTtimo().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ZTtimo").set(getZTtimo().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getReserve06() != null) {
		                if (getReserve06().isZustand()) {
		                    datum.getUnscaledValue("Reserve06").setText(getReserve06().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Reserve06").set(getReserve06().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getDMax() != null) {
		                if (getDMax().isZustand()) {
		                    datum.getUnscaledValue("DMax").setText(getDMax().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("DMax").set(getDMax().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getDGrenz() != null) {
		                if (getDGrenz().isZustand()) {
		                    datum.getUnscaledValue("DGrenz").setText(getDGrenz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("DGrenz").set(getDGrenz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getReserve07() != null) {
		                if (getReserve07().isZustand()) {
		                    datum.getUnscaledValue("Reserve07").setText(getReserve07().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Reserve07").set(getReserve07().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getReserve08() != null) {
		                if (getReserve08().isZustand()) {
		                    datum.getUnscaledValue("Reserve08").setText(getReserve08().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Reserve08").set(getReserve08().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getReserve09() != null) {
		                if (getReserve09().isZustand()) {
		                    datum.getUnscaledValue("Reserve09").setText(getReserve09().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Reserve09").set(getReserve09().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getReserve10() != null) {
		                if (getReserve10().isZustand()) {
		                    datum.getUnscaledValue("Reserve10").setText(getReserve10().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Reserve10").set(getReserve10().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Hersteller").isState()) {
								setHersteller(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
								.getZustand(daten.getScaledValue("Hersteller").getText()));
							} else {
							setHersteller(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
							(daten.
								getUnscaledValue
							("Hersteller").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							setKanalMaske01Bis08(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProKanalMaske
							(daten.
								getUnscaledValue
							("KanalMaske01Bis08").
									shortValue
							()));
					// GanzzahlAttributTyp
							setKanalMaske09Bis16(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProKanalMaske
							(daten.
								getUnscaledValue
							("KanalMaske09Bis16").
									shortValue
							()));
					// GanzzahlAttributTyp
							setKanalMaske17Bis24(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProKanalMaske
							(daten.
								getUnscaledValue
							("KanalMaske17Bis24").
									shortValue
							()));
					// GanzzahlAttributTyp
							setKanalMaske25Bis32(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProKanalMaske
							(daten.
								getUnscaledValue
							("KanalMaske25Bis32").
									shortValue
							()));
					// GanzzahlAttributTyp
							setReserve01(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
							(daten.
								getUnscaledValue
							("Reserve01").
									shortValue
							()));
					// GanzzahlAttributTyp
							setReserve02(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
							(daten.
								getUnscaledValue
							("Reserve02").
									shortValue
							()));
					// GanzzahlAttributTyp
							setReserve03(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
							(daten.
								getUnscaledValue
							("Reserve03").
									shortValue
							()));
					// GanzzahlAttributTyp
							setReserve04(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
							(daten.
								getUnscaledValue
							("Reserve04").
									shortValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Qx").isState()) {
								setQx(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("Qx").getText()));
							} else {
							setQx(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("Qx").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VKfz").isState()) {
								setVKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("VKfz").getText()));
							} else {
							setVKfz(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("VKfz").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VPkw").isState()) {
								setVPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("VPkw").getText()));
							} else {
							setVPkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("VPkw").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VLkw").isState()) {
								setVLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("VLkw").getText()));
							} else {
							setVLkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("VLkw").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							setReserve05(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
							(daten.
								getUnscaledValue
							("Reserve05").
									shortValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("alpha1").isState()) {
								setAlpha1(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProAlpha
								.getZustand(daten.getScaledValue("alpha1").getText()));
							} else {
							setAlpha1(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProAlpha
							(daten.
								getScaledValue
							("alpha1").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("beta1").isState()) {
								setBeta1(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProBeta
								.getZustand(daten.getScaledValue("beta1").getText()));
							} else {
							setBeta1(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProBeta
							(daten.
								getUnscaledValue
							("beta1").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("alpha2").isState()) {
								setAlpha2(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProAlpha
								.getZustand(daten.getScaledValue("alpha2").getText()));
							} else {
							setAlpha2(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProAlpha
							(daten.
								getScaledValue
							("alpha2").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("beta2").isState()) {
								setBeta2(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProBeta
								.getZustand(daten.getScaledValue("beta2").getText()));
							} else {
							setBeta2(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProBeta
							(daten.
								getUnscaledValue
							("beta2").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							setK1(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProGewichtung
							(daten.
								getScaledValue
							("k1").
								doubleValue
							()));
					// GanzzahlAttributTyp
							setK2(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProGewichtung
							(daten.
								getScaledValue
							("k2").
								doubleValue
							()));
					// GanzzahlAttributTyp
							setZTtimo(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProAnzahlZyklen
							(daten.
								getUnscaledValue
							("ZTtimo").
									shortValue
							()));
					// GanzzahlAttributTyp
							setReserve06(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
							(daten.
								getUnscaledValue
							("Reserve06").
									shortValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("DMax").isState()) {
								setDMax(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
								.getZustand(daten.getScaledValue("DMax").getText()));
							} else {
							setDMax(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
							(daten.
								getUnscaledValue
							("DMax").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("DGrenz").isState()) {
								setDGrenz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
								.getZustand(daten.getScaledValue("DGrenz").getText()));
							} else {
							setDGrenz(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
							(daten.
								getUnscaledValue
							("DGrenz").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							setReserve07(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
							(daten.
								getUnscaledValue
							("Reserve07").
									shortValue
							()));
					// GanzzahlAttributTyp
							setReserve08(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
							(daten.
								getUnscaledValue
							("Reserve08").
									shortValue
							()));
					// GanzzahlAttributTyp
							setReserve09(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
							(daten.
								getUnscaledValue
							("Reserve09").
									shortValue
							()));
					// GanzzahlAttributTyp
							setReserve10(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
							(daten.
								getUnscaledValue
							("Reserve10").
									shortValue
							()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setHersteller(getHersteller());
							klon.setKanalMaske01Bis08(getKanalMaske01Bis08());
							klon.setKanalMaske09Bis16(getKanalMaske09Bis16());
							klon.setKanalMaske17Bis24(getKanalMaske17Bis24());
							klon.setKanalMaske25Bis32(getKanalMaske25Bis32());
							klon.setReserve01(getReserve01());
							klon.setReserve02(getReserve02());
							klon.setReserve03(getReserve03());
							klon.setReserve04(getReserve04());
							klon.setQx(getQx());
							klon.setVKfz(getVKfz());
							klon.setVPkw(getVPkw());
							klon.setVLkw(getVLkw());
							klon.setReserve05(getReserve05());
							klon.setAlpha1(getAlpha1());
							klon.setBeta1(getBeta1());
							klon.setAlpha2(getAlpha2());
							klon.setBeta2(getBeta2());
							klon.setK1(getK1());
							klon.setK2(getK2());
							klon.setZTtimo(getZTtimo());
							klon.setReserve06(getReserve06());
							klon.setDMax(getDMax());
							klon.setDGrenz(getDGrenz());
							klon.setReserve07(getReserve07());
							klon.setReserve08(getReserve08());
							klon.setReserve09(getReserve09());
							klon.setReserve10(getReserve10());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsLveParamProRichtungsBezogeneKenndaten";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdTlsLveParamProRichtungsBezogeneKenndaten(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
