/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter für Verkehrsstufen bei Zuflussregelung (FG 1 &#47; Typ 165 - Dürr).
<p>
&lt;sektion&gt;
                        &lt;titel&gt;FG 1: DE-Block-Struktur im Typ 165 "Parameter Verkehrsstufen"&lt;&#47;titel&gt;
                        &lt;absatz&gt;Wird verwendet mit ID 3 (Parameter) in Abruf- und Antwortrichtung oder mit ID 35
                            (Parametermeldung aus Puffer) in Antwortrichtung.
                        &lt;&#47;absatz&gt;
                        &lt;absatz&gt;Die Nachricht überträgt Parameter für Verkehrsstufen.
                        &lt;&#47;absatz&gt;
                    &lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class PdTlsLveParamProVerkehrsStufen extends AbstractParameterDatensatz<PdTlsLveParamProVerkehrsStufen.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsParameterVorgabeArchiv,
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.TlsVorgabeBedienung,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt für den Quittierungsmechanismus des Archivs. Wird alternativ zu asp.parameterVorgabe
						verwendet, wenn die Vorgabe indirekt nach der Archivierung durch das Archiv
						erfolgen soll.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsParameterVorgabeArchiv = new Aspekte("TlsVorgabeArchiv", "asp.tlsParameterVorgabeArchiv");
			
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * NICHT VERWENDEN. KANN JEDERZEIT WIEDER GELÖSCHT
						WERDEN. Aspekt für Vorgaben von einer Bedienung, die
						nicht wie die Parametersätze automatisch verschickt
						werden (z.B. Schaltdaten, dient zur Unterscheidung
						der Quelle).	 
			 *
			 * <p>
			 * NICHT VERWENDEN. KANN JEDERZEIT WIEDER GELÖSCHT
						WERDEN. Wird verwendet, wenn zusätzlich zum
						asp.tlsVorgabe weitere unterscheidbare Vorgaben
						benötigt werden. Vorgaben aus diesem Aspekt werden
						i. d. R. nicht direkt an die SS geschickt, sondern
						(z. B. über WAN-COM) an eine Zwischensschicht, um
						DaV-Systeme mit Altsystemen zu koppeln.
	         * </p>
			 */
			public static final Aspekt TlsVorgabeBedienung = new Aspekte("TlsVorgabeBedienung", "asp.tlsVorgabeBedienung");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
				 _hersteller
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
				 _dP2Ein
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
				 _dP4Ein
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vKfzP3Ein
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vKfzP4Ein
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 _reserve01
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 _reserve02
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 _reserve03
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 _reserve04
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 _reserve05
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 _reserve06
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Herstellercode: Dürr = 48.
			<p>
			
			</p>
			
			@return der Wert von Hersteller.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
				 getHersteller() {
				return _hersteller;
			}
		
			/**
			Herstellercode: Dürr = 48.
			<p>
			
			</p>
			
			@param _hersteller der neue Wert von Hersteller.
			*/
			public void setHersteller(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
			 _hersteller) {
				this._hersteller = _hersteller;
			}
		
			/**
			Einschaltschwellwert.
			<p>
			
			</p>
			
			@return der Wert von DP2Ein.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
				 getDP2Ein() {
				return _dP2Ein;
			}
		
			/**
			Einschaltschwellwert.
			<p>
			
			</p>
			
			@param _dP2Ein der neue Wert von DP2Ein.
			*/
			public void setDP2Ein(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
			 _dP2Ein) {
				this._dP2Ein = _dP2Ein;
			}
		
			/**
			Einschaltschwellwert.
			<p>
			
			</p>
			
			@return der Wert von DP4Ein.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
				 getDP4Ein() {
				return _dP4Ein;
			}
		
			/**
			Einschaltschwellwert.
			<p>
			
			</p>
			
			@param _dP4Ein der neue Wert von DP4Ein.
			*/
			public void setDP4Ein(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
			 _dP4Ein) {
				this._dP4Ein = _dP4Ein;
			}
		
			/**
			Einschaltschwellwert.
			<p>
			
			</p>
			
			@return der Wert von VKfzP3Ein.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVKfzP3Ein() {
				return _vKfzP3Ein;
			}
		
			/**
			Einschaltschwellwert.
			<p>
			
			</p>
			
			@param _vKfzP3Ein der neue Wert von VKfzP3Ein.
			*/
			public void setVKfzP3Ein(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vKfzP3Ein) {
				this._vKfzP3Ein = _vKfzP3Ein;
			}
		
			/**
			Einschaltschwellwert.
			<p>
			
			</p>
			
			@return der Wert von VKfzP4Ein.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVKfzP4Ein() {
				return _vKfzP4Ein;
			}
		
			/**
			Einschaltschwellwert.
			<p>
			
			</p>
			
			@param _vKfzP4Ein der neue Wert von VKfzP4Ein.
			*/
			public void setVKfzP4Ein(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vKfzP4Ein) {
				this._vKfzP4Ein = _vKfzP4Ein;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@return der Wert von Reserve01.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 getReserve01() {
				return _reserve01;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@param _reserve01 der neue Wert von Reserve01.
			*/
			public void setReserve01(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
			 _reserve01) {
				this._reserve01 = _reserve01;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@return der Wert von Reserve02.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 getReserve02() {
				return _reserve02;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@param _reserve02 der neue Wert von Reserve02.
			*/
			public void setReserve02(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
			 _reserve02) {
				this._reserve02 = _reserve02;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@return der Wert von Reserve03.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 getReserve03() {
				return _reserve03;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@param _reserve03 der neue Wert von Reserve03.
			*/
			public void setReserve03(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
			 _reserve03) {
				this._reserve03 = _reserve03;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@return der Wert von Reserve04.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 getReserve04() {
				return _reserve04;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@param _reserve04 der neue Wert von Reserve04.
			*/
			public void setReserve04(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
			 _reserve04) {
				this._reserve04 = _reserve04;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@return der Wert von Reserve05.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 getReserve05() {
				return _reserve05;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@param _reserve05 der neue Wert von Reserve05.
			*/
			public void setReserve05(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
			 _reserve05) {
				this._reserve05 = _reserve05;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@return der Wert von Reserve06.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
				 getReserve06() {
				return _reserve06;
			}
		
			/**
			ReserveByte für Erweiterungen.
			<p>
			
			</p>
			
			@param _reserve06 der neue Wert von Reserve06.
			*/
			public void setReserve06(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
			 _reserve06) {
				this._reserve06 = _reserve06;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getHersteller() != null) {
		                if (getHersteller().isZustand()) {
		                    datum.getUnscaledValue("Hersteller").setText(getHersteller().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Hersteller").set(getHersteller().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getDP2Ein() != null) {
		                if (getDP2Ein().isZustand()) {
		                    datum.getUnscaledValue("DP2Ein").setText(getDP2Ein().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("DP2Ein").set(getDP2Ein().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getDP4Ein() != null) {
		                if (getDP4Ein().isZustand()) {
		                    datum.getUnscaledValue("DP4Ein").setText(getDP4Ein().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("DP4Ein").set(getDP4Ein().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVKfzP3Ein() != null) {
		                if (getVKfzP3Ein().isZustand()) {
		                    datum.getUnscaledValue("VKfzP3Ein").setText(getVKfzP3Ein().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VKfzP3Ein").set(getVKfzP3Ein().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVKfzP4Ein() != null) {
		                if (getVKfzP4Ein().isZustand()) {
		                    datum.getUnscaledValue("VKfzP4Ein").setText(getVKfzP4Ein().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VKfzP4Ein").set(getVKfzP4Ein().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getReserve01() != null) {
		                if (getReserve01().isZustand()) {
		                    datum.getUnscaledValue("Reserve01").setText(getReserve01().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Reserve01").set(getReserve01().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getReserve02() != null) {
		                if (getReserve02().isZustand()) {
		                    datum.getUnscaledValue("Reserve02").setText(getReserve02().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Reserve02").set(getReserve02().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getReserve03() != null) {
		                if (getReserve03().isZustand()) {
		                    datum.getUnscaledValue("Reserve03").setText(getReserve03().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Reserve03").set(getReserve03().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getReserve04() != null) {
		                if (getReserve04().isZustand()) {
		                    datum.getUnscaledValue("Reserve04").setText(getReserve04().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Reserve04").set(getReserve04().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getReserve05() != null) {
		                if (getReserve05().isZustand()) {
		                    datum.getUnscaledValue("Reserve05").setText(getReserve05().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Reserve05").set(getReserve05().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getReserve06() != null) {
		                if (getReserve06().isZustand()) {
		                    datum.getUnscaledValue("Reserve06").setText(getReserve06().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Reserve06").set(getReserve06().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Hersteller").isState()) {
								setHersteller(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
								.getZustand(daten.getScaledValue("Hersteller").getText()));
							} else {
							setHersteller(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
							(daten.
								getUnscaledValue
							("Hersteller").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("DP2Ein").isState()) {
								setDP2Ein(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
								.getZustand(daten.getScaledValue("DP2Ein").getText()));
							} else {
							setDP2Ein(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
							(daten.
								getUnscaledValue
							("DP2Ein").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("DP4Ein").isState()) {
								setDP4Ein(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
								.getZustand(daten.getScaledValue("DP4Ein").getText()));
							} else {
							setDP4Ein(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
							(daten.
								getUnscaledValue
							("DP4Ein").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VKfzP3Ein").isState()) {
								setVKfzP3Ein(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("VKfzP3Ein").getText()));
							} else {
							setVKfzP3Ein(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("VKfzP3Ein").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VKfzP4Ein").isState()) {
								setVKfzP4Ein(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("VKfzP4Ein").getText()));
							} else {
							setVKfzP4Ein(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("VKfzP4Ein").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							setReserve01(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
							(daten.
								getUnscaledValue
							("Reserve01").
									shortValue
							()));
					// GanzzahlAttributTyp
							setReserve02(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
							(daten.
								getUnscaledValue
							("Reserve02").
									shortValue
							()));
					// GanzzahlAttributTyp
							setReserve03(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
							(daten.
								getUnscaledValue
							("Reserve03").
									shortValue
							()));
					// GanzzahlAttributTyp
							setReserve04(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
							(daten.
								getUnscaledValue
							("Reserve04").
									shortValue
							()));
					// GanzzahlAttributTyp
							setReserve05(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
							(daten.
								getUnscaledValue
							("Reserve05").
									shortValue
							()));
					// GanzzahlAttributTyp
							setReserve06(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg1pro.attribute.AttTlsLveProReserve
							(daten.
								getUnscaledValue
							("Reserve06").
									shortValue
							()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setHersteller(getHersteller());
							klon.setDP2Ein(getDP2Ein());
							klon.setDP4Ein(getDP4Ein());
							klon.setVKfzP3Ein(getVKfzP3Ein());
							klon.setVKfzP4Ein(getVKfzP4Ein());
							klon.setReserve01(getReserve01());
							klon.setReserve02(getReserve02());
							klon.setReserve03(getReserve03());
							klon.setReserve04(getReserve04());
							klon.setReserve05(getReserve05());
							klon.setReserve06(getReserve06());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsLveParamProVerkehrsStufen";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdTlsLveParamProVerkehrsStufen(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
