/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Jede Parktasche besteht aus ein bis max. vier Sensoren&#47;Detektoren.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTlsPupKorrekturParkTasche implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AtlTlsPupKorrekturSensor
			> _sensor = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AtlTlsPupKorrekturSensor
			>(4, true);
	
		/**
		Enthält Korrektur-Informationen zu einem Sensor&#47;Detektor in einer
		                    Parktasche.
		<p>
		
		</p>
		
		@return der Wert von Sensor.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AtlTlsPupKorrekturSensor
			> getSensor() {
			return _sensor;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arraySensor = datum.getArray("Sensor");
					arraySensor.setLength(getSensor().size());
					for (int i = 0; i < arraySensor.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AtlTlsPupKorrekturSensor
						 atl = getSensor().get(i);
						atl.bean2Atl(arraySensor.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arraySensor = daten.getArray("Sensor");
					for (int i = 0; i < arraySensor.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AtlTlsPupKorrekturSensor
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AtlTlsPupKorrekturSensor
						 ();
						atl.atl2Bean(arraySensor.getItem(i), factory);
						getSensor().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTlsPupKorrekturParkTasche clone() {
		AtlTlsPupKorrekturParkTasche klon = new AtlTlsPupKorrekturParkTasche();
		
					klon._sensor = getSensor().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
