/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Der Wert "Anzahl der Parkstandsreihen" überträgt die Anzahl der
                    nachfolgenden Parkstandsreihen. Jede Parkstandsreihe setzt sich aus zwei
                    Byte zusammen. Es können max. 109 Parkstandsreihen übertragen werden. Werden
                    mehr als 109 Parkstandsreihen benötigt, hat dies über eine neue DE-Adresse
                    zu erfolgen. Da max. 75 DEs in einem EAK zulässig sind (siehe Definition in
                    ANHANG 6, Teil 2, 2.2.10 - "DE-Zuordnung"), ergibt sich eine max. Kapazität
                    von 8066 Parkstandsreihen pro EAK (75 DEs - Cluster = 74 * 109
                    Parkstandsreihen = 8066 Parkstandsreihen).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTlsPupZustandParkStandsReihe implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupRestLaenge
			 _restLaenge
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupBelegungsZustand
			 _belegungsZustand
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupSensorDetektorStatus
			 _sensorDetektorStatus
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 _reserve
			;
	
		/**
		Restlänge einer Parkstandsreihe.
		<p>
		
		</p>
		
		@return der Wert von RestLaenge.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupRestLaenge
			 getRestLaenge() {
			return _restLaenge;
		}
	
		/**
		Restlänge einer Parkstandsreihe.
		<p>
		
		</p>
		
		@param _restLaenge der neue Wert von RestLaenge.
		*/
		public void setRestLaenge(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupRestLaenge
		 _restLaenge) {
			this._restLaenge = _restLaenge;
		}
	
		/**
		Belegungszustand einer Parkstandsreihe.
		<p>
		
		</p>
		
		@return der Wert von BelegungsZustand.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupBelegungsZustand
			 getBelegungsZustand() {
			return _belegungsZustand;
		}
	
		/**
		Belegungszustand einer Parkstandsreihe.
		<p>
		
		</p>
		
		@param _belegungsZustand der neue Wert von BelegungsZustand.
		*/
		public void setBelegungsZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupBelegungsZustand
		 _belegungsZustand) {
			this._belegungsZustand = _belegungsZustand;
		}
	
		/**
		Sensor-&#47;Detektorstatus einer Parkstandsreihe.
		<p>
		
		</p>
		
		@return der Wert von SensorDetektorStatus.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupSensorDetektorStatus
			 getSensorDetektorStatus() {
			return _sensorDetektorStatus;
		}
	
		/**
		Sensor-&#47;Detektorstatus einer Parkstandsreihe.
		<p>
		
		</p>
		
		@param _sensorDetektorStatus der neue Wert von SensorDetektorStatus.
		*/
		public void setSensorDetektorStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupSensorDetektorStatus
		 _sensorDetektorStatus) {
			this._sensorDetektorStatus = _sensorDetektorStatus;
		}
	
		/**
		Reserve-Bit.
		<p>
		
		</p>
		
		@return der Wert von Reserve.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 getReserve() {
			return _reserve;
		}
	
		/**
		Reserve-Bit.
		<p>
		
		</p>
		
		@param _reserve der neue Wert von Reserve.
		*/
		public void setReserve(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
		 _reserve) {
			this._reserve = _reserve;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getRestLaenge() != null) {
	                if (getRestLaenge().isZustand()) {
	                    datum.getUnscaledValue("RestLänge").setText(getRestLaenge().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("RestLänge").set(getRestLaenge().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getBelegungsZustand() != null) {
	                if (getBelegungsZustand().isZustand()) {
	                    datum.getUnscaledValue("BelegungsZustand").setText(getBelegungsZustand().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("BelegungsZustand").set(getBelegungsZustand().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getSensorDetektorStatus() != null) {
	                if (getSensorDetektorStatus().isZustand()) {
	                    datum.getUnscaledValue("SensorDetektorStatus").setText(getSensorDetektorStatus().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("SensorDetektorStatus").set(getSensorDetektorStatus().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getReserve() != null) {
	                if (getReserve().isZustand()) {
	                    datum.getUnscaledValue("Reserve").setText(getReserve().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Reserve").set(getReserve().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("RestLänge").isState()) {
							setRestLaenge(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupRestLaenge
							.getZustand(daten.getScaledValue("RestLänge").getText()));
						} else {
						setRestLaenge(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupRestLaenge
						(daten.
							getUnscaledValue
						("RestLänge").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("BelegungsZustand").isState()) {
							setBelegungsZustand(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupBelegungsZustand
							.getZustand(daten.getScaledValue("BelegungsZustand").getText()));
						} else {
						setBelegungsZustand(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupBelegungsZustand
						(daten.
							getUnscaledValue
						("BelegungsZustand").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("SensorDetektorStatus").isState()) {
							setSensorDetektorStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupSensorDetektorStatus
							.getZustand(daten.getScaledValue("SensorDetektorStatus").getText()));
						} else {
						setSensorDetektorStatus(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupSensorDetektorStatus
						(daten.
							getUnscaledValue
						("SensorDetektorStatus").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						setReserve(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
						(daten.
							getUnscaledValue
						("Reserve").
								shortValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTlsPupZustandParkStandsReihe clone() {
		AtlTlsPupZustandParkStandsReihe klon = new AtlTlsPupZustandParkStandsReihe();
		
						klon.setRestLaenge(getRestLaenge());
						klon.setBelegungsZustand(getBelegungsZustand());
						klon.setSensorDetektorStatus(getSensorDetektorStatus());
						klon.setReserve(getReserve());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
