/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition der Übertragungsverfahren FG210 Typ32.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Wertebereich(
	minimum = 0L,
	maximum = 15L,
	einheit = ""
)
public class AttTlsPupUebertragungsVerfahren extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Byte
	 MIN_VALUE =
				Byte
		.valueOf("0");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Byte
	 MAX_VALUE =
				Byte
		.valueOf("15");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupUebertragungsVerfahren ZUSTAND_0_MELDUNG_NUR_NACH_ABRUF = new AttTlsPupUebertragungsVerfahren("Meldung nur nach Abruf", 		Byte
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupUebertragungsVerfahren ZUSTAND_1_ZYKLISCHE_ABGABE_VON_MELDUNGEN = new AttTlsPupUebertragungsVerfahren("zyklische Abgabe von Meldungen", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupUebertragungsVerfahren ZUSTAND_2_NACH_ZUSTANDSAENDERUNG = new AttTlsPupUebertragungsVerfahren("nach Zustandsänderung", 		Byte
	.valueOf("2"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsPupUebertragungsVerfahren getZustand(final 		Byte
	 value) {
		for (AttTlsPupUebertragungsVerfahren e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsPupUebertragungsVerfahren getZustand(final String value) {
		for (AttTlsPupUebertragungsVerfahren e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsPupUebertragungsVerfahren> getZustaende() {
		List<AttTlsPupUebertragungsVerfahren> list = new ArrayList<AttTlsPupUebertragungsVerfahren>();
		list.add(ZUSTAND_0_MELDUNG_NUR_NACH_ABRUF);
		list.add(ZUSTAND_1_ZYKLISCHE_ABGABE_VON_MELDUNGEN);
		list.add(ZUSTAND_2_NACH_ZUSTANDSAENDERUNG);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TlsPupÜbertragungsVerfahren.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsPupUebertragungsVerfahren(final 		Byte
	 value) {
		super(value);
	}
	
	private AttTlsPupUebertragungsVerfahren(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
