/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition der Version der Ergebnismeldung FG210 Typ32. Die Versionsnummer
                    bestimmt die Ergebnismeldung der Parkplatzbelegung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Wertebereich(
	minimum = 0L,
	maximum = 7L,
	einheit = ""
)
public class AttTlsPupVersionErgebnisMeldung extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Byte
	 MIN_VALUE =
				Byte
		.valueOf("0");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Byte
	 MAX_VALUE =
				Byte
		.valueOf("7");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupVersionErgebnisMeldung ZUSTAND_0_VERSION_0 = new AttTlsPupVersionErgebnisMeldung("Version 0", 		Byte
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupVersionErgebnisMeldung ZUSTAND_1_VERSION_1 = new AttTlsPupVersionErgebnisMeldung("Version 1", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupVersionErgebnisMeldung ZUSTAND_2_VERSION_2 = new AttTlsPupVersionErgebnisMeldung("Version 2", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupVersionErgebnisMeldung ZUSTAND_3_VERSION_3 = new AttTlsPupVersionErgebnisMeldung("Version 3", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupVersionErgebnisMeldung ZUSTAND_4_VERSION_4 = new AttTlsPupVersionErgebnisMeldung("Version 4", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupVersionErgebnisMeldung ZUSTAND_5_VERSION_5 = new AttTlsPupVersionErgebnisMeldung("Version 5", 		Byte
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsPupVersionErgebnisMeldung ZUSTAND_6_VERSION_6 = new AttTlsPupVersionErgebnisMeldung("Version 6", 		Byte
	.valueOf("6"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsPupVersionErgebnisMeldung getZustand(final 		Byte
	 value) {
		for (AttTlsPupVersionErgebnisMeldung e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsPupVersionErgebnisMeldung getZustand(final String value) {
		for (AttTlsPupVersionErgebnisMeldung e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsPupVersionErgebnisMeldung> getZustaende() {
		List<AttTlsPupVersionErgebnisMeldung> list = new ArrayList<AttTlsPupVersionErgebnisMeldung>();
		list.add(ZUSTAND_0_VERSION_0);
		list.add(ZUSTAND_1_VERSION_1);
		list.add(ZUSTAND_2_VERSION_2);
		list.add(ZUSTAND_3_VERSION_3);
		list.add(ZUSTAND_4_VERSION_4);
		list.add(ZUSTAND_5_VERSION_5);
		list.add(ZUSTAND_6_VERSION_6);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TlsPupVersionErgebnisMeldung.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsPupVersionErgebnisMeldung(final 		Byte
	 value) {
		super(value);
	}
	
	private AttTlsPupVersionErgebnisMeldung(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
