/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Datenendgerätekanal der Funktionsgruppe 210 (Parken und Parkplatzüberwachung).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface DePup extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.De
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.dePup"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Legt fest, ob entsprechend implementierte Umsetzungsscripte Betriebsmeldungen erzeugen und
						versenden.
	<p>
	
	</p>
	@return der Datensatz TlsBetriebsMeldungErzeugen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsBetriebsMeldungErzeugen getPdTlsBetriebsMeldungErzeugen();
	
	/**
	Ergebnismeldung Fahrzeugidentifikation (Parken und Parkplatzüberwachung - FG 210 &#47; Typ 63).
	<p>
	&lt;sektion&gt;
	                        &lt;titel&gt;
	                            FG 210: TLS-DE-Block-Struktur im Typ 63 "Ergebnismeldung Fahrzeugidentifikation"
	                        &lt;&#47;titel&gt;
	                        &lt;absatz&gt;
	                            Wird verwendet mit ID 4 (Ergebnisse) in Antwortrichtung.
	                        &lt;&#47;absatz&gt;
	                        &lt;absatz&gt;Mit Hilfe von Sensoren und Detektoren (z.B. Induktionsschleifen,
	                            Videodetektion) werden Profile von Fahrzeugen (z.B. beim Ein- oder
	                            Ausfahren auf den Parkplatz) ermittelt. Jedem Fahrzeug&#47;Profil wird eine
	                            eindeutige ID- Nummer zugeordnet. Sollte das Fahrzeug erneut beim
	                            Durchqueren einer Identifikationsstelle auf dem Parkplatz erkannt
	                            werden, bekommt es wieder die gleiche ID- Nummer zugeordnet. Jede
	                            Identifikation eines Fahrzeuges auf den Parkplatz wird an die Zentrale
	                            gemeldet. Ein Profil verliert 72 Stunden nach seiner letzten Detektion
	                            seine Gültigkeit und die zugehörige ID- Nummer wird wieder freigegeben.
	                            Anhand der Detektionsdaten (z.B.: erste- und letzte Detektion) kann
	                            später in der Zentrale die Verweildauer einzelner Fahrzeuge ermittelt
	                            werden.
	                        &lt;&#47;absatz&gt;
	                    &lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsPupFahrzeugIdentifikation.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.onlinedaten.OdTlsPupFahrzeugIdentifikation getOdTlsPupFahrzeugIdentifikation();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Korrektur der Parktaschenbelegung (Parken und Parkplatzüberwachung - FG
	                    210 &#47; Typ 37).
	<p>
	&lt;sektion&gt;
	                        &lt;titel&gt;FG 210: DE-Block-Struktur im Typ 37 "Korrektur der
	                            Parktaschenbelegung"
	                        &lt;&#47;titel&gt;
	                        &lt;absatz&gt;Wird verwendet mit ID 3 (Parameter) in Abrufrichtung.
	                        &lt;&#47;absatz&gt;
	                        &lt;absatz&gt;Die Nachricht überträgt die Korrektur der Parktaschenbelegung. Als
	                            Antworttelegramm wird der DE-Block mit der aktuell eingestellten
	                            Versionsnummer (z.B. "Ergebnismeldung Parkplatzbelegung Version 0")
	                            gesendet. Überwacht das DE keine Parktaschen, wird eine negative
	                            Quittung (Fehlerursache 8) gesendet.
	                        &lt;&#47;absatz&gt;
	                        &lt;absatz&gt;Jede Parktasche besteht aus ein bis max. vier Sensoren&#47;Detektoren.
	                            Auf Grund der begrenzten Kapazität von max. 109 Parktaschen
	                            (Anwendungsfall: jeweils eine Parktasche mit einem Sensor&#47;Detektor) pro
	                            DE-Block, wird dieser DE-Typ in der Regel mehrmals pro EAK verwendet. Da
	                            max. 75 DEs in einem EAK zulässig sind (siehe Definition in ANHANG 6,
	                            Teil 2, 2.2.10 - "DE-Zuordnung"), ergibt sich eine max. Kapazität von
	                            8066 Parktaschen pro EAK (75 DEs - Cluster = 74 * 109 Parktaschen = 8066
	                            Parktaschen).
	                        &lt;&#47;absatz&gt;
	                        &lt;absatz&gt;Nach der Korrektur einer oder mehrere Parktaschen&#47;Sensoren (Soll
	                            ungleich Ist), darf auf dieser Parktasche ein hardwarebedingtes Update,
	                            erst nach einem Zustandswechsel von "belegt" (01h) auf "nicht belegt"
	                            (00h) bzw. umgekehrt erfolgen.
	                        &lt;&#47;absatz&gt;
	                    &lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsPupKorrekturParkTaschenBelegung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.onlinedaten.OdTlsPupKorrekturParkTaschenBelegung getOdTlsPupKorrekturParkTaschenBelegung();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz De.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.konfigurationsdaten.KdDe getKdDe();
	
	/**
	Betriebsparameter (Parken und Parkplatzüberwachung - FG 210 &#47; Typ 32).
	<p>
	&lt;sektion&gt;
	                        &lt;titel&gt;FG 210: DE-Block-Struktur im Typ 32 "Betriebsparameter"&lt;&#47;titel&gt;
	                        &lt;absatz&gt;Wird verwendet mit ID 3 (Parameter) in Abruf- und Antwortrichtung
	                            oder mit ID 35 (Parametermeldung aus Puffer) in Antwortrichtung.
	                        &lt;&#47;absatz&gt;
	                        &lt;absatz&gt;Die Nachricht überträgt Betriebsparameter, welche für die
	                            Generierung der Betriebsmeldungen benötigt werden.
	                        &lt;&#47;absatz&gt;
	                    &lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsPupBetriebsParameter.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.parameter.PdTlsPupBetriebsParameter getPdTlsPupBetriebsParameter();
	
	/**
	Ergebnismeldung Freie Parkplatzbereiche(Parken und Parkplatzüberwachung - FG 210 &#47; Typ 60).
	<p>
	&lt;sektion&gt;
	                        &lt;titel&gt;
	                            FG 210: TLS-DE-Block-Struktur im Typ 60 "Freie Parkplatzbereiche"
	                        &lt;&#47;titel&gt;
	                        &lt;absatz&gt;
	                            Wird verwendet mit ID 4 (Ergebnisse) in Antwortrichtung.
	                        &lt;&#47;absatz&gt;
	                        &lt;absatz&gt;Die Nachricht überträgt die freien Parkplatzbereiche. Lassen sich
	                            (z. B. aufgrund von Sensor- oder Detektorfehlern) einzelne Werte des
	                            Blockes nicht ermitteln, ohne dass ein Totalausfall des DE vorliegt,
	                            werden die betroffenen Bytes auf den Wert 255 (65535) gesetzt.
	                        &lt;&#47;absatz&gt;
	                    &lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsPupFreieParkPlatzBereiche.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.onlinedaten.OdTlsPupFreieParkPlatzBereiche getOdTlsPupFreieParkPlatzBereiche();
	
	/**
	Kanalsteuerung (FG alle &#47; Typ 29).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 1: DE-Block-Struktur im Typ
								29"Kanalsteuerung"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 2 (Statusnachrichten)
								in Abruf- und Antwortrichtung oder mit ID 34
								(Statusnachricht aus Puffer) in
								Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Der DE-Block"Kanalsteuerung" beeinflusst die
								Betriebsweise eines DEs. Bisher sind nur die
								beiden Betriebsweisen"Normalbetrieb"
								und"Passiv" vorgesehen. Über die
								Betriebsweise"Passiv" ist das Passivieren
								eines Kanals möglich.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Funktion ist grundsätzlich für alle DEs
								vorgesehen, mit Ausnahme der Systemkanäle
								(FG 254). Sie dient insbesondere zum
								Abschalten von Kanälen, die Flattermeldungen
								produzieren oder aufgrund von Baustellen
								etc. nicht verwendet werden. Der
								Zustand"Passiv" muss spannungsausfallsicher
								abgelegt sein. Reaktionen eines passivierten
								Kanals (
								&lt;verweis pid="KanalsteuerungFG4" txt="Spezielles Verhalten in der FG4"&gt;&lt;&#47;verweis&gt;
	
								):
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- spontan entstehende DE-Fehlermeldung (Typ
								1): keine Reaktion
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- DE-Fehlermeldung (Typ 1) im
								Initialisierungsablauf normale Meldung
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Abfrage DE-Fehlermeldungen (Typ 1):
								normale Antwort
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Fehlermeldung im Initialisierungsablauf
								(außer Typ 1) keine Reaktion
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- spontan entstehende Fehlermeldung keine
								Reaktion
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Abfrage Fehlermeldungen (außer Typ 1)
								keine Reaktion1
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- spontan entstehende Anwenderdaten keine
								Reaktion
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Anwenderdaten im Initialisierungsablauf 2
								keine Reaktion
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Abfrage Anwenderdaten keine Reaktion1
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Befehle Anwenderdaten2 keine Antwort,
								keine Ausführung3
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Statusnachricht Kanalsteuerung normale
								Antwort und Ausführung
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Zuweisung und Abfrage Parameterdaten
								normale Antwort und Ausführung
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Einstellung des Kanalsteuerbytes erfolgt
								mit einem Kanalsteuerbefehl (ID 2, Typ 29),
								der mit Rückmeldung (ID 2, Typ 29)
								beantwortet wird. Die Meldung kann auch mit
								ID 18, Typ 29 abgefragt werden. Um die
								relevanten Kanalinformationen an einer
								Stelle zur Verfügung zu haben, wird das
								Passivierungsbit zusätzlich in der
								DE-Fehlermeldung übertragen.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								&lt;wichtig&gt;
									&lt;anker pid="KanalsteuerungFG4"&gt;&lt;&#47;anker&gt;
	
									Spezielles Verhalten in der FG4
								&lt;&#47;wichtig&gt;
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Verhalten beim Passivieren von DEs in der FG
								4:
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Der Wzg&#47;WWW wird ausgeschaltet oder das
								Rollo geschlossen. Bei Wzgs&#47;WWWs mit
								Prismentechnik wird, falls vorhanden, die
								Neutralstellung eingestellt. Die
								Stellzustandsänderung wird spontan zur UZ
								gesendet.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Verhalten von passivierten DEs in der FG 4:
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								1. An passivierte DEs wird im Autarkbetrieb
								keine Grundeinstellung ausgegeben, d.h. sie
								bleiben im Zustand"Aus" oder"Rollo
								geschlossen".
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								2. Befehle an passivierte Kanäle werden
								ausgeführt. Dadurch sind passive DEs
								schaltbar.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								3. Passivierte DEs senden immer ihre
								spontanen Meldungen, unabhängig vom
								Identifier und auch während der
								Initialisierung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Somit ist das Verhalten passiver und aktiver
								Kanäle - außer im Autarkbetrieb - gleich.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Verhalten beim Aktivieren von passivierten
								DEs in der FG 4:
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Beim Aktivieren wird der Stellzustand des
								zugehörigen Wzgs&#47;WWWs vom EAK nicht
								verändert. Im Falle"Kommunikationsstatus
								lebt" werden DE-Fehlermeldung (Typ 1, ID 1)
								und bei"DE ok" abhängig von der Technologie
								der Zeichen nicht darstellbare WVZ (ID 1,
								Typ 2), defekte Lampen (ID 1, Typ 3) oder
								gestörte Textpositionen (ID 1, Typ 4) und
								der Stellzustand (ID 5, Typ 55, bei
								Altanlagen auch 48,50,58) gesendet. Im
								Falle"Kommunikationsstatus tot" wird die
								Grundeinstellung ausgegeben.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Ansonsten gilt entsprechend die Definition
								in Anhang 6, Teil 2, Kapitel 3.2.5.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsGloKanalSteuerung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsGloKanalSteuerung getPdTlsGloKanalSteuerung();
	
	/**
	Negative Quittung (Parken und Parkplatzüberwachung - FG 210 &#47; Typ 16).
	<p>
	&lt;sektion&gt;
	                        &lt;titel&gt;
	                            FG 210: DE-Block-Struktur im Typ 16 "Negative Quittung"
	                        &lt;&#47;titel&gt;
	                        &lt;absatz&gt;
	                            Wird verwendet mit ID 2 (Statusnachrichten) in Antwortrichtung.
	                        &lt;&#47;absatz&gt;
	                        &lt;absatz&gt;
	                            Mit der "Negativen Quittung" antwortet ein DE auf eine Nachricht, die an
	                            sie korrekt adressiert ist, aber deren Inhalt von ihr nicht eindeutig
	                            ausgewertet werden kann.
	                        &lt;&#47;absatz&gt;
	                        &lt;absatz&gt;
	                            Die Negative Quittung wird mit ID 2 und Typ 16 gesendet, enthält also
	                            keinen Hinweis auf die ID und den Typ der verursachenden Nachricht.
	                            Diese Zuordnung wird über die Jobnummer hergestellt, welche identisch
	                            mit der der fehlerhaften Nachricht in Abrufrichtung ist.
	                        &lt;&#47;absatz&gt;
	                    &lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsPupNegativeQuittung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.onlinedaten.OdTlsPupNegativeQuittung getOdTlsPupNegativeQuittung();
	
	/**
	Abfragetelegramm für einen DE-Block.
	<p>
	
	</p>
	@return der Datensatz TlsGloDeBlockAbruf.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeBlockAbruf getOdTlsGloDeBlockAbruf();
	
	/**
	Ermöglich das Senden eines (beliegigen) DE-Blocks.
	<p>
	
	</p>
	@return der Datensatz TlsGloDeBlockSenden.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeBlockSenden getOdTlsGloDeBlockSenden();
	
	/**
	DE-Fehler (FG alle &#47; Typ 1).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG alle (ausser FG 254): DE-Block-Struktur
								im Typ 1"DE-Fehlermeldung"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 1 (Fehler) in
								Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die DE-Fehlermeldung informiert die Zentrale
								über den Betriebszustand eines DE. Die
								Nachricht wird vom E&#47;AKonzentrator oder vom
								SM erzeugt. Es sind folgende zwei Fälle
								unterscheidbar:
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								1.) Es sind ein oder mehrere Kanäle des
								E&#47;A-Konzentrators defekt, die Kommunikation
								des E&#47;A-Konzentrators ist jedoch noch
								funktionsfähig.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Folge: Bei Eintritt der Störung sendet der
								E&#47;A-Konzentrator eine Nachricht mit je einem
								DE-Block pro gestörtem Kanal und Fehlercode
								Bit 0 = 1. Auf Abfrage antworten
								betriebsbereite Kanäle mit Fehlercode Bit 0
								= 0, defekte Kanäle antworten mit Fehlercode
								Bit 0 = 1.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								2.) Der E&#47;A-Konzentrator ist so defekt, dass
								die Kommunikation zum SM nicht mehr
								funktioniert.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Folge: Der SM generiert bei Eintritt der
								Störung anhand seiner Konfigurationsliste je
								eine Nachricht pro FG des E&#47;AKonzentrators
								mit je einem DE-Block pro vorhandenem DE und
								Fehlercode Bit 1 = 1. Auf Abfrage antworten
								betriebsbereite Kanäle mit Fehlercode Bit
								0..2 = 0, defekte Kanäle antworten mit
								Fehlercode Bit 1 = 1.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Ist ein Fehler aufgetreten, der weiterhin
								einen eingeschränkten Betrieb der DE
								zulässt, so ist dieser Teilausfall nicht
								durch ein gesetztes Fehlercode-Bit 0 oder 1
								auszudrücken.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Vielmehr ist dieser Ausfall durch die
								ergänzende DE-Fehlermeldung Typ 14 der
								Zentrale mitzuteilen. Abrufe der
								Fehlermeldung reicht der SM an den
								E&#47;A-Konzentrator weiter, wenn dieser mit dem
								SM kommunizieren kann, andernfalls
								beantwortet sie der SM selbst.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Eine Kopie des Passiv-Bits, welches für
								jeden Kanal mit dem Kanalsteuerbefehl
								eingestellt werden kann, wird in der
								DE-Fehlermeldung mit übertragen. Dies
								erspart eine zusätzliche Abfrage bzw.
								Antwortnachricht des Kanalsteuerbytes, um
								den vollständigen Kanalzustand zu erfahren
								(Siehe auch Kapitel 3.2.5 Kanalsteuerung).
								Dieses Bit ist jedoch nur gültig, wenn die
								Fehlernachricht vom E&#47;A-Konzentrator erzeugt
								wird, jedoch nicht, wenn das Stö&#47;SM = 1 ist.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
						&lt;sektion&gt;
							&lt;titel&gt;
								FG 254: DE-Block-Struktur im Typ
								1"DE-Fehlermeldung"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 1 (Fehler) in
								Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die DE-Fehlermeldung informiert die Zentrale
								über den Betriebszustand eines DE. Sie wird
								sowohl für die anwendungsbezogenen DEs als
								auch für die hardwarezugeordneten DEs (DE
								entspricht E&#47;A-Konzentrator unter FG 254)
								verwendet. Das Störungsereignis wird der
								Zentrale primär über die anwendungsbezogenen
								DE-Fehlermeldungen (FG 1..253) mitgeteilt.
								Die Nachricht wird vom E&#47;A-Konzentrator oder
								vom SM erzeugt. Es sind folgende zwei Fälle
								unterscheidbar:
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								1.) Es sind Teile des E&#47;A-Konzentrators
								defekt, die Kommunikation zum SM ist jedoch
								noch funktionsfähig. Folge: Die
								Systemsteuerung des E&#47;A-Konzentrators sendet
								eine Nachricht mit ihrer DE-Nummer und
								Fehlercode Bit 0 = 1.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								2.) Der E&#47;A-Konzentrator ist so defekt, dass
								die Kommunikation zum SM nicht mehr
								funktioniert.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Folge: Der SM generiert eine Nachricht mit
								der DE des E&#47;A-Konzentrators und Fehlercode
								Bit 1 = 1. Abrufe der Fehlermeldung reicht
								der SM an den E&#47;A-Konzentrator weiter, wenn
								dieser mit dem SM kommunizieren kann,
								andernfalls beantwortet sie der SM selbst.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Weitergehende Informationen siehe [TLS2002].
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsGloDeFehler.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeFehler getOdTlsGloDeFehler();
	
	/**
	Legt fest, ob entsprechend implementierte Umsetzungsscripte der KExTLS ausgeführt werden
						oder nicht. Wird i.d.R. dazu verwendet, dass die Umsetzungscripte auf das logische Modell (FS,
						Umfelddaten) zu Testzwecken ausgeschaltet werden können.
	<p>
	
	</p>
	@return der Datensatz TlsPassivierungUebernahmeLogischesModell.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsPassivierungUebernahmeLogischesModell getPdTlsPassivierungUebernahmeLogischesModell();
	
	/**
	Ergänzende DE-Fehlermeldung (Parken und Parkplatzüberwachung - FG 210 &#47; Typ 14).
	<p>
	&lt;sektion&gt;
	                        &lt;titel&gt;
	                            FG 210: DE-Block-Struktur im Typ 14 "Ergänzende DE-Fehlermeldung"
	                        &lt;&#47;titel&gt;
	                        &lt;absatz&gt;
	                            Wird verwendet mit ID 1 (Fehler) in Antwortrichtung.
	                        &lt;&#47;absatz&gt;
	                        &lt;absatz&gt;
	                            Dieser DE-Block dient zur Meldung von Teilstörungen und näheren
	                            Erläuterung von Störungen, die mit dem DEBlock Typ 1 gemeldet werden.
	                            Bei reinen Teilstörungen wird nur der DE-Block 14 gesendet; bei
	                            Erläuterungen von spontanen Störungsmeldungen wird er in einem Telegramm
	                            mit dem DE-Block Typ 1 gesendet. Er kann aber mit der ID 17 in
	                            Abrufrichtung einzeln abgerufen werden.
	                        &lt;&#47;absatz&gt;
	                        &lt;absatz&gt;
	                            Mit dem DE-Block können unterschiedliche Störungen&#47;Teilstörungen
	                            gleichzeitig gemeldet werden. Ändert sich der Status (weitere Störungen
	                            bzw. Behebung von Störungen) wird ebenfalls DE-Block-Typ 14 gesendet.
	                        &lt;&#47;absatz&gt;
	                        &lt;absatz&gt;
	                            Weitergehende Informationen siehe [TLS2012].
	                        &lt;&#47;absatz&gt;
	                    &lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsPupErgaenzendeDeFehlerMeldung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.onlinedaten.OdTlsPupErgaenzendeDeFehlerMeldung getOdTlsPupErgaenzendeDeFehlerMeldung();
	
	/**
	Geographische Kenndaten (FG alle &#47; Typ 36).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 254: DE-Block-Struktur im Typ
								36"Geographische Kenndaten"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 3 (Parameter) in
								Abruf- und Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Meldung der geographischen Kenndaten
								dient dazu, die Lage der Streckenstation
								bzw. von Funktionsgruppen im Straßennetz
								durch Fernabruf überprüfbar zu machen. Dies
								kann insbesondere nach baulicher Änderung
								der Netzstruktur oder bei Inbetriebnahme von
								Zentralen hilfreich sein.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Dieses Datenfeld kann ein- oder mehrfach pro
								Streckenstation vorhanden sein. Es wird
								ausfallsicher gespeichert. Ist es nur einmal
								vorhanden, wird es über FG 254, DE 0 als
								Teil der Systemsteuerung im SM abgefragt.
								Dies ist der Standardfall. Optional kann das
								Datenfeld bei räumlich auseinanderliegenden
								Funktionsgruppen auch im EAK angelegt
								werden. Die Abfrage kann dann über einen
								beliebigen DE erfolgen. Eine weitere Option
								im EAK besteht darin, jedem DE ein
								unterschiedliches Datenfeld zuzuordnen, wenn
								dies für räumlich abgesetzte DEs
								erforderlich sein sollte.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die geographischen Kenndaten werden i.d.R.
								vor Ort eingegeben und von der Zentrale nur
								gelesen.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsGloGeographischeKenndaten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloGeographischeKenndaten getOdTlsGloGeographischeKenndaten();
	
	/**
	Ergebnismeldung Belegung der Parkstandsreihen (Parken und Parkplatzüberwachung - FG 210 &#47; Typ 62).
	<p>
	&lt;sektion&gt;
	                        &lt;titel&gt;
	                            FG 210: TLS-DE-Block-Struktur im Typ 62 "Belegung der Parkstandsreihen"
	                        &lt;&#47;titel&gt;
	                        &lt;absatz&gt;
	                            Wird verwendet mit ID 4 (Ergebnisse) in Antwortrichtung.
	                        &lt;&#47;absatz&gt;
	                        &lt;absatz&gt;Die Übertragung der Belegung der Parkstandsreihen (Status,
	                            Belegungszustand und Restlänge) geschieht nur spontan nach
	                            "Meldeintervall der Parkstandsreihen" (siehe DE-Block Typ33,
	                            AddOn-Parameter). Die Daten können nicht ab-gerufen werden. Dieser
	                            DE-Block muss immer mit Zeitstempel Typ 30 gesendet werden. Lassen sich
	                            (z. B. aufgrund von Sensor- oder Detektorfehlern) einige Restlängen bzw.
	                            Belegungszustände von Parkstandsreihen nicht ermitteln, ohne dass ein
	                            Totalausfall des Systems vorliegt, werden die betroffenen Restlängen auf
	                            den Wert 2047 (7FFh) bzw. für den Belegungszustand auf den Wert 3 (3h)
	                            gesetzt.
	                        &lt;&#47;absatz&gt;
	                    &lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsPupBelegungParkStandsReihen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.onlinedaten.OdTlsPupBelegungParkStandsReihen getOdTlsPupBelegungParkStandsReihen();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Ergebnismeldung Parkplatzbelegung für die Versionen 1-5 (Parken und
	                    Parkplatzüberwachung - FG 210 &#47; Typ 49-53).
	<p>
	&lt;sektion&gt;
	                        &lt;titel&gt;FG 210: DE-Block-Struktur im Typ 49-53 "Ergebnismeldung
	                            Parkplatzbelegung"
	                        &lt;&#47;titel&gt;
	                        &lt;absatz&gt;Wird verwendet mit ID 4 (Ergebnisse) in Antwortrichtung.
	                        &lt;&#47;absatz&gt;
	                        &lt;absatz&gt;Die Nachricht überträgt die Anzahl der sich aktuell auf dem
	                            Parkplatz befindlichen Kraftfahrzeuge. Lassen sich (z. B. aufgrund von
	                            Sensor- oder Detektorfehlern) einzelne Werte des Blockes nicht
	                            ermitteln, ohne dass ein Totalausfall des DE vorliegt, werden die
	                            betroffenen Bytes auf den Wert 255 (65535) gesetzt.
	                        &lt;&#47;absatz&gt;
	                    &lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsPupParkPlatzBelegungVersion1Bis5.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.onlinedaten.OdTlsPupParkPlatzBelegungVersion1Bis5 getOdTlsPupParkPlatzBelegungVersion1Bis5();
	
	/**
	Ergebnismeldung Freie Parkplatzbereichszonen (Parken und Parkplatzüberwachung - FG 210 &#47; Typ 61).
	<p>
	&lt;sektion&gt;
	                        &lt;titel&gt;
	                            FG 210: TLS-DE-Block-Struktur im Typ 61 "Freie Parkplatzbereichszonen"
	                        &lt;&#47;titel&gt;
	                        &lt;absatz&gt;
	                            Wird verwendet mit ID 4 (Ergebnisse) in Antwortrichtung.
	                        &lt;&#47;absatz&gt;
	                        &lt;absatz&gt;Die Nachricht überträgt die freien Parkplatzbereichszonen. Lassen
	                            sich (z. B. aufgrund von Sensor- oder Detektorfehlern) einzelne Werte
	                            des Blockes nicht ermitteln, ohne dass ein Totalausfall des DE vorliegt,
	                            werden die betroffenen Bytes auf den Wert 255 (65535) gesetzt.
	                        &lt;&#47;absatz&gt;
	                    &lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsPupFreieParkPlatzBereichsZonen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.onlinedaten.OdTlsPupFreieParkPlatzBereichsZonen getOdTlsPupFreieParkPlatzBereichsZonen();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Ergebnismeldung Korrektur der Parkplatzbelegung (Parken und
	                    Parkplatzüberwachung - FG 210 &#47; Typ 38).
	<p>
	&lt;sektion&gt;
	                        &lt;titel&gt;FG 210: DE-Block-Struktur im Typ 38 "korrektur der
	                            Parkplatzbelegung"
	                        &lt;&#47;titel&gt;
	                        &lt;absatz&gt;Wird verwendet mit ID 3 (Parameter) in Abrufrichtung.
	                        &lt;&#47;absatz&gt;
	                        &lt;absatz&gt;Die Nachricht überträgt den Korrekturfaktor der Parkplatzbelegung
	                            bzw. den Absolutbetrag an Fahrzeugen für eine Fahrzeugklasse. Als
	                            Antworttelegramm wird der DE-Block mit der aktuell eingestellten
	                            Versionsnummer (z.B. "Ergebnismeldung Parkplatzbelegung Version 1",
	                            "...2", "...") gesendet.
	                        &lt;&#47;absatz&gt;
	                    &lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsPupKorrekturParkPlatzBelegung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.onlinedaten.OdTlsPupKorrekturParkPlatzBelegung getOdTlsPupKorrekturParkPlatzBelegung();
	
	/**
	Enthält die Ermittlung der Fehlerursache in der TLS
						Kommunikation, die aufgrund von Messwertausfällen
						ermittelt wurden.
	<p>
	
	</p>
	@return der Datensatz TlsFehlerAnalyse.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsFehlerAnalyse getOdTlsFehlerAnalyse();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz DePup.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.konfigurationsdaten.KdDePup getKdDePup();
	
	/**
	Ergebnismeldung Parkplatzbelegung für die Versionen 0 (Parken und
	                    Parkplatzüberwachung - FG 210 &#47; Typ 48).
	<p>
	&lt;sektion&gt;
	                        &lt;titel&gt;FG 210: DE-Block-Struktur im Typ 48 "Ergebnismeldung
	                            Parkplatzbelegung"
	                        &lt;&#47;titel&gt;
	                        &lt;absatz&gt;Wird verwendet mit ID 4 (Ergebnisse) in Antwortrichtung.
	                        &lt;&#47;absatz&gt;
	                        &lt;absatz&gt;Die Nachricht überträgt den aktuellen Zustand der Parktaschen inkl.
	                            ihrer Sensoren (z.B. Magnetkopfsensoren oder Induktionsschleifen). Die
	                            Detektion der Belegung muss mittels einer Verzögerung so realisiert
	                            werden, dass fahrende Fahrzeuge ignoriert werden.
	                        &lt;&#47;absatz&gt;
	                        &lt;absatz&gt;Jede Parktasche besteht aus ein bis max. vier Sensoren&#47;Detektoren.
	                            Auf Grund der begrenzten Kapazität von max. 109 Parktaschen
	                            (Anwendungsfall: jeweils eine Parktasche mit einem Sensor&#47;Detektor) pro
	                            DE-Block, wird dieser DE-Typ in der Regel mehrmals pro EAK verwendet. Da
	                            max. 75 DEs in einem EAK zulässig sind (siehe Definition in ANHANG 6,
	                            Teil 2, 2.2.10 - "DE-Zuordnung"), ergibt sich eine max. Kapazität von
	                            8066 Parktaschen pro EAK (75 DEs - Cluster = 74 * 109 Parktaschen = 8066
	                            Parktaschen).
	                        &lt;&#47;absatz&gt;
	                    &lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsPupParkPlatzBelegungVersion0.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.onlinedaten.OdTlsPupParkPlatzBelegungVersion0 getOdTlsPupParkPlatzBelegungVersion0();
	
	/**
	Ergänzende Betriebsparameter (Parken und Parkplatzüberwachung - FG 210 &#47;
	                    Typ 33).
	<p>
	&lt;sektion&gt;
	                        &lt;titel&gt;FG 210: DE-Block-Struktur im Typ 33 "Ergänzende Betriebsparameter"
	                        &lt;&#47;titel&gt;
	                        &lt;absatz&gt;Wird verwendet mit ID 3 (Parameter) in Abruf- und Antwortrichtung
	                            oder mit ID 35 (Parametermeldung aus Puffer) in Antwortrichtung.
	                        &lt;&#47;absatz&gt;
	                        &lt;absatz&gt;Die Nachricht überträgt ergänzende Betriebsparameter, welche z.B.
	                            für die Unterscheidung zwischen Pkw- und Lkw-ähnlichen Fahrzeugen
	                            benötigt werden.
	                            Sollten Werte zugewiesen werden, welche vom Datenendgerät nicht
	                            angewendet werden können (z.B. weil andere Kriterien zur Pkw&#47;Lkw
	                            Unterscheidung dienen), wird in Antwortrichtung der Wert 255 zurück
	                            gemeldet.
	                        &lt;&#47;absatz&gt;
	                    &lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsPupErgaenzendeBetriebsParameter.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.parameter.PdTlsPupErgaenzendeBetriebsParameter getPdTlsPupErgaenzendeBetriebsParameter();
	
	/**
	Ergebnismeldung Parkplatzbelegung für die Versionen 6 (Parken und Parkplatzüberwachung - FG 210 &#47; Typ 54).
	<p>
	&lt;sektion&gt;
	                        &lt;titel&gt;FG 210: DE-Block-Struktur im Typ 54 "Ergebnismeldung
	                            Parkplatzbelegung"
	                        &lt;&#47;titel&gt;
	                        &lt;absatz&gt;Wird verwendet mit ID 4 (Ergebnisse) in Antwortrichtung.
	                        &lt;&#47;absatz&gt;
	                        &lt;absatz&gt;Die Nachricht überträgt die Anzahl der freien StVO konformen
	                            Parkplätze, der blockierter freier StVO konformen Parkplätze und der
	                            freier nicht StVO konformer Parkplätze. Lassen sich (z. B. aufgrund von
	                            Sensor- oder Detektorfehlern) einzelne Werte des Blockes nicht
	                            ermitteln, ohne dass ein Totalausfall des DE vorliegt, werden die
	                            betroffenen Bytes auf den Wert 255 (65535) gesetzt.
	                        &lt;&#47;absatz&gt;
	                    &lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsPupParkPlatzBelegungVersion6.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.onlinedaten.OdTlsPupParkPlatzBelegungVersion6 getOdTlsPupParkPlatzBelegungVersion6();
	
	/**
	Koordinaten eines Punktes in Grad entsprechend WGS84.
	<p>
	
	</p>
	@return der Datensatz PunktKoordinaten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten getKdPunktKoordinaten();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
