/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ergebnismeldung Parkplatzbelegung für die Versionen 6 (Parken und Parkplatzüberwachung - FG 210 &#47; Typ 54).
<p>
&lt;sektion&gt;
                        &lt;titel&gt;FG 210: DE-Block-Struktur im Typ 54 "Ergebnismeldung
                            Parkplatzbelegung"
                        &lt;&#47;titel&gt;
                        &lt;absatz&gt;Wird verwendet mit ID 4 (Ergebnisse) in Antwortrichtung.
                        &lt;&#47;absatz&gt;
                        &lt;absatz&gt;Die Nachricht überträgt die Anzahl der freien StVO konformen
                            Parkplätze, der blockierter freier StVO konformen Parkplätze und der
                            freier nicht StVO konformer Parkplätze. Lassen sich (z. B. aufgrund von
                            Sensor- oder Detektorfehlern) einzelne Werte des Blockes nicht
                            ermitteln, ohne dass ein Totalausfall des DE vorliegt, werden die
                            betroffenen Bytes auf den Wert 255 (65535) gesetzt.
                        &lt;&#47;absatz&gt;
                    &lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTlsPupParkPlatzBelegungVersion6 extends AbstractOnlineDatensatz<OdTlsPupParkPlatzBelegungVersion6.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAntwort,
				};
			}
	
			/**
			 * Aspekt für Antworten von TLS-Daten eines DE-Blocks
						nach Abruf, nach Pufferabfrage oder spontan.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAntwort = new Aspekte("TlsAntwort", "asp.tlsAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetze
				 _qfSkP
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetze
				 _qbfSkP
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetze
				 _qfnSkP
				;
		
			/**
			Der Wert "Anzahl freier StVO konformer Parkplätze" überträgt die
			                        Anzahl der freien StVO konformen Parkplätze.
			<p>
			
			</p>
			
			@return der Wert von QfSkP.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetze
				 getQfSkP() {
				return _qfSkP;
			}
		
			/**
			Der Wert "Anzahl freier StVO konformer Parkplätze" überträgt die
			                        Anzahl der freien StVO konformen Parkplätze.
			<p>
			
			</p>
			
			@param _qfSkP der neue Wert von QfSkP.
			*/
			public void setQfSkP(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetze
			 _qfSkP) {
				this._qfSkP = _qfSkP;
			}
		
			/**
			Der Wert "Anzahl blockierter freier StVO konformer Parkplätze"
			                        überträgt die Anzahl der blockierten freien StVO konformen Parkplätze. Diese
			                        Parkplätze werden als besetzt bzw. nicht anfahrbar gewertet und sind nicht
			                        im Wert QfSkP enthalten.
			<p>
			
			</p>
			
			@return der Wert von QbfSkP.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetze
				 getQbfSkP() {
				return _qbfSkP;
			}
		
			/**
			Der Wert "Anzahl blockierter freier StVO konformer Parkplätze"
			                        überträgt die Anzahl der blockierten freien StVO konformen Parkplätze. Diese
			                        Parkplätze werden als besetzt bzw. nicht anfahrbar gewertet und sind nicht
			                        im Wert QfSkP enthalten.
			<p>
			
			</p>
			
			@param _qbfSkP der neue Wert von QbfSkP.
			*/
			public void setQbfSkP(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetze
			 _qbfSkP) {
				this._qbfSkP = _qbfSkP;
			}
		
			/**
			Der Wert "Anzahl freier nicht StVO konformer Parkplätze" überträgt die
			                        Anzahl der freien nicht StVO konformen Parkplätze. Unter nicht StVO
			                        konformen Parkplätzen versteht man die sogenannten Wildparker (Standflächen,
			                        welche nicht als Parkflächen ausgewiesen sind).
			<p>
			
			</p>
			
			@return der Wert von QfnSkP.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetze
				 getQfnSkP() {
				return _qfnSkP;
			}
		
			/**
			Der Wert "Anzahl freier nicht StVO konformer Parkplätze" überträgt die
			                        Anzahl der freien nicht StVO konformen Parkplätze. Unter nicht StVO
			                        konformen Parkplätzen versteht man die sogenannten Wildparker (Standflächen,
			                        welche nicht als Parkflächen ausgewiesen sind).
			<p>
			
			</p>
			
			@param _qfnSkP der neue Wert von QfnSkP.
			*/
			public void setQfnSkP(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetze
			 _qfnSkP) {
				this._qfnSkP = _qfnSkP;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getQfSkP() != null) {
		                if (getQfSkP().isZustand()) {
		                    datum.getUnscaledValue("QfSkP").setText(getQfSkP().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("QfSkP").set(getQfSkP().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQbfSkP() != null) {
		                if (getQbfSkP().isZustand()) {
		                    datum.getUnscaledValue("QbfSkP").setText(getQbfSkP().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("QbfSkP").set(getQbfSkP().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQfnSkP() != null) {
		                if (getQfnSkP().isZustand()) {
		                    datum.getUnscaledValue("QfnSkP").setText(getQfnSkP().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("QfnSkP").set(getQfnSkP().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("QfSkP").isState()) {
								setQfSkP(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetze
								.getZustand(daten.getScaledValue("QfSkP").getText()));
							} else {
							setQfSkP(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetze
							(daten.
								getUnscaledValue
							("QfSkP").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("QbfSkP").isState()) {
								setQbfSkP(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetze
								.getZustand(daten.getScaledValue("QbfSkP").getText()));
							} else {
							setQbfSkP(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetze
							(daten.
								getUnscaledValue
							("QbfSkP").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("QfnSkP").isState()) {
								setQfnSkP(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetze
								.getZustand(daten.getScaledValue("QfnSkP").getText()));
							} else {
							setQfnSkP(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlaetze
							(daten.
								getUnscaledValue
							("QfnSkP").
									intValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setQfSkP(getQfSkP());
							klon.setQbfSkP(getQbfSkP());
							klon.setQfnSkP(getQfnSkP());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsPupParkPlatzBelegungVersion6";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsPupParkPlatzBelegungVersion6(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
