/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Betriebsparameter (Parken und Parkplatzüberwachung - FG 210 &#47; Typ 32).
<p>
&lt;sektion&gt;
                        &lt;titel&gt;FG 210: DE-Block-Struktur im Typ 32 "Betriebsparameter"&lt;&#47;titel&gt;
                        &lt;absatz&gt;Wird verwendet mit ID 3 (Parameter) in Abruf- und Antwortrichtung
                            oder mit ID 35 (Parametermeldung aus Puffer) in Antwortrichtung.
                        &lt;&#47;absatz&gt;
                        &lt;absatz&gt;Die Nachricht überträgt Betriebsparameter, welche für die
                            Generierung der Betriebsmeldungen benötigt werden.
                        &lt;&#47;absatz&gt;
                    &lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class PdTlsPupBetriebsParameter extends AbstractParameterDatensatz<PdTlsPupBetriebsParameter.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsParameterVorgabeArchiv,
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.TlsVorgabeBedienung,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt für den Quittierungsmechanismus des Archivs. Wird alternativ zu asp.parameterVorgabe
						verwendet, wenn die Vorgabe indirekt nach der Archivierung durch das Archiv
						erfolgen soll.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsParameterVorgabeArchiv = new Aspekte("TlsVorgabeArchiv", "asp.tlsParameterVorgabeArchiv");
			
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * NICHT VERWENDEN. KANN JEDERZEIT WIEDER GELÖSCHT
						WERDEN. Aspekt für Vorgaben von einer Bedienung, die
						nicht wie die Parametersätze automatisch verschickt
						werden (z.B. Schaltdaten, dient zur Unterscheidung
						der Quelle).	 
			 *
			 * <p>
			 * NICHT VERWENDEN. KANN JEDERZEIT WIEDER GELÖSCHT
						WERDEN. Wird verwendet, wenn zusätzlich zum
						asp.tlsVorgabe weitere unterscheidbare Vorgaben
						benötigt werden. Vorgaben aus diesem Aspekt werden
						i. d. R. nicht direkt an die SS geschickt, sondern
						(z. B. über WAN-COM) an eine Zwischensschicht, um
						DaV-Systeme mit Altsystemen zu koppeln.
	         * </p>
			 */
			public static final Aspekt TlsVorgabeBedienung = new Aspekte("TlsVorgabeBedienung", "asp.tlsVorgabeBedienung");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupErfassungsPeriodenDauer
				 _erfassungsPeriodenDauer
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupUebertragungsVerfahren
				 _uebertragungsVerfahren
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupVersionErgebnisMeldung
				 _versionErgebnisMeldung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupTyp63
				 _typ63
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Erfassungsperiodendauer für die Übertragung der Betriebsmeldungen.
			<p>
			Der Wert "Erfassungsperiodendauer" gibt in der Einheit "Sekunde" an, in welchen
			                    zeitlichen Abständen die Übertragung der Betriebsmeldungen erfolgen soll. Es
			                    sind nur Werte zugelassen, die ein ganzzahliges Vielfaches haben, welches 24
			                    Stunden ergibt (15, 30 Sekunden, 1, 2, 3, 4, 5, 6, 10, 12, 15, 20, und 30
			                    Minuten und 1, 1½, 2, 3, 4, 6, 8 und 12 Stunden).
			                    Der Wert "Erfassungsperiodendauer" ist nur relevant bei der zyklischen Abgabe
			                    von Meldungen (siehe "Übertragungsverfahren"). Bei Zuweisung einer fehlerhaften
			                    Erfassungsperiodendauer wird eine negative Quittung (Fehlerursache 4) gesendet.
			</p>
			
			@return der Wert von ErfassungsPeriodenDauer.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupErfassungsPeriodenDauer
				 getErfassungsPeriodenDauer() {
				return _erfassungsPeriodenDauer;
			}
		
			/**
			Erfassungsperiodendauer für die Übertragung der Betriebsmeldungen.
			<p>
			Der Wert "Erfassungsperiodendauer" gibt in der Einheit "Sekunde" an, in welchen
			                    zeitlichen Abständen die Übertragung der Betriebsmeldungen erfolgen soll. Es
			                    sind nur Werte zugelassen, die ein ganzzahliges Vielfaches haben, welches 24
			                    Stunden ergibt (15, 30 Sekunden, 1, 2, 3, 4, 5, 6, 10, 12, 15, 20, und 30
			                    Minuten und 1, 1½, 2, 3, 4, 6, 8 und 12 Stunden).
			                    Der Wert "Erfassungsperiodendauer" ist nur relevant bei der zyklischen Abgabe
			                    von Meldungen (siehe "Übertragungsverfahren"). Bei Zuweisung einer fehlerhaften
			                    Erfassungsperiodendauer wird eine negative Quittung (Fehlerursache 4) gesendet.
			</p>
			
			@param _erfassungsPeriodenDauer der neue Wert von ErfassungsPeriodenDauer.
			*/
			public void setErfassungsPeriodenDauer(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupErfassungsPeriodenDauer
			 _erfassungsPeriodenDauer) {
				this._erfassungsPeriodenDauer = _erfassungsPeriodenDauer;
			}
		
			/**
			Definition der Übertragungsverfahren FG210 Typ32.
			<p>
			
			</p>
			
			@return der Wert von UebertragungsVerfahren.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupUebertragungsVerfahren
				 getUebertragungsVerfahren() {
				return _uebertragungsVerfahren;
			}
		
			/**
			Definition der Übertragungsverfahren FG210 Typ32.
			<p>
			
			</p>
			
			@param _uebertragungsVerfahren der neue Wert von UebertragungsVerfahren.
			*/
			public void setUebertragungsVerfahren(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupUebertragungsVerfahren
			 _uebertragungsVerfahren) {
				this._uebertragungsVerfahren = _uebertragungsVerfahren;
			}
		
			/**
			Definition der Version der Ergebnismeldung FG210 Typ32. Die Versionsnummer
			                    bestimmt die Ergebnismeldung der Parkplatzbelegung.
			<p>
			
			</p>
			
			@return der Wert von VersionErgebnisMeldung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupVersionErgebnisMeldung
				 getVersionErgebnisMeldung() {
				return _versionErgebnisMeldung;
			}
		
			/**
			Definition der Version der Ergebnismeldung FG210 Typ32. Die Versionsnummer
			                    bestimmt die Ergebnismeldung der Parkplatzbelegung.
			<p>
			
			</p>
			
			@param _versionErgebnisMeldung der neue Wert von VersionErgebnisMeldung.
			*/
			public void setVersionErgebnisMeldung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupVersionErgebnisMeldung
			 _versionErgebnisMeldung) {
				this._versionErgebnisMeldung = _versionErgebnisMeldung;
			}
		
			/**
			Der "Typ63" dient zum Ein- bzw. Ausschalten für das spontane Senden der Einzel-
			                    Fahrzeugidentifikationsdaten.
			<p>
			
			</p>
			
			@return der Wert von Typ63.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupTyp63
				 getTyp63() {
				return _typ63;
			}
		
			/**
			Der "Typ63" dient zum Ein- bzw. Ausschalten für das spontane Senden der Einzel-
			                    Fahrzeugidentifikationsdaten.
			<p>
			
			</p>
			
			@param _typ63 der neue Wert von Typ63.
			*/
			public void setTyp63(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupTyp63
			 _typ63) {
				this._typ63 = _typ63;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getErfassungsPeriodenDauer() != null) {
		                if (getErfassungsPeriodenDauer().isZustand()) {
		                    datum.getUnscaledValue("ErfassungsPeriodenDauer").setText(getErfassungsPeriodenDauer().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ErfassungsPeriodenDauer").set(getErfassungsPeriodenDauer().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getUebertragungsVerfahren() != null) {
		                if (getUebertragungsVerfahren().isZustand()) {
		                    datum.getUnscaledValue("ÜbertragungsVerfahren").setText(getUebertragungsVerfahren().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ÜbertragungsVerfahren").set(getUebertragungsVerfahren().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVersionErgebnisMeldung() != null) {
		                if (getVersionErgebnisMeldung().isZustand()) {
		                    datum.getUnscaledValue("VersionErgebnisMeldung").setText(getVersionErgebnisMeldung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VersionErgebnisMeldung").set(getVersionErgebnisMeldung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getTyp63() != null) {
		                if (getTyp63().isZustand()) {
		                    datum.getUnscaledValue("Typ63").setText(getTyp63().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Typ63").set(getTyp63().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("ErfassungsPeriodenDauer").isState()) {
								setErfassungsPeriodenDauer(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupErfassungsPeriodenDauer
								.getZustand(daten.getScaledValue("ErfassungsPeriodenDauer").getText()));
							} else {
							setErfassungsPeriodenDauer(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupErfassungsPeriodenDauer
							(daten.
								getUnscaledValue
							("ErfassungsPeriodenDauer").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("ÜbertragungsVerfahren").isState()) {
								setUebertragungsVerfahren(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupUebertragungsVerfahren
								.getZustand(daten.getScaledValue("ÜbertragungsVerfahren").getText()));
							} else {
							setUebertragungsVerfahren(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupUebertragungsVerfahren
							(daten.
								getUnscaledValue
							("ÜbertragungsVerfahren").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VersionErgebnisMeldung").isState()) {
								setVersionErgebnisMeldung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupVersionErgebnisMeldung
								.getZustand(daten.getScaledValue("VersionErgebnisMeldung").getText()));
							} else {
							setVersionErgebnisMeldung(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupVersionErgebnisMeldung
							(daten.
								getUnscaledValue
							("VersionErgebnisMeldung").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Typ63").isState()) {
								setTyp63(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupTyp63
								.getZustand(daten.getScaledValue("Typ63").getText()));
							} else {
							setTyp63(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupTyp63
							(daten.
								getUnscaledValue
							("Typ63").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setErfassungsPeriodenDauer(getErfassungsPeriodenDauer());
							klon.setUebertragungsVerfahren(getUebertragungsVerfahren());
							klon.setVersionErgebnisMeldung(getVersionErgebnisMeldung());
							klon.setTyp63(getTyp63());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsPupBetriebsParameter";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdTlsPupBetriebsParameter(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
