/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ergänzende Betriebsparameter (Parken und Parkplatzüberwachung - FG 210 &#47;
                    Typ 33).
<p>
&lt;sektion&gt;
                        &lt;titel&gt;FG 210: DE-Block-Struktur im Typ 33 "Ergänzende Betriebsparameter"
                        &lt;&#47;titel&gt;
                        &lt;absatz&gt;Wird verwendet mit ID 3 (Parameter) in Abruf- und Antwortrichtung
                            oder mit ID 35 (Parametermeldung aus Puffer) in Antwortrichtung.
                        &lt;&#47;absatz&gt;
                        &lt;absatz&gt;Die Nachricht überträgt ergänzende Betriebsparameter, welche z.B.
                            für die Unterscheidung zwischen Pkw- und Lkw-ähnlichen Fahrzeugen
                            benötigt werden.
                            Sollten Werte zugewiesen werden, welche vom Datenendgerät nicht
                            angewendet werden können (z.B. weil andere Kriterien zur Pkw&#47;Lkw
                            Unterscheidung dienen), wird in Antwortrichtung der Wert 255 zurück
                            gemeldet.
                        &lt;&#47;absatz&gt;
                    &lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class PdTlsPupErgaenzendeBetriebsParameter extends AbstractParameterDatensatz<PdTlsPupErgaenzendeBetriebsParameter.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsParameterVorgabeArchiv,
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.TlsVorgabeBedienung,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt für den Quittierungsmechanismus des Archivs. Wird alternativ zu asp.parameterVorgabe
						verwendet, wenn die Vorgabe indirekt nach der Archivierung durch das Archiv
						erfolgen soll.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsParameterVorgabeArchiv = new Aspekte("TlsVorgabeArchiv", "asp.tlsParameterVorgabeArchiv");
			
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * NICHT VERWENDEN. KANN JEDERZEIT WIEDER GELÖSCHT
						WERDEN. Aspekt für Vorgaben von einer Bedienung, die
						nicht wie die Parametersätze automatisch verschickt
						werden (z.B. Schaltdaten, dient zur Unterscheidung
						der Quelle).	 
			 *
			 * <p>
			 * NICHT VERWENDEN. KANN JEDERZEIT WIEDER GELÖSCHT
						WERDEN. Wird verwendet, wenn zusätzlich zum
						asp.tlsVorgabe weitere unterscheidbare Vorgaben
						benötigt werden. Vorgaben aus diesem Aspekt werden
						i. d. R. nicht direkt an die SS geschickt, sondern
						(z. B. über WAN-COM) an eine Zwischensschicht, um
						DaV-Systeme mit Altsystemen zu koppeln.
	         * </p>
			 */
			public static final Aspekt TlsVorgabeBedienung = new Aspekte("TlsVorgabeBedienung", "asp.tlsVorgabeBedienung");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupKfzLaengenGrenzWert
				 _kfzLaengenGrenzWert
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupKfzHoehenGrenzWert
				 _kfzHoehenGrenzWert
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupKfzBreitenGrenzWert
				 _kfzBreitenGrenzWert
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupMaxAnzahlStVOkonformerParkPlaetze
				 _maxAnzahlStVOkonformerParkPlaetze
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupMaxAnzahlNichtStVOkonformerParkPlaetze
				 _maxAnzahlNichtStVOkonformerParkPlaetze
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlatzBereiche
				 _anzahlParkPlatzBereiche
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupMindestRestLaengeParkStandsReihen
				 _mindestRestLaengeParkStandsReihen
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupOffsetMindestRestLaengeParkStandsReihen
				 _offsetMindestRestLaengeParkStandsReihen
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupMeldungsIntervallParkStandsReihen
				 _meldungsIntervallParkStandsReihen
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
				 _reserve1
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
				 _reserve2
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Der Wert "Kfz-Längengrenzwert" gibt in der Einheit [dm] an, ab welcher
			                        Fahrzeuglänge ein Kraftfahrzeug als Lkw-ähnlich einzustufen ist. Dabei gilt:
			                        0..254: Längengrenzwert von 0dm..254dm, 255: das Datenendgerät entscheidet
			                        selbstständig über den anzuwendenden Längengrenzwert.
			<p>
			
			</p>
			
			@return der Wert von KfzLaengenGrenzWert.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupKfzLaengenGrenzWert
				 getKfzLaengenGrenzWert() {
				return _kfzLaengenGrenzWert;
			}
		
			/**
			Der Wert "Kfz-Längengrenzwert" gibt in der Einheit [dm] an, ab welcher
			                        Fahrzeuglänge ein Kraftfahrzeug als Lkw-ähnlich einzustufen ist. Dabei gilt:
			                        0..254: Längengrenzwert von 0dm..254dm, 255: das Datenendgerät entscheidet
			                        selbstständig über den anzuwendenden Längengrenzwert.
			<p>
			
			</p>
			
			@param _kfzLaengenGrenzWert der neue Wert von KfzLaengenGrenzWert.
			*/
			public void setKfzLaengenGrenzWert(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupKfzLaengenGrenzWert
			 _kfzLaengenGrenzWert) {
				this._kfzLaengenGrenzWert = _kfzLaengenGrenzWert;
			}
		
			/**
			Der Wert "Kfz-Höhengrenzwert" gibt in der Einheit [cm] an, ab welcher
			                        Fahrzeughöhe ein Kraftfahrzeug als Lkw-ähnlich einzustufen ist. Dabei gilt:
			                        0..254: Höhengrenzwert 1m + (0cm..254cm), 255: das Datenendgerät entscheidet
			                        selbstständig über den anzuwendenden Höhengrenzwert.
			<p>
			
			</p>
			
			@return der Wert von KfzHoehenGrenzWert.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupKfzHoehenGrenzWert
				 getKfzHoehenGrenzWert() {
				return _kfzHoehenGrenzWert;
			}
		
			/**
			Der Wert "Kfz-Höhengrenzwert" gibt in der Einheit [cm] an, ab welcher
			                        Fahrzeughöhe ein Kraftfahrzeug als Lkw-ähnlich einzustufen ist. Dabei gilt:
			                        0..254: Höhengrenzwert 1m + (0cm..254cm), 255: das Datenendgerät entscheidet
			                        selbstständig über den anzuwendenden Höhengrenzwert.
			<p>
			
			</p>
			
			@param _kfzHoehenGrenzWert der neue Wert von KfzHoehenGrenzWert.
			*/
			public void setKfzHoehenGrenzWert(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupKfzHoehenGrenzWert
			 _kfzHoehenGrenzWert) {
				this._kfzHoehenGrenzWert = _kfzHoehenGrenzWert;
			}
		
			/**
			Der Wert "Kfz-Breitengrenzwert" gibt in der Einheit [cm] an, ab
			                        welcher Fahrzeugbreite ein Kraftfahrzeug als Lkw-ähnlich einzustufen ist.
			                        Dabei gilt: 0..254: Breitengrenzwert 1m + (0cm..254cm), 255: das
			                        Datenendgerät entscheidet selbstständig über den anzuwendenden
			                        Breitengrenzwert.
			<p>
			
			</p>
			
			@return der Wert von KfzBreitenGrenzWert.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupKfzBreitenGrenzWert
				 getKfzBreitenGrenzWert() {
				return _kfzBreitenGrenzWert;
			}
		
			/**
			Der Wert "Kfz-Breitengrenzwert" gibt in der Einheit [cm] an, ab
			                        welcher Fahrzeugbreite ein Kraftfahrzeug als Lkw-ähnlich einzustufen ist.
			                        Dabei gilt: 0..254: Breitengrenzwert 1m + (0cm..254cm), 255: das
			                        Datenendgerät entscheidet selbstständig über den anzuwendenden
			                        Breitengrenzwert.
			<p>
			
			</p>
			
			@param _kfzBreitenGrenzWert der neue Wert von KfzBreitenGrenzWert.
			*/
			public void setKfzBreitenGrenzWert(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupKfzBreitenGrenzWert
			 _kfzBreitenGrenzWert) {
				this._kfzBreitenGrenzWert = _kfzBreitenGrenzWert;
			}
		
			/**
			Der Wert "Max. Anzahl StVO konformer Parkplätze" gibt die max. Anzahl
			                        der verfügbaren StVO konformen Parkplätze an. Sollten keine StVO konformen
			                        Parkplätze verfügbar sein, wird der Wert auf 0 gesetzt. Da max. 40
			                        Parkplatzbereiche pro Parkplatz erlaubt sind, ergibt sich eine max. Anzahl
			                        von 40x255=10200 Parkplätzen.
			<p>
			
			</p>
			
			@return der Wert von MaxAnzahlStVOkonformerParkPlaetze.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupMaxAnzahlStVOkonformerParkPlaetze
				 getMaxAnzahlStVOkonformerParkPlaetze() {
				return _maxAnzahlStVOkonformerParkPlaetze;
			}
		
			/**
			Der Wert "Max. Anzahl StVO konformer Parkplätze" gibt die max. Anzahl
			                        der verfügbaren StVO konformen Parkplätze an. Sollten keine StVO konformen
			                        Parkplätze verfügbar sein, wird der Wert auf 0 gesetzt. Da max. 40
			                        Parkplatzbereiche pro Parkplatz erlaubt sind, ergibt sich eine max. Anzahl
			                        von 40x255=10200 Parkplätzen.
			<p>
			
			</p>
			
			@param _maxAnzahlStVOkonformerParkPlaetze der neue Wert von MaxAnzahlStVOkonformerParkPlaetze.
			*/
			public void setMaxAnzahlStVOkonformerParkPlaetze(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupMaxAnzahlStVOkonformerParkPlaetze
			 _maxAnzahlStVOkonformerParkPlaetze) {
				this._maxAnzahlStVOkonformerParkPlaetze = _maxAnzahlStVOkonformerParkPlaetze;
			}
		
			/**
			Der Wert "Max. Anzahl nicht StVO konformen Parkplätze" gibt die max.
			                        Anzahl der verfügbaren nicht StVO konformen Parkplätze an. Unter nicht StVO
			                        konformen Parkplätzen versteht man die sogenannten Wildparker (Standflächen,
			                        welche nicht als Parkflächen ausgewiesen sind). Sollten keine nicht StVO
			                        konformen Parkplätze verfügbar sein, wird der Wert auf 0 gesetzt. Da max. 40
			                        Parkplatzbereiche pro Parkplatz erlaubt sind, ergibt sich eine max. Anzahl
			                        von 40x254=10160 Parkplätzen.
			<p>
			
			</p>
			
			@return der Wert von MaxAnzahlNichtStVOkonformerParkPlaetze.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupMaxAnzahlNichtStVOkonformerParkPlaetze
				 getMaxAnzahlNichtStVOkonformerParkPlaetze() {
				return _maxAnzahlNichtStVOkonformerParkPlaetze;
			}
		
			/**
			Der Wert "Max. Anzahl nicht StVO konformen Parkplätze" gibt die max.
			                        Anzahl der verfügbaren nicht StVO konformen Parkplätze an. Unter nicht StVO
			                        konformen Parkplätzen versteht man die sogenannten Wildparker (Standflächen,
			                        welche nicht als Parkflächen ausgewiesen sind). Sollten keine nicht StVO
			                        konformen Parkplätze verfügbar sein, wird der Wert auf 0 gesetzt. Da max. 40
			                        Parkplatzbereiche pro Parkplatz erlaubt sind, ergibt sich eine max. Anzahl
			                        von 40x254=10160 Parkplätzen.
			<p>
			
			</p>
			
			@param _maxAnzahlNichtStVOkonformerParkPlaetze der neue Wert von MaxAnzahlNichtStVOkonformerParkPlaetze.
			*/
			public void setMaxAnzahlNichtStVOkonformerParkPlaetze(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupMaxAnzahlNichtStVOkonformerParkPlaetze
			 _maxAnzahlNichtStVOkonformerParkPlaetze) {
				this._maxAnzahlNichtStVOkonformerParkPlaetze = _maxAnzahlNichtStVOkonformerParkPlaetze;
			}
		
			/**
			Der Wert "Anzahl Parkplatzbereiche" gibt die Anzahl der
			                        Parkplatzbereiche an. Jeder Parkplatz kann in mehrere Parkplatzbereiche
			                        unterteilt werden. Wird der Parkplatz in mehrere Parkplatzbereiche
			                        unterteilt, kann für jeden Bereich die Anzahl der freien Parkplätze
			                        ermittelt werden. Dabei gilt: 0: keine Parkplatzbereiche definiert (DE-Typ
			                        60&#47;61 entfällt) 1...40: max. 40 Parkplatzbereiche definiert (DE-Typ 60&#47;61
			                        verfügbar).
			<p>
			
			</p>
			
			@return der Wert von AnzahlParkPlatzBereiche.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlatzBereiche
				 getAnzahlParkPlatzBereiche() {
				return _anzahlParkPlatzBereiche;
			}
		
			/**
			Der Wert "Anzahl Parkplatzbereiche" gibt die Anzahl der
			                        Parkplatzbereiche an. Jeder Parkplatz kann in mehrere Parkplatzbereiche
			                        unterteilt werden. Wird der Parkplatz in mehrere Parkplatzbereiche
			                        unterteilt, kann für jeden Bereich die Anzahl der freien Parkplätze
			                        ermittelt werden. Dabei gilt: 0: keine Parkplatzbereiche definiert (DE-Typ
			                        60&#47;61 entfällt) 1...40: max. 40 Parkplatzbereiche definiert (DE-Typ 60&#47;61
			                        verfügbar).
			<p>
			
			</p>
			
			@param _anzahlParkPlatzBereiche der neue Wert von AnzahlParkPlatzBereiche.
			*/
			public void setAnzahlParkPlatzBereiche(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlatzBereiche
			 _anzahlParkPlatzBereiche) {
				this._anzahlParkPlatzBereiche = _anzahlParkPlatzBereiche;
			}
		
			/**
			Der Wert "Mindestrestlänge der Parkstandsreihen" gibt in der Einheit
			                        [m] an, ab welcher Mindestrestlänge die Parkstandsreihe als "vollständig
			                        belegt" gemeldet werden muss. Dabei gilt: 0..200: Mindestrestlänge für
			                        Parkstandsreihen von 0m..200m 201..254: nicht erlaubt; es wird eine negative
			                        Quittung (Fehlerursache 10) gesendet 255: das Datenendgerät entscheidet
			                        selbstständig über die anzuwendende Mindestrestlänge der Parkstandsreihen.
			<p>
			
			</p>
			
			@return der Wert von MindestRestLaengeParkStandsReihen.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupMindestRestLaengeParkStandsReihen
				 getMindestRestLaengeParkStandsReihen() {
				return _mindestRestLaengeParkStandsReihen;
			}
		
			/**
			Der Wert "Mindestrestlänge der Parkstandsreihen" gibt in der Einheit
			                        [m] an, ab welcher Mindestrestlänge die Parkstandsreihe als "vollständig
			                        belegt" gemeldet werden muss. Dabei gilt: 0..200: Mindestrestlänge für
			                        Parkstandsreihen von 0m..200m 201..254: nicht erlaubt; es wird eine negative
			                        Quittung (Fehlerursache 10) gesendet 255: das Datenendgerät entscheidet
			                        selbstständig über die anzuwendende Mindestrestlänge der Parkstandsreihen.
			<p>
			
			</p>
			
			@param _mindestRestLaengeParkStandsReihen der neue Wert von MindestRestLaengeParkStandsReihen.
			*/
			public void setMindestRestLaengeParkStandsReihen(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupMindestRestLaengeParkStandsReihen
			 _mindestRestLaengeParkStandsReihen) {
				this._mindestRestLaengeParkStandsReihen = _mindestRestLaengeParkStandsReihen;
			}
		
			/**
			Offset für die Mindestrestlänge in der Einheit [m] und gibt an, ab
			                        welchem Offset zur Mindestrestlänge eine beschleunigte "vollständig belegt"
			                        Meldung der Parkstandsreihe erfolgt.
			<p>
			
			</p>
			
			@return der Wert von OffsetMindestRestLaengeParkStandsReihen.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupOffsetMindestRestLaengeParkStandsReihen
				 getOffsetMindestRestLaengeParkStandsReihen() {
				return _offsetMindestRestLaengeParkStandsReihen;
			}
		
			/**
			Offset für die Mindestrestlänge in der Einheit [m] und gibt an, ab
			                        welchem Offset zur Mindestrestlänge eine beschleunigte "vollständig belegt"
			                        Meldung der Parkstandsreihe erfolgt.
			<p>
			
			</p>
			
			@param _offsetMindestRestLaengeParkStandsReihen der neue Wert von OffsetMindestRestLaengeParkStandsReihen.
			*/
			public void setOffsetMindestRestLaengeParkStandsReihen(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupOffsetMindestRestLaengeParkStandsReihen
			 _offsetMindestRestLaengeParkStandsReihen) {
				this._offsetMindestRestLaengeParkStandsReihen = _offsetMindestRestLaengeParkStandsReihen;
			}
		
			/**
			Zeit in der Einheit [s] für das Meldeintervall der Parkstandsreihen.
			<p>
			
			</p>
			
			@return der Wert von MeldungsIntervallParkStandsReihen.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupMeldungsIntervallParkStandsReihen
				 getMeldungsIntervallParkStandsReihen() {
				return _meldungsIntervallParkStandsReihen;
			}
		
			/**
			Zeit in der Einheit [s] für das Meldeintervall der Parkstandsreihen.
			<p>
			
			</p>
			
			@param _meldungsIntervallParkStandsReihen der neue Wert von MeldungsIntervallParkStandsReihen.
			*/
			public void setMeldungsIntervallParkStandsReihen(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupMeldungsIntervallParkStandsReihen
			 _meldungsIntervallParkStandsReihen) {
				this._meldungsIntervallParkStandsReihen = _meldungsIntervallParkStandsReihen;
			}
		
			/**
			Reservebyte.
			<p>
			
			</p>
			
			@return der Wert von Reserve1.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
				 getReserve1() {
				return _reserve1;
			}
		
			/**
			Reservebyte.
			<p>
			
			</p>
			
			@param _reserve1 der neue Wert von Reserve1.
			*/
			public void setReserve1(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 _reserve1) {
				this._reserve1 = _reserve1;
			}
		
			/**
			Reservebyte.
			<p>
			
			</p>
			
			@return der Wert von Reserve2.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
				 getReserve2() {
				return _reserve2;
			}
		
			/**
			Reservebyte.
			<p>
			
			</p>
			
			@param _reserve2 der neue Wert von Reserve2.
			*/
			public void setReserve2(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 _reserve2) {
				this._reserve2 = _reserve2;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getKfzLaengenGrenzWert() != null) {
		                if (getKfzLaengenGrenzWert().isZustand()) {
		                    datum.getUnscaledValue("KfzLängenGrenzWert").setText(getKfzLaengenGrenzWert().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("KfzLängenGrenzWert").set(getKfzLaengenGrenzWert().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getKfzHoehenGrenzWert() != null) {
		                if (getKfzHoehenGrenzWert().isZustand()) {
		                    datum.getUnscaledValue("KfzHöhenGrenzWert").setText(getKfzHoehenGrenzWert().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("KfzHöhenGrenzWert").set(getKfzHoehenGrenzWert().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getKfzBreitenGrenzWert() != null) {
		                if (getKfzBreitenGrenzWert().isZustand()) {
		                    datum.getUnscaledValue("KfzBreitenGrenzWert").setText(getKfzBreitenGrenzWert().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("KfzBreitenGrenzWert").set(getKfzBreitenGrenzWert().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxAnzahlStVOkonformerParkPlaetze() != null) {
		                if (getMaxAnzahlStVOkonformerParkPlaetze().isZustand()) {
		                    datum.getUnscaledValue("MaxAnzahlStVOkonformerParkPlätze").setText(getMaxAnzahlStVOkonformerParkPlaetze().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("MaxAnzahlStVOkonformerParkPlätze").set(getMaxAnzahlStVOkonformerParkPlaetze().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxAnzahlNichtStVOkonformerParkPlaetze() != null) {
		                if (getMaxAnzahlNichtStVOkonformerParkPlaetze().isZustand()) {
		                    datum.getUnscaledValue("MaxAnzahlNichtStVOkonformerParkPlätze").setText(getMaxAnzahlNichtStVOkonformerParkPlaetze().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("MaxAnzahlNichtStVOkonformerParkPlätze").set(getMaxAnzahlNichtStVOkonformerParkPlaetze().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAnzahlParkPlatzBereiche() != null) {
		                if (getAnzahlParkPlatzBereiche().isZustand()) {
		                    datum.getUnscaledValue("AnzahlParkPlatzBereiche").setText(getAnzahlParkPlatzBereiche().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AnzahlParkPlatzBereiche").set(getAnzahlParkPlatzBereiche().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMindestRestLaengeParkStandsReihen() != null) {
		                if (getMindestRestLaengeParkStandsReihen().isZustand()) {
		                    datum.getUnscaledValue("MindestRestLängeParkStandsReihen").setText(getMindestRestLaengeParkStandsReihen().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("MindestRestLängeParkStandsReihen").set(getMindestRestLaengeParkStandsReihen().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getOffsetMindestRestLaengeParkStandsReihen() != null) {
		                if (getOffsetMindestRestLaengeParkStandsReihen().isZustand()) {
		                    datum.getUnscaledValue("OffsetMindestRestLängeParkStandsReihen").setText(getOffsetMindestRestLaengeParkStandsReihen().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("OffsetMindestRestLängeParkStandsReihen").set(getOffsetMindestRestLaengeParkStandsReihen().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMeldungsIntervallParkStandsReihen() != null) {
		                if (getMeldungsIntervallParkStandsReihen().isZustand()) {
		                    datum.getUnscaledValue("MeldungsIntervallParkStandsReihen").setText(getMeldungsIntervallParkStandsReihen().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("MeldungsIntervallParkStandsReihen").set(getMeldungsIntervallParkStandsReihen().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getReserve1() != null) {
		                if (getReserve1().isZustand()) {
		                    datum.getUnscaledValue("Reserve1").setText(getReserve1().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Reserve1").set(getReserve1().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getReserve2() != null) {
		                if (getReserve2().isZustand()) {
		                    datum.getUnscaledValue("Reserve2").setText(getReserve2().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Reserve2").set(getReserve2().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("KfzLängenGrenzWert").isState()) {
								setKfzLaengenGrenzWert(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupKfzLaengenGrenzWert
								.getZustand(daten.getScaledValue("KfzLängenGrenzWert").getText()));
							} else {
							setKfzLaengenGrenzWert(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupKfzLaengenGrenzWert
							(daten.
								getUnscaledValue
							("KfzLängenGrenzWert").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("KfzHöhenGrenzWert").isState()) {
								setKfzHoehenGrenzWert(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupKfzHoehenGrenzWert
								.getZustand(daten.getScaledValue("KfzHöhenGrenzWert").getText()));
							} else {
							setKfzHoehenGrenzWert(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupKfzHoehenGrenzWert
							(daten.
								getUnscaledValue
							("KfzHöhenGrenzWert").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("KfzBreitenGrenzWert").isState()) {
								setKfzBreitenGrenzWert(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupKfzBreitenGrenzWert
								.getZustand(daten.getScaledValue("KfzBreitenGrenzWert").getText()));
							} else {
							setKfzBreitenGrenzWert(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupKfzBreitenGrenzWert
							(daten.
								getUnscaledValue
							("KfzBreitenGrenzWert").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MaxAnzahlStVOkonformerParkPlätze").isState()) {
								setMaxAnzahlStVOkonformerParkPlaetze(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupMaxAnzahlStVOkonformerParkPlaetze
								.getZustand(daten.getScaledValue("MaxAnzahlStVOkonformerParkPlätze").getText()));
							} else {
							setMaxAnzahlStVOkonformerParkPlaetze(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupMaxAnzahlStVOkonformerParkPlaetze
							(daten.
								getUnscaledValue
							("MaxAnzahlStVOkonformerParkPlätze").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MaxAnzahlNichtStVOkonformerParkPlätze").isState()) {
								setMaxAnzahlNichtStVOkonformerParkPlaetze(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupMaxAnzahlNichtStVOkonformerParkPlaetze
								.getZustand(daten.getScaledValue("MaxAnzahlNichtStVOkonformerParkPlätze").getText()));
							} else {
							setMaxAnzahlNichtStVOkonformerParkPlaetze(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupMaxAnzahlNichtStVOkonformerParkPlaetze
							(daten.
								getUnscaledValue
							("MaxAnzahlNichtStVOkonformerParkPlätze").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AnzahlParkPlatzBereiche").isState()) {
								setAnzahlParkPlatzBereiche(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlatzBereiche
								.getZustand(daten.getScaledValue("AnzahlParkPlatzBereiche").getText()));
							} else {
							setAnzahlParkPlatzBereiche(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupAnzahlParkPlatzBereiche
							(daten.
								getUnscaledValue
							("AnzahlParkPlatzBereiche").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MindestRestLängeParkStandsReihen").isState()) {
								setMindestRestLaengeParkStandsReihen(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupMindestRestLaengeParkStandsReihen
								.getZustand(daten.getScaledValue("MindestRestLängeParkStandsReihen").getText()));
							} else {
							setMindestRestLaengeParkStandsReihen(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupMindestRestLaengeParkStandsReihen
							(daten.
								getUnscaledValue
							("MindestRestLängeParkStandsReihen").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("OffsetMindestRestLängeParkStandsReihen").isState()) {
								setOffsetMindestRestLaengeParkStandsReihen(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupOffsetMindestRestLaengeParkStandsReihen
								.getZustand(daten.getScaledValue("OffsetMindestRestLängeParkStandsReihen").getText()));
							} else {
							setOffsetMindestRestLaengeParkStandsReihen(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupOffsetMindestRestLaengeParkStandsReihen
							(daten.
								getUnscaledValue
							("OffsetMindestRestLängeParkStandsReihen").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MeldungsIntervallParkStandsReihen").isState()) {
								setMeldungsIntervallParkStandsReihen(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupMeldungsIntervallParkStandsReihen
								.getZustand(daten.getScaledValue("MeldungsIntervallParkStandsReihen").getText()));
							} else {
							setMeldungsIntervallParkStandsReihen(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsfg210.attribute.AttTlsPupMeldungsIntervallParkStandsReihen
							(daten.
								getUnscaledValue
							("MeldungsIntervallParkStandsReihen").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							setReserve1(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
							(daten.
								getUnscaledValue
							("Reserve1").
									shortValue
							()));
					// GanzzahlAttributTyp
							setReserve2(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
							(daten.
								getUnscaledValue
							("Reserve2").
									shortValue
							()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setKfzLaengenGrenzWert(getKfzLaengenGrenzWert());
							klon.setKfzHoehenGrenzWert(getKfzHoehenGrenzWert());
							klon.setKfzBreitenGrenzWert(getKfzBreitenGrenzWert());
							klon.setMaxAnzahlStVOkonformerParkPlaetze(getMaxAnzahlStVOkonformerParkPlaetze());
							klon.setMaxAnzahlNichtStVOkonformerParkPlaetze(getMaxAnzahlNichtStVOkonformerParkPlaetze());
							klon.setAnzahlParkPlatzBereiche(getAnzahlParkPlatzBereiche());
							klon.setMindestRestLaengeParkStandsReihen(getMindestRestLaengeParkStandsReihen());
							klon.setOffsetMindestRestLaengeParkStandsReihen(getOffsetMindestRestLaengeParkStandsReihen());
							klon.setMeldungsIntervallParkStandsReihen(getMeldungsIntervallParkStandsReihen());
							klon.setReserve1(getReserve1());
							klon.setReserve2(getReserve2());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsPupErgänzendeBetriebsParameter";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdTlsPupErgaenzendeBetriebsParameter(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
