/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Höchstzullässiges Gesamtgewicht für Fahrzeugtypen
					bei der Achslasterfassung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 14
 */
public class AtlTlsAxlGesamtgewichtFahrzeugtypen implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFahrzeugklassencodeAchslast
			 _fahrzeugklassecodeAchslast
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
			 _maxGesamtgewicht
			;
	
		/**
		Klassifizierung nach Silhouette und
							Achskonfiguration.
		<p>
		
		</p>
		
		@return der Wert von FahrzeugklassecodeAchslast.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFahrzeugklassencodeAchslast
			 getFahrzeugklassecodeAchslast() {
			return _fahrzeugklassecodeAchslast;
		}
	
		/**
		Klassifizierung nach Silhouette und
							Achskonfiguration.
		<p>
		
		</p>
		
		@param _fahrzeugklassecodeAchslast der neue Wert von FahrzeugklassecodeAchslast.
		*/
		public void setFahrzeugklassecodeAchslast(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFahrzeugklassencodeAchslast
		 _fahrzeugklassecodeAchslast) {
			this._fahrzeugklassecodeAchslast = _fahrzeugklassecodeAchslast;
		}
	
		/**
		Gewichtsangabe gemäß TLS 0..65534 kg.
		<p>
		
		</p>
		
		@return der Wert von MaxGesamtgewicht.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
			 getMaxGesamtgewicht() {
			return _maxGesamtgewicht;
		}
	
		/**
		Gewichtsangabe gemäß TLS 0..65534 kg.
		<p>
		
		</p>
		
		@param _maxGesamtgewicht der neue Wert von MaxGesamtgewicht.
		*/
		public void setMaxGesamtgewicht(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
		 _maxGesamtgewicht) {
			this._maxGesamtgewicht = _maxGesamtgewicht;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getFahrzeugklassecodeAchslast() != null) {
	                if (getFahrzeugklassecodeAchslast().isZustand()) {
	                    datum.getUnscaledValue("FahrzeugklassecodeAchslast").setText(getFahrzeugklassecodeAchslast().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("FahrzeugklassecodeAchslast").set(getFahrzeugklassecodeAchslast().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getMaxGesamtgewicht() != null) {
	                if (getMaxGesamtgewicht().isZustand()) {
	                    datum.getUnscaledValue("MaxGesamtgewicht").setText(getMaxGesamtgewicht().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("MaxGesamtgewicht").set(getMaxGesamtgewicht().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("FahrzeugklassecodeAchslast").isState()) {
							setFahrzeugklassecodeAchslast(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFahrzeugklassencodeAchslast
							.getZustand(daten.getScaledValue("FahrzeugklassecodeAchslast").getText()));
						} else {
						setFahrzeugklassecodeAchslast(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFahrzeugklassencodeAchslast
						(daten.
							getUnscaledValue
						("FahrzeugklassecodeAchslast").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("MaxGesamtgewicht").isState()) {
							setMaxGesamtgewicht(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
							.getZustand(daten.getScaledValue("MaxGesamtgewicht").getText()));
						} else {
						setMaxGesamtgewicht(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
						(daten.
							getUnscaledValue
						("MaxGesamtgewicht").
								intValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTlsAxlGesamtgewichtFahrzeugtypen clone() {
		AtlTlsAxlGesamtgewichtFahrzeugtypen klon = new AtlTlsAxlGesamtgewichtFahrzeugtypen();
		
						klon.setFahrzeugklassecodeAchslast(getFahrzeugklassecodeAchslast());
						klon.setMaxGesamtgewicht(getMaxGesamtgewicht());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
