/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Einzelinformationen bei der Codelistendefinitionen
					an Clusterkanälen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTlsWzgWvzClusterDefinition implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 _deNummer
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
			 _anzeigePrinzip
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzAnzeige
			 _anzeige
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzAnzeige
			()
			;
	
		/**
		De-Nummer der Komponente.
		<p>
		
		</p>
		
		@return der Wert von DeNummer.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 getDeNummer() {
			return _deNummer;
		}
	
		/**
		De-Nummer der Komponente.
		<p>
		
		</p>
		
		@param _deNummer der neue Wert von DeNummer.
		*/
		public void setDeNummer(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
		 _deNummer) {
			this._deNummer = _deNummer;
		}
	
		/**
		Anzeigeprinzip des DE.
		<p>
		
		</p>
		
		@return der Wert von AnzeigePrinzip.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
			 getAnzeigePrinzip() {
			return _anzeigePrinzip;
		}
	
		/**
		Anzeigeprinzip des DE.
		<p>
		
		</p>
		
		@param _anzeigePrinzip der neue Wert von AnzeigePrinzip.
		*/
		public void setAnzeigePrinzip(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
		 _anzeigePrinzip) {
			this._anzeigePrinzip = _anzeigePrinzip;
		}
	
		/**
		Einzelinformationen bei der Anzeige eines WVZ.
		<p>
		
		</p>
		
		@return der Wert von Anzeige.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzAnzeige
			 getAnzeige() {
			return _anzeige;
		}
	
		/**
		Einzelinformationen bei der Anzeige eines WVZ.
		<p>
		
		</p>
		
		@param _anzeige der neue Wert von Anzeige.
		*/
		public void setAnzeige(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzAnzeige
		 _anzeige) {
			this._anzeige = _anzeige;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getDeNummer() != null) {
	                if (getDeNummer().isZustand()) {
	                    datum.getUnscaledValue("DeNummer").setText(getDeNummer().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("DeNummer").set(getDeNummer().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getAnzeigePrinzip() != null) {
	                if (getAnzeigePrinzip().isZustand()) {
	                    datum.getUnscaledValue("AnzeigePrinzip").setText(getAnzeigePrinzip().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("AnzeigePrinzip").set(getAnzeigePrinzip().getValue());
	                }
				}
				// AttributListenDefinition
					getAnzeige().bean2Atl(datum.getItem("Anzeige"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setDeNummer(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
						(daten.
							getUnscaledValue
						("DeNummer").
								shortValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("AnzeigePrinzip").isState()) {
							setAnzeigePrinzip(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
							.getZustand(daten.getScaledValue("AnzeigePrinzip").getText()));
						} else {
						setAnzeigePrinzip(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
						(daten.
							getUnscaledValue
						("AnzeigePrinzip").
								byteValue
						()));
						}
				// AttributListenDefinition
					getAnzeige().atl2Bean(daten.getItem("Anzeige"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTlsWzgWvzClusterDefinition clone() {
		AtlTlsWzgWvzClusterDefinition klon = new AtlTlsWzgWvzClusterDefinition();
		
						klon.setDeNummer(getDeNummer());
						klon.setAnzeigePrinzip(getAnzeigePrinzip());
						klon._anzeige = getAnzeige().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
