/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Einzelinformationen der Zuordnung von Lampen zu
					WVZ-Codes.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTlsWzgWvzLampenDefinition implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgZustandLampenPaar
			 _lampen
			;
	
		/**
		Zustand eines Lampenpaars, bestehen aus Haupt- und
							Nebenlampe.
		<p>
		
		</p>
		
		@return der Wert von Lampen.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgZustandLampenPaar
			 getLampen() {
			return _lampen;
		}
	
		/**
		Zustand eines Lampenpaars, bestehen aus Haupt- und
							Nebenlampe.
		<p>
		
		</p>
		
		@param _lampen der neue Wert von Lampen.
		*/
		public void setLampen(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgZustandLampenPaar
		 _lampen) {
			this._lampen = _lampen;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getLampen() != null) {
	                if (getLampen().isZustand()) {
	                    datum.getUnscaledValue("Lampen").setText(getLampen().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Lampen").set(getLampen().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Lampen").isState()) {
							setLampen(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgZustandLampenPaar
							.getZustand(daten.getScaledValue("Lampen").getText()));
						} else {
						setLampen(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgZustandLampenPaar
						(daten.
							getUnscaledValue
						("Lampen").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTlsWzgWvzLampenDefinition clone() {
		AtlTlsWzgWvzLampenDefinition klon = new AtlTlsWzgWvzLampenDefinition();
		
						klon.setLampen(getLampen());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
