/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Einzelinformationen bei der Anzeige eines Programms
					mit Statusinformationen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlTlsWzgWvzProgramm implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgProgrammNummer
			 _nummer
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzStatus
			 _status
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzStatus
			()
			;
	
		/**
		Grundprogrammnummer.
		<p>
		
		</p>
		
		@return der Wert von Nummer.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgProgrammNummer
			 getNummer() {
			return _nummer;
		}
	
		/**
		Grundprogrammnummer.
		<p>
		
		</p>
		
		@param _nummer der neue Wert von Nummer.
		*/
		public void setNummer(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgProgrammNummer
		 _nummer) {
			this._nummer = _nummer;
		}
	
		/**
		Einzelinformationen zum Fehler- und Programmzustand
							bei der Anzeige eines WVZ.
		<p>
		
		</p>
		
		@return der Wert von Status.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzStatus
			 getStatus() {
			return _status;
		}
	
		/**
		Einzelinformationen zum Fehler- und Programmzustand
							bei der Anzeige eines WVZ.
		<p>
		
		</p>
		
		@param _status der neue Wert von Status.
		*/
		public void setStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzStatus
		 _status) {
			this._status = _status;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getNummer() != null) {
	                if (getNummer().isZustand()) {
	                    datum.getUnscaledValue("Nummer").setText(getNummer().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Nummer").set(getNummer().getValue());
	                }
				}
				// AttributListenDefinition
					getStatus().bean2Atl(datum.getItem("Status"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Nummer").isState()) {
							setNummer(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgProgrammNummer
							.getZustand(daten.getScaledValue("Nummer").getText()));
						} else {
						setNummer(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgProgrammNummer
						(daten.
							getUnscaledValue
						("Nummer").
								shortValue
						()));
						}
				// AttributListenDefinition
					getStatus().atl2Bean(daten.getItem("Status"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTlsWzgWvzProgramm clone() {
		AtlTlsWzgWvzProgramm klon = new AtlTlsWzgWvzProgramm();
		
						klon.setNummer(getNummer());
						klon._status = getStatus().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
