/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Einträge von Default-Umsetzungsmodulen für
					Objekttypen bei TLS ähnlichen
					Kommunikationspartnern.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlUmsetzungsModule implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Object
			 _typ
			;
			private String
			 _umsetzungsModul
			= new String
			()
			;
	
		/**
		Pid des Objekttyps, für den die TLS-Applikation
								das folgende UmsetzungsModul als Standard
								verwenden soll.
		<p>
		
		</p>
		
		@return der Wert von Typ.
		*/
			public 	Object
			 getTyp() {
			return _typ;
		}
	
		/**
		Pid des Objekttyps, für den die TLS-Applikation
								das folgende UmsetzungsModul als Standard
								verwenden soll.
		<p>
		
		</p>
		
		@param _typ der neue Wert von Typ.
		*/
		public void setTyp(	Object
		 _typ) {
			this._typ = _typ;
		}
	
		/**
		Das für die Umsetzung des Protokolls (Lesen und
								Schreiben) verwendete Modul an diesem Knoten.
								Wird kein Modul angegeben, wird jeweils das
								Standardumsetzungmodul für diesen Objekttyp
								verwendet. Text ist der Klassennamen des
								UmsetzungsModuls.
		<p>
		
		</p>
		
		@return der Wert von UmsetzungsModul.
		*/
			public String
			 getUmsetzungsModul() {
			return _umsetzungsModul;
		}
	
		/**
		Das für die Umsetzung des Protokolls (Lesen und
								Schreiben) verwendete Modul an diesem Knoten.
								Wird kein Modul angegeben, wird jeweils das
								Standardumsetzungmodul für diesen Objekttyp
								verwendet. Text ist der Klassennamen des
								UmsetzungsModuls.
		<p>
		
		</p>
		
		@param _umsetzungsModul der neue Wert von UmsetzungsModul.
		*/
		public void setUmsetzungsModul(String
		 _umsetzungsModul) {
			if (_umsetzungsModul.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._umsetzungsModul = _umsetzungsModul;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soTyp = getTyp();
					final SystemObject tmpTyp;
						if (soTyp instanceof SystemObject) {
							tmpTyp = (SystemObject)soTyp;
						} else if(soTyp instanceof SystemObjekt){
							tmpTyp = ((SystemObjekt)soTyp).getSystemObject();
						} else{
							tmpTyp = null;
						}
					datum.getReferenceValue("Typ").setSystemObject(tmpTyp);
				// ZeichenkettenAttributTyp
				if (getUmsetzungsModul() != null) {
					datum.getTextValue("UmsetzungsModul").setText(getUmsetzungsModul());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idTyp = daten.getReferenceValue("Typ").getId();
					final SystemObjekt tmpTyp;
					if (idTyp == 0) {
						tmpTyp = null;
					} else {
						final SystemObject soTyp = factory.getDav().getDataModel().getObject(idTyp);
						if (soTyp == null) {
								tmpTyp = new BaseUngueltigesSystemObjekt(idTyp);
						} else {
							tmpTyp = factory.getModellobjekt(soTyp);
						}
					}
					setTyp((	Object
					) tmpTyp);
				// ZeichenkettenAttributTyp
					setUmsetzungsModul(daten.getTextValue("UmsetzungsModul").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlUmsetzungsModule clone() {
		AtlUmsetzungsModule klon = new AtlUmsetzungsModule();
		
						klon.setTyp(getTyp());
						klon.setUmsetzungsModul(getUmsetzungsModul());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
