/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Der Inhalt des Bytes bestimmt die Version der
					Einzelergebnismeldung, die übertragen werden soll.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 10
 */
public class AttTlsAxlDatenversionEinzelErgebnisMeldung extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsAxlDatenversionEinzelErgebnisMeldung ZUSTAND_0_RESERVIERT_AUS_ = new AttTlsAxlDatenversionEinzelErgebnisMeldung("reserviert (aus)", 		Short
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsAxlDatenversionEinzelErgebnisMeldung ZUSTAND_1_VERSION_1 = new AttTlsAxlDatenversionEinzelErgebnisMeldung("Version 1", 		Short
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsAxlDatenversionEinzelErgebnisMeldung ZUSTAND_2_VERSION_2 = new AttTlsAxlDatenversionEinzelErgebnisMeldung("Version 2", 		Short
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsAxlDatenversionEinzelErgebnisMeldung ZUSTAND_3_VERSION_3 = new AttTlsAxlDatenversionEinzelErgebnisMeldung("Version 3", 		Short
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsAxlDatenversionEinzelErgebnisMeldung ZUSTAND_255_AUS = new AttTlsAxlDatenversionEinzelErgebnisMeldung("aus", 		Short
	.valueOf("255"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsAxlDatenversionEinzelErgebnisMeldung getZustand(final 		Short
	 value) {
		for (AttTlsAxlDatenversionEinzelErgebnisMeldung e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsAxlDatenversionEinzelErgebnisMeldung getZustand(final String value) {
		for (AttTlsAxlDatenversionEinzelErgebnisMeldung e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsAxlDatenversionEinzelErgebnisMeldung> getZustaende() {
		List<AttTlsAxlDatenversionEinzelErgebnisMeldung> list = new ArrayList<AttTlsAxlDatenversionEinzelErgebnisMeldung>();
		list.add(ZUSTAND_0_RESERVIERT_AUS_);
		list.add(ZUSTAND_1_VERSION_1);
		list.add(ZUSTAND_2_VERSION_2);
		list.add(ZUSTAND_3_VERSION_3);
		list.add(ZUSTAND_255_AUS);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TLSAxlDatenversionEinzelErgebnisMeldung.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsAxlDatenversionEinzelErgebnisMeldung(final 		Short
	 value) {
		super(value);
	}
	
	private AttTlsAxlDatenversionEinzelErgebnisMeldung(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
