/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Der Inhalt des Bytes bestimmt die Version der
					ErgebnisMeldung, die übertragen werden soll. Mit dem
					Wert 255 lässt sich die Übertragung der
					ErgebnisMeldungen abschalten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttTlsAxlDatenversionErgebnisMeldung extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsAxlDatenversionErgebnisMeldung ZUSTAND_10_VERSION_10 = new AttTlsAxlDatenversionErgebnisMeldung("Version 10", 		Short
	.valueOf("10"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsAxlDatenversionErgebnisMeldung ZUSTAND_255_AUS = new AttTlsAxlDatenversionErgebnisMeldung("aus", 		Short
	.valueOf("255"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsAxlDatenversionErgebnisMeldung getZustand(final 		Short
	 value) {
		for (AttTlsAxlDatenversionErgebnisMeldung e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsAxlDatenversionErgebnisMeldung getZustand(final String value) {
		for (AttTlsAxlDatenversionErgebnisMeldung e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsAxlDatenversionErgebnisMeldung> getZustaende() {
		List<AttTlsAxlDatenversionErgebnisMeldung> list = new ArrayList<AttTlsAxlDatenversionErgebnisMeldung>();
		list.add(ZUSTAND_10_VERSION_10);
		list.add(ZUSTAND_255_AUS);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TLSAxlDatenversionErgebnisMeldung.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsAxlDatenversionErgebnisMeldung(final 		Short
	 value) {
		super(value);
	}
	
	private AttTlsAxlDatenversionErgebnisMeldung(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
