/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Gerätetyp für Kommunikation nach TLS.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttTlsGeraeteTyp extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Beliebiger Gerätetyp.
	<p>
	
	</p>
	*/
	public static final AttTlsGeraeteTyp ZUSTAND_0_STANDARD = new AttTlsGeraeteTyp("Standard", 		Byte
	.valueOf("0"));

	/**
	Gerät stellt Landesmeldestelle dar.
	<p>
	
	</p>
	*/
	public static final AttTlsGeraeteTyp ZUSTAND_1_LMST = new AttTlsGeraeteTyp("LMSt", 		Byte
	.valueOf("1"));

	/**
	Gerät ist eine VIZ.
	<p>
	
	</p>
	*/
	public static final AttTlsGeraeteTyp ZUSTAND_2_VIZ = new AttTlsGeraeteTyp("VIZ", 		Byte
	.valueOf("2"));

	/**
	Gerät ist eine VRZ.
	<p>
	
	</p>
	*/
	public static final AttTlsGeraeteTyp ZUSTAND_3_VRZ = new AttTlsGeraeteTyp("VRZ", 		Byte
	.valueOf("3"));

	/**
	Gerät ist eine UZ.
	<p>
	
	</p>
	*/
	public static final AttTlsGeraeteTyp ZUSTAND_4_UZ = new AttTlsGeraeteTyp("UZ", 		Byte
	.valueOf("4"));

	/**
	Gerät ist eine KRI.
	<p>
	
	</p>
	*/
	public static final AttTlsGeraeteTyp ZUSTAND_5_KRI = new AttTlsGeraeteTyp("KRI", 		Byte
	.valueOf("5"));

	/**
	Gerät ist ein Steuermodull.
	<p>
	
	</p>
	*/
	public static final AttTlsGeraeteTyp ZUSTAND_6_STEUERMODUL = new AttTlsGeraeteTyp("SteuerModul", 		Byte
	.valueOf("6"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsGeraeteTyp getZustand(final 		Byte
	 value) {
		for (AttTlsGeraeteTyp e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsGeraeteTyp getZustand(final String value) {
		for (AttTlsGeraeteTyp e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsGeraeteTyp> getZustaende() {
		List<AttTlsGeraeteTyp> list = new ArrayList<AttTlsGeraeteTyp>();
		list.add(ZUSTAND_0_STANDARD);
		list.add(ZUSTAND_1_LMST);
		list.add(ZUSTAND_2_VIZ);
		list.add(ZUSTAND_3_VRZ);
		list.add(ZUSTAND_4_UZ);
		list.add(ZUSTAND_5_KRI);
		list.add(ZUSTAND_6_STEUERMODUL);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TLSGeräteTyp.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsGeraeteTyp(final 		Byte
	 value) {
		super(value);
	}
	
	private AttTlsGeraeteTyp(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
