/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Erfassungsintervalldauer der Kurzzeitdaten.
<p>
Enthält den Wert der Erfassungsintervalldauer. Es
					sind nur Werte zugelassen, die ein ganzzahliges
					Vielfaches haben, welches 60 Minuten ergibt (15s,
					30s, 1, 2, 3, 4, 5, 6, 10, 12, 15, 20, 30, 60
					Minuten).
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttTlsLveErfassungsIntervalldauerKurzzeitdaten extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveErfassungsIntervalldauerKurzzeitdaten ZUSTAND_1__15_SEKUNDEN = new AttTlsLveErfassungsIntervalldauerKurzzeitdaten("15 Sekunden", 		Short
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveErfassungsIntervalldauerKurzzeitdaten ZUSTAND_2__30_SEKUNDEN = new AttTlsLveErfassungsIntervalldauerKurzzeitdaten("30 Sekunden", 		Short
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveErfassungsIntervalldauerKurzzeitdaten ZUSTAND_4__1_MINUTE = new AttTlsLveErfassungsIntervalldauerKurzzeitdaten("1 Minute", 		Short
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveErfassungsIntervalldauerKurzzeitdaten ZUSTAND_8__2_MINUTEN = new AttTlsLveErfassungsIntervalldauerKurzzeitdaten("2 Minuten", 		Short
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveErfassungsIntervalldauerKurzzeitdaten ZUSTAND_12__3_MINUTEN = new AttTlsLveErfassungsIntervalldauerKurzzeitdaten("3 Minuten", 		Short
	.valueOf("12"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveErfassungsIntervalldauerKurzzeitdaten ZUSTAND_16__4_MINUTEN = new AttTlsLveErfassungsIntervalldauerKurzzeitdaten("4 Minuten", 		Short
	.valueOf("16"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveErfassungsIntervalldauerKurzzeitdaten ZUSTAND_20__5_MINUTEN = new AttTlsLveErfassungsIntervalldauerKurzzeitdaten("5 Minuten", 		Short
	.valueOf("20"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveErfassungsIntervalldauerKurzzeitdaten ZUSTAND_24__6_MINUTEN = new AttTlsLveErfassungsIntervalldauerKurzzeitdaten("6 Minuten", 		Short
	.valueOf("24"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveErfassungsIntervalldauerKurzzeitdaten ZUSTAND_40__10_MINUTEN = new AttTlsLveErfassungsIntervalldauerKurzzeitdaten("10 Minuten", 		Short
	.valueOf("40"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveErfassungsIntervalldauerKurzzeitdaten ZUSTAND_48__12_MINUTEN = new AttTlsLveErfassungsIntervalldauerKurzzeitdaten("12 Minuten", 		Short
	.valueOf("48"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveErfassungsIntervalldauerKurzzeitdaten ZUSTAND_60__15_MINUTEN = new AttTlsLveErfassungsIntervalldauerKurzzeitdaten("15 Minuten", 		Short
	.valueOf("60"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveErfassungsIntervalldauerKurzzeitdaten ZUSTAND_80__20_MINUTEN = new AttTlsLveErfassungsIntervalldauerKurzzeitdaten("20 Minuten", 		Short
	.valueOf("80"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveErfassungsIntervalldauerKurzzeitdaten ZUSTAND_120__30_MINUTEN = new AttTlsLveErfassungsIntervalldauerKurzzeitdaten("30 Minuten", 		Short
	.valueOf("120"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveErfassungsIntervalldauerKurzzeitdaten ZUSTAND_240__60_MINUTEN = new AttTlsLveErfassungsIntervalldauerKurzzeitdaten("60 Minuten", 		Short
	.valueOf("240"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsLveErfassungsIntervalldauerKurzzeitdaten getZustand(final 		Short
	 value) {
		for (AttTlsLveErfassungsIntervalldauerKurzzeitdaten e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsLveErfassungsIntervalldauerKurzzeitdaten getZustand(final String value) {
		for (AttTlsLveErfassungsIntervalldauerKurzzeitdaten e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsLveErfassungsIntervalldauerKurzzeitdaten> getZustaende() {
		List<AttTlsLveErfassungsIntervalldauerKurzzeitdaten> list = new ArrayList<AttTlsLveErfassungsIntervalldauerKurzzeitdaten>();
		list.add(ZUSTAND_1__15_SEKUNDEN);
		list.add(ZUSTAND_2__30_SEKUNDEN);
		list.add(ZUSTAND_4__1_MINUTE);
		list.add(ZUSTAND_8__2_MINUTEN);
		list.add(ZUSTAND_12__3_MINUTEN);
		list.add(ZUSTAND_16__4_MINUTEN);
		list.add(ZUSTAND_20__5_MINUTEN);
		list.add(ZUSTAND_24__6_MINUTEN);
		list.add(ZUSTAND_40__10_MINUTEN);
		list.add(ZUSTAND_48__12_MINUTEN);
		list.add(ZUSTAND_60__15_MINUTEN);
		list.add(ZUSTAND_80__20_MINUTEN);
		list.add(ZUSTAND_120__30_MINUTEN);
		list.add(ZUSTAND_240__60_MINUTEN);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TLSLveErfassungsIntervalldauerKurzzeitdaten.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsLveErfassungsIntervalldauerKurzzeitdaten(final 		Short
	 value) {
		super(value);
	}
	
	private AttTlsLveErfassungsIntervalldauerKurzzeitdaten(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
