/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Erfassungsintervalldauer der Kurzzeitdaten.
<p>
Die Erfassungsintervalldauer wird in folgenden
					Vielfachen von 15 sec kodiert: 15s [1], 30s [2], 60s
					[4] und 120s [8]. Eine Erfassungsintervalldauer
					größer als 2 Minuten erscheint aufgrund des
					technischen Verfahrens nicht sinnvoll und sollte
					zentralenseitig durch Mittelwertbildung gewonnen
					werden.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttTlsSVEErfassungsIntervalldauer extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSVEErfassungsIntervalldauer ZUSTAND_1__15_SEKUNDEN = new AttTlsSVEErfassungsIntervalldauer("15 Sekunden", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSVEErfassungsIntervalldauer ZUSTAND_2__30_SEKUNDEN = new AttTlsSVEErfassungsIntervalldauer("30 Sekunden", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSVEErfassungsIntervalldauer ZUSTAND_4__1_MINUTE = new AttTlsSVEErfassungsIntervalldauer("1 Minute", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSVEErfassungsIntervalldauer ZUSTAND_8__2_MINUTEN = new AttTlsSVEErfassungsIntervalldauer("2 Minuten", 		Byte
	.valueOf("8"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsSVEErfassungsIntervalldauer getZustand(final 		Byte
	 value) {
		for (AttTlsSVEErfassungsIntervalldauer e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsSVEErfassungsIntervalldauer getZustand(final String value) {
		for (AttTlsSVEErfassungsIntervalldauer e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsSVEErfassungsIntervalldauer> getZustaende() {
		List<AttTlsSVEErfassungsIntervalldauer> list = new ArrayList<AttTlsSVEErfassungsIntervalldauer>();
		list.add(ZUSTAND_1__15_SEKUNDEN);
		list.add(ZUSTAND_2__30_SEKUNDEN);
		list.add(ZUSTAND_4__1_MINUTE);
		list.add(ZUSTAND_8__2_MINUTEN);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TLSSVEErfassungsIntervalldauer.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsSVEErfassungsIntervalldauer(final 		Byte
	 value) {
		super(value);
	}
	
	private AttTlsSVEErfassungsIntervalldauer(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
