/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zustand der Fahrbahnoberfläche.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Wertebereich(
	minimum = 0L,
	maximum = 255L,
	einheit = ""
)
public class AttTlsUfdFahrbahnoberflaeche extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MIN_VALUE =
				Short
		.valueOf("0");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MAX_VALUE =
				Short
		.valueOf("255");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsUfdFahrbahnoberflaeche ZUSTAND_0_TROCKEN = new AttTlsUfdFahrbahnoberflaeche("trocken", 		Short
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsUfdFahrbahnoberflaeche ZUSTAND_1_NASS = new AttTlsUfdFahrbahnoberflaeche("naß", 		Short
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsUfdFahrbahnoberflaeche ZUSTAND_2_TROCKEN_SCHNEEBEDECKT = new AttTlsUfdFahrbahnoberflaeche("trocken/schneebedeckt", 		Short
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsUfdFahrbahnoberflaeche ZUSTAND_3_NASS_SCHNEEBEDECKT = new AttTlsUfdFahrbahnoberflaeche("naß/schneebedeckt", 		Short
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsUfdFahrbahnoberflaeche ZUSTAND_5_FEUCHTE_1 = new AttTlsUfdFahrbahnoberflaeche("Feuchte 1", 		Short
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsUfdFahrbahnoberflaeche ZUSTAND_9_FEUCHTE_2 = new AttTlsUfdFahrbahnoberflaeche("Feuchte 2", 		Short
	.valueOf("9"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsUfdFahrbahnoberflaeche ZUSTAND_13_FEUCHTE_3 = new AttTlsUfdFahrbahnoberflaeche("Feuchte 3", 		Short
	.valueOf("13"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsUfdFahrbahnoberflaeche ZUSTAND_7_FEUCHTE_1_SCHNEEBEDECKT = new AttTlsUfdFahrbahnoberflaeche("Feuchte 1/schneebedeckt", 		Short
	.valueOf("7"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsUfdFahrbahnoberflaeche ZUSTAND_11_FEUCHTE_2_SCHNEEBEDECKT = new AttTlsUfdFahrbahnoberflaeche("Feuchte 2/schneebedeckt", 		Short
	.valueOf("11"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsUfdFahrbahnoberflaeche ZUSTAND_15_FEUCHTE_3_SCHNEEBEDECKT = new AttTlsUfdFahrbahnoberflaeche("Feuchte 3/schneebedeckt", 		Short
	.valueOf("15"));

	/**
	Daten sind nicht ermittelbar (ist KEIN
								Fehler).
	<p>
	Wird gesetzt, wenn der entsprechende Wert
								nicht ermittelbar ist und kein Interpolation
								sinnvoll möglich ist (z.B. ist die
								Geschwindigkeit nicht ermittelbar, wenn kein
								Fahrzeug erfasst wurde).
	</p>
	*/
	public static final AttTlsUfdFahrbahnoberflaeche ZUSTAND_255_NICHT_ERMITTELBAR = new AttTlsUfdFahrbahnoberflaeche("nicht ermittelbar", 		Short
	.valueOf("255"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsUfdFahrbahnoberflaeche getZustand(final 		Short
	 value) {
		for (AttTlsUfdFahrbahnoberflaeche e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsUfdFahrbahnoberflaeche getZustand(final String value) {
		for (AttTlsUfdFahrbahnoberflaeche e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsUfdFahrbahnoberflaeche> getZustaende() {
		List<AttTlsUfdFahrbahnoberflaeche> list = new ArrayList<AttTlsUfdFahrbahnoberflaeche>();
		list.add(ZUSTAND_0_TROCKEN);
		list.add(ZUSTAND_1_NASS);
		list.add(ZUSTAND_2_TROCKEN_SCHNEEBEDECKT);
		list.add(ZUSTAND_3_NASS_SCHNEEBEDECKT);
		list.add(ZUSTAND_5_FEUCHTE_1);
		list.add(ZUSTAND_9_FEUCHTE_2);
		list.add(ZUSTAND_13_FEUCHTE_3);
		list.add(ZUSTAND_7_FEUCHTE_1_SCHNEEBEDECKT);
		list.add(ZUSTAND_11_FEUCHTE_2_SCHNEEBEDECKT);
		list.add(ZUSTAND_15_FEUCHTE_3_SCHNEEBEDECKT);
		list.add(ZUSTAND_255_NICHT_ERMITTELBAR);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TLSUfdFahrbahnoberfläche.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsUfdFahrbahnoberflaeche(final 		Short
	 value) {
		super(value);
	}
	
	private AttTlsUfdFahrbahnoberflaeche(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
